/*
 * Decompiled with CFR 0.152.
 */
package de.knightsoftnet.validators.annotation.processor;

import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import de.knightsoftnet.validators.annotation.processor.TypeElementConstraintDescriptor;
import de.knightsoftnet.validators.annotation.processor.TypeElementPropertyDescriptor;
import de.knightsoftnet.validators.annotation.processor.TypeElementPropertyDescriptorImpl;
import de.knightsoftnet.validators.annotation.processor.TypeUtils;
import de.knightsoftnet.validators.annotation.processor.Utf8Control;
import de.knightsoftnet.validators.annotation.processor.ValidationMessagesMap;
import de.knightsoftnet.validators.client.impl.metadata.BeanMetadata;
import java.io.IOException;
import java.io.PrintWriter;
import java.lang.annotation.ElementType;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.MissingResourceException;
import java.util.Objects;
import java.util.Optional;
import java.util.ResourceBundle;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.annotation.processing.FilerException;
import javax.annotation.processing.ProcessingEnvironment;
import javax.lang.model.element.AnnotationMirror;
import javax.lang.model.element.AnnotationValue;
import javax.lang.model.element.Element;
import javax.lang.model.element.ElementKind;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.Modifier;
import javax.lang.model.element.TypeElement;
import javax.lang.model.element.VariableElement;
import javax.lang.model.type.ArrayType;
import javax.lang.model.type.DeclaredType;
import javax.lang.model.type.ExecutableType;
import javax.lang.model.type.TypeKind;
import javax.lang.model.type.TypeMirror;
import javax.tools.Diagnostic;
import javax.tools.JavaFileObject;
import javax.validation.Constraint;
import javax.validation.GroupSequence;
import javax.validation.UnexpectedTypeException;
import javax.validation.groups.Default;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.RegExUtils;
import org.apache.commons.lang3.StringEscapeUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.tuple.Pair;
import org.hibernate.validator.internal.metadata.core.ConstraintOrigin;
import org.hibernate.validator.internal.metadata.location.ConstraintLocation;

public class GwtSpecificValidatorClassCreator {
    private static final String DEFAULT_VIOLATION_VAR = "violations";
    private final Set<TypeMirror> additionalInterfacesToCreate = Sets.newConcurrentHashSet();
    private final Set<Element> fieldsToWrap = Sets.newHashSet();
    private final Set<ExecutableElement> gettersToWrap = Sets.newHashSet();
    private final Map<TypeElementConstraintDescriptor<?>, Boolean> validTypeElementConstraintsMap = Maps.newHashMap();
    private final Set<String> validGroupsTypeMirror;
    private final ProcessingEnvironment processingEnv;
    private final boolean forceUsingGetter;
    private final boolean generateReflectionGetter;

    public GwtSpecificValidatorClassCreator(ProcessingEnvironment processingEnv, Set<TypeMirror> validGroups, boolean forceUsingGetter, boolean generateReflectionGetter, String[] languages) {
        this.processingEnv = processingEnv;
        this.forceUsingGetter = forceUsingGetter;
        this.generateReflectionGetter = generateReflectionGetter;
        this.validGroupsTypeMirror = validGroups.stream().map(TypeMirror::toString).collect(Collectors.toSet());
        this.readValidationMessages(Arrays.asList(languages));
    }

    private void readValidationMessages(List<String> languages) {
        if (ValidationMessagesMap.isEmpty()) {
            languages.stream().map(Locale::forLanguageTag).forEach(this::readValidationMessages);
        }
    }

    private void readValidationMessages(Locale locale) {
        ResourceBundle bundle = null;
        try {
            bundle = ResourceBundle.getBundle("ValidationMessages", locale, new Utf8Control());
        }
        catch (MissingResourceException e) {
            try {
                bundle = ResourceBundle.getBundle("org.hibernate.validator.ValidationMessages", locale, new Utf8Control());
            }
            catch (MissingResourceException e2) {
                return;
            }
        }
        if (bundle == null || !bundle.getKeys().hasMoreElements()) {
            return;
        }
        Enumeration<String> keys = bundle.getKeys();
        while (keys.hasMoreElements()) {
            String key = keys.nextElement();
            String value = bundle.getString(key);
            ValidationMessagesMap.addMessage(key, locale, value);
        }
    }

    public Set<TypeMirror> writeClass(TypeMirror typeMirror) {
        this.fieldsToWrap.clear();
        this.gettersToWrap.clear();
        String packageToGenerate = this.processingEnv.getElementUtils().getPackageOf(this.processingEnv.getTypeUtils().asElement(typeMirror)).getQualifiedName().toString();
        String classToGenerate = TypeUtils.getValidationClassForType(typeMirror, this.processingEnv.getTypeUtils(), this.processingEnv.getElementUtils());
        try {
            JavaFileObject builderFile = this.processingEnv.getFiler().createSourceFile(packageToGenerate + "." + classToGenerate, new Element[0]);
            try (PrintWriter out = new PrintWriter(builderFile.openWriter());){
                this.writeClassHeader(out, typeMirror);
                out.println();
                this.writeClassBody(out, typeMirror);
                out.println();
                this.writeClassFooter(out);
            }
        }
        catch (FilerException e) {
            this.processingEnv.getMessager().printMessage(Diagnostic.Kind.NOTE, e.getMessage());
        }
        catch (IOException | UnexpectedTypeException e) {
            this.processingEnv.getMessager().printMessage(Diagnostic.Kind.ERROR, e.getMessage());
            e.printStackTrace();
        }
        return this.additionalInterfacesToCreate;
    }

    private static String asLiteral(Object value) throws IllegalArgumentException {
        return GwtSpecificValidatorClassCreator.asLiteral(value, null);
    }

    private static String asLiteral(Object value, TypeMirror type) throws IllegalArgumentException {
        if (value == null) {
            return "null";
        }
        Class<?> clazz = value.getClass();
        if (clazz.isArray()) {
            StringBuilder sb = new StringBuilder();
            Object[] array = (Object[])value;
            sb.append("new " + clazz.getComponentType().getCanonicalName() + "[] {");
            boolean first = true;
            for (Object object : array) {
                if (first) {
                    first = false;
                } else {
                    sb.append(',');
                }
                sb.append(GwtSpecificValidatorClassCreator.asLiteral(object, type));
            }
            sb.append('}');
            return sb.toString();
        }
        if (value instanceof Boolean) {
            return Objects.toString(value);
        }
        if (value instanceof Byte) {
            return Objects.toString(value) + "Y";
        }
        if (value instanceof Short) {
            return Objects.toString(value) + "S";
        }
        if (value instanceof Character) {
            return '\'' + StringEscapeUtils.escapeJava((String)Objects.toString(value)) + '\'';
        }
        if (value instanceof Class) {
            return ((Class)value).getCanonicalName() + ".class";
        }
        if (value instanceof Double) {
            return Objects.toString(value) + "D";
        }
        if (value instanceof Enum) {
            return value.getClass().getCanonicalName() + "." + ((Enum)value).name();
        }
        if (value instanceof Float) {
            return Objects.toString(value) + "F";
        }
        if (value instanceof Integer) {
            return Objects.toString(value);
        }
        if (value instanceof Long) {
            return Objects.toString(value) + "L";
        }
        if (value instanceof String) {
            return '\"' + StringEscapeUtils.escapeJava((String)((String)value)) + '\"';
        }
        if (value instanceof TypeMirror) {
            switch (((TypeMirror)value).getKind()) {
                case ARRAY: {
                    return GwtSpecificValidatorClassCreator.asLiteral(((ArrayType)value).getComponentType(), type);
                }
                case EXECUTABLE: {
                    return GwtSpecificValidatorClassCreator.asLiteral(((ExecutableType)value).getReturnType(), type);
                }
            }
            return TypeUtils.getClassName((TypeMirror)value) + ".class";
        }
        if (value instanceof Collection) {
            StringBuilder sb = new StringBuilder();
            Collection list = (Collection)value;
            sb.append("new ");
            String classString = type == null ? "java.lang.Class" : RegExUtils.replacePattern((String)StringUtils.removeEnd((String)GwtSpecificValidatorClassCreator.asLiteral(type), (String)".class"), (String)"^java\\.lang\\.Class<.*>$", (String)"java.lang.Class");
            sb.append(classString);
            sb.append("[] {");
            boolean first = true;
            for (Object object : list) {
                if (first) {
                    first = false;
                } else {
                    sb.append(',');
                }
                sb.append("\n              ");
                sb.append(GwtSpecificValidatorClassCreator.asLiteral(object, type));
            }
            sb.append('}');
            return sb.toString();
        }
        if (value instanceof AnnotationMirror) {
            AnnotationMirror annotation = (AnnotationMirror)value;
            StringBuilder sb = new StringBuilder();
            sb.append("new ");
            sb.append(annotation.getAnnotationType().toString());
            sb.append("() {\n");
            sb.append("              @Override\n");
            sb.append("              public Class<? extends Annotation> annotationType() {\n");
            sb.append("                return null;\n");
            sb.append("              }\n\n");
            for (Map.Entry<? extends ExecutableElement, ? extends AnnotationValue> elementeValue : annotation.getElementValues().entrySet()) {
                sb.append("              @Override\n");
                sb.append("              public ");
                sb.append(TypeUtils.getClassNameWithProperties(elementeValue.getKey().getReturnType()));
                sb.append(" ");
                sb.append(elementeValue.getKey().toString());
                sb.append(" {\n");
                sb.append("                return ");
                sb.append(GwtSpecificValidatorClassCreator.asLiteral(elementeValue.getValue().getValue(), elementeValue.getKey().getReturnType()));
                sb.append(";\n");
                sb.append("              }\n\n");
            }
            sb.append("              }");
            return sb.toString();
        }
        if (type != null) {
            switch (type.getKind()) {
                case EXECUTABLE: {
                    return GwtSpecificValidatorClassCreator.asLiteral(value, ((ExecutableType)type).getReturnType());
                }
                case DECLARED: {
                    return TypeUtils.getClassName(type) + "." + value.toString();
                }
            }
            return value.toString();
        }
        throw new IllegalArgumentException(value.getClass() + " can not be represented as a Java Literal.");
    }

    private void writeClassHeader(PrintWriter out, TypeMirror typeMirror) {
        out.print("package ");
        out.print(this.processingEnv.getElementUtils().getPackageOf(this.processingEnv.getTypeUtils().asElement(typeMirror)).getQualifiedName().toString());
        out.println(";");
        out.println();
        out.println("import de.knightsoftnet.validators.client.impl.AbstractGwtSpecificValidator;");
        out.println("import de.knightsoftnet.validators.client.impl.ConstraintDescriptorImpl;");
        out.println("import de.knightsoftnet.validators.client.impl.Group;");
        out.println("import de.knightsoftnet.validators.client.impl.GroupChain;");
        out.println("import de.knightsoftnet.validators.client.impl.GroupChainGenerator;");
        out.println("import de.knightsoftnet.validators.client.impl.GwtBeanDescriptor;");
        out.println("import de.knightsoftnet.validators.client.impl.GwtBeanDescriptorImpl;");
        out.println("import de.knightsoftnet.validators.client.impl.GwtValidationContext;");
        out.println("import de.knightsoftnet.validators.client.impl.metadata.BeanMetadata;");
        out.println("import de.knightsoftnet.validators.client.impl.metadata.ValidationGroupsMetadata;");
        out.println("import de.knightsoftnet.validators.client.impl.PropertyDescriptorImpl;");
        out.println();
        out.println("import org.hibernate.validator.internal.engine.path.PathImpl;");
        out.println();
        out.println("import java.lang.annotation.Annotation;");
        out.println("import java.lang.IllegalArgumentException;");
        out.println("import java.util.ArrayList;");
        out.println("import java.util.Collection;");
        out.println("import java.util.HashSet;");
        out.println("import java.util.Iterator;");
        out.println("import java.util.List;");
        out.println("import java.util.Set;");
        out.println("import java.util.stream.Collectors;");
        out.println("import java.util.stream.Stream;");
        out.println();
        out.println("import javax.validation.ConstraintViolation;");
        out.println("import javax.validation.Path.Node;");
        out.println("import javax.validation.ValidationException;");
        out.println();
        out.print("public class ");
        out.println(TypeUtils.getValidationClassForType(typeMirror, this.processingEnv.getTypeUtils(), this.processingEnv.getElementUtils()));
        out.print("    extends AbstractGwtSpecificValidator<");
        out.print(TypeUtils.getClassNameWithProperties(typeMirror));
        out.println(">");
        out.print("    implements ");
        out.print(TypeUtils.getValidationInterfaceForType(typeMirror, this.processingEnv.getTypeUtils()));
        out.print(" {");
    }

    protected void writeClassBody(PrintWriter out, TypeMirror typeMirror) throws UnexpectedTypeException {
        List<String> annotationParameters;
        this.writeFields(out, typeMirror);
        out.println();
        this.writeValidateClassGroups(out, typeMirror);
        out.println();
        this.writeExpandDefaultAndValidateClassGroups(out, typeMirror);
        out.println();
        this.writeExpandDefaultAndValidatePropertyGroups(out, typeMirror);
        out.println();
        this.writeExpandDefaultAndValidateValueGroups(out, typeMirror);
        out.println();
        this.writeValidatePropertyGroups(out, typeMirror);
        out.println();
        this.writeValidateValueGroups(out, typeMirror);
        out.println();
        this.writeGetBeanMetadata(out);
        out.println();
        this.writeGetDescriptor(out, typeMirror);
        out.println();
        this.writePropertyValidators(out, typeMirror);
        out.println();
        this.writeValidateAllNonInheritedProperties(out, typeMirror);
        out.println();
        if (!this.forceUsingGetter) {
            this.writeWrappers(out, typeMirror);
            out.println();
        }
        if (TypeUtils.isBeanConstrained(typeMirror, this.processingEnv.getTypeUtils(), this.processingEnv.getElementUtils()) && this.generateReflectionGetter && CollectionUtils.isNotEmpty(annotationParameters = this.detectAnnotationStringParameters(typeMirror))) {
            this.writeReflectionGetterReplacement(out, typeMirror, annotationParameters);
        }
    }

    private void writeClassFooter(PrintWriter out) {
        out.println("}");
    }

    private void writeFields(PrintWriter out, TypeMirror typeMirror) throws UnexpectedTypeException {
        out.println("  private static final java.util.List<String> ALL_PROPERTY_NAMES = ");
        out.println("      java.util.Collections.<String>unmodifiableList(");
        out.print("          java.util.Arrays.<String>asList(");
        out.print(TypeUtils.getGetterNames(typeMirror).stream().map(getter -> "\"" + TypeUtils.valueFromGetter(getter) + "\"").collect(Collectors.joining(",")));
        out.println("));");
        this.writeBeanMetadata(out, typeMirror);
        out.println();
        for (TypeElementPropertyDescriptor p : TypeUtils.getTypeElementProperties(typeMirror, this.processingEnv.getElementUtils())) {
            int count = 0;
            for (TypeElementConstraintDescriptor<?> constraint : p.getConstraintDescriptors()) {
                if (!this.areConstraintDescriptorGroupsValid(constraint)) continue;
                this.writeConstraintDescriptor(out, constraint, constraint.getConstraintLocationKind().getElementType(), constraint.getDefinedOn(), this.constraintDescriptorVar(p.getPropertyName(), count++), p);
            }
            this.writePropertyDescriptor(out, p);
        }
        int count = 0;
        for (TypeElementConstraintDescriptor<?> constraint : TypeUtils.getTypeElementConstraintDescriptors(typeMirror, this.processingEnv.getElementUtils(), this.processingEnv.getTypeUtils())) {
            if (!this.areConstraintDescriptorGroupsValid(constraint)) continue;
            this.writeConstraintDescriptor(out, constraint, ElementType.TYPE, constraint.getDefinedOn(), this.constraintDescriptorVar("this", count++), new TypeElementPropertyDescriptorImpl(this.processingEnv.getTypeUtils().asElement(typeMirror), this.processingEnv.getElementUtils(), ConstraintLocation.ConstraintLocationKind.TYPE));
        }
        this.writeBeanDescriptor(out, typeMirror);
        out.println();
    }

    private boolean isIterableOrMap(TypeMirror elementClass) {
        if (elementClass.getKind() == TypeKind.ARRAY) {
            return true;
        }
        return this.typeMirrorIsOrHasInterface(elementClass, "java.lang.Iterable") || this.typeMirrorIsOrHasInterface(elementClass, "java.util.Map");
    }

    private boolean isMap(TypeMirror elementClass) {
        return this.typeMirrorIsOrHasInterface(elementClass, "java.util.Map");
    }

    private boolean isList(TypeMirror elementClass) {
        return this.typeMirrorIsOrHasInterface(elementClass, "java.util.List");
    }

    private boolean typeMirrorIsOrHasInterface(TypeMirror elementClass, String className) {
        List interfaceNames = TypeUtils.getInterfaces(elementClass).stream().map(TypeUtils::getClassName).collect(Collectors.toList());
        return interfaceNames.contains(className) || className.equals(TypeUtils.getClassName(elementClass));
    }

    private void writeExpandDefaultAndValidateClassGroups(PrintWriter out, TypeMirror typeMirror) throws UnexpectedTypeException {
        out.println("  public <T> void expandDefaultAndValidateClassGroups(");
        out.println("      final GwtValidationContext<T> context,");
        out.print("      final ");
        out.println(TypeUtils.getClassNameWithProperties(typeMirror) + " object,");
        out.println("      final Set<ConstraintViolation<T>> violations,");
        out.println("      final Group... groups) {");
        this.writeExpandDefaultAndValidate(out, typeMirror, Stage.OBJECT);
        out.println("  }");
    }

    private void writeExpandDefaultAndValidatePropertyGroups(PrintWriter out, TypeMirror typeMirror) throws UnexpectedTypeException {
        out.println("  public <T> void expandDefaultAndValidatePropertyGroups(");
        out.println("      final GwtValidationContext<T> context,");
        out.print("      final ");
        out.println(TypeUtils.getClassNameWithProperties(typeMirror) + " object,");
        out.println("      final String propertyName,");
        out.println("      final Set<ConstraintViolation<T>> violations,");
        out.println("      final Group... groups) {");
        this.writeExpandDefaultAndValidate(out, typeMirror, Stage.PROPERTY);
        out.println("  }");
    }

    private void writeExpandDefaultAndValidateValueGroups(PrintWriter out, TypeMirror typeMirror) throws UnexpectedTypeException {
        out.println("  public <T> void expandDefaultAndValidateValueGroups(");
        out.println("      final GwtValidationContext<T> context,");
        out.println("      final Class<" + TypeUtils.getClassNameWithProperties(typeMirror) + "> beanType,");
        out.println("      final String propertyName,");
        out.println("      final Object value,");
        out.println("      final Set<ConstraintViolation<T>> violations,");
        out.println("      final Group... groups) {");
        this.writeExpandDefaultAndValidate(out, typeMirror, Stage.VALUE);
        out.println("  }");
    }

    private void writeValidatePropertyGroups(PrintWriter out, TypeMirror typeMirror) throws UnexpectedTypeException {
        out.println("  public <T> void validatePropertyGroups(");
        out.println("      final GwtValidationContext<T> context,");
        out.print("      final ");
        out.println(TypeUtils.getClassNameWithProperties(typeMirror) + " object,");
        out.println("      final String propertyName,");
        out.println("      final Set<ConstraintViolation<T>> violations,");
        out.println("      final Class<?>... groups) throws ValidationException {");
        out.println("    switch (propertyName) {");
        for (TypeElementPropertyDescriptor property : TypeUtils.getTypeElementProperties(typeMirror, this.processingEnv.getElementUtils())) {
            out.print("      case \"");
            out.print(property.getPropertyName());
            out.println("\":");
            this.writeValidatePropertyCall(out, typeMirror, property, false, false, "        ");
            this.writeValidateInheritance(out, typeMirror, Stage.PROPERTY, property);
            out.println("        break;");
        }
        this.writeDefaultNameNotFound(out, typeMirror);
        out.println("    }");
        out.println("  }");
    }

    private void writeValidateValueGroups(PrintWriter out, TypeMirror typeMirror) throws UnexpectedTypeException {
        out.println("  public <T> void validateValueGroups(");
        out.println("      final GwtValidationContext<T> context,");
        out.println("      final Class<" + TypeUtils.getClassNameWithProperties(typeMirror) + "> beanType,");
        out.println("      final String propertyName,");
        out.println("      final Object value,");
        out.println("      final Set<ConstraintViolation<T>> violations,");
        out.println("      final Class<?>... groups) {");
        out.println("    switch (propertyName) {");
        for (TypeElementPropertyDescriptor property : TypeUtils.getTypeElementProperties(typeMirror, this.processingEnv.getElementUtils())) {
            out.print("      case \"");
            out.print(property.getPropertyName());
            out.println("\":");
            if (!this.isIterableOrMap(property.getElementType())) {
                this.writeValidatePropertyCall(out, typeMirror, property, true, false, "        ");
            }
            this.writeValidateInheritance(out, typeMirror, Stage.VALUE, property);
            out.println("        break;");
        }
        this.writeDefaultNameNotFound(out, typeMirror);
        out.println("    }");
        out.println("  }");
    }

    private void writeGetBeanMetadata(PrintWriter out) {
        out.println("  public BeanMetadata getBeanMetadata() {");
        out.println("    return beanMetadata;");
        out.println("  }");
    }

    private void writeGetDescriptor(PrintWriter out, TypeMirror typeMirror) {
        out.print("  public ");
        out.print("GwtBeanDescriptor<" + TypeUtils.getClassNameWithProperties(typeMirror) + "> ");
        out.println("getConstraints(");
        out.println("      final ValidationGroupsMetadata validationGroupsMetadata) {");
        out.println("    beanDescriptor.setValidationGroupsMetadata(validationGroupsMetadata);");
        out.println("    return beanDescriptor;");
        out.println("  }");
    }

    private void writePropertyValidators(PrintWriter out, TypeMirror typeMirror) throws UnexpectedTypeException {
        for (TypeElementPropertyDescriptor propertyDescriptor : TypeUtils.getTypeElementProperties(typeMirror, this.processingEnv.getElementUtils())) {
            if (TypeUtils.hasField(typeMirror, propertyDescriptor.getPropertyName())) {
                Optional<Element> optionalGenericFieldType = TypeUtils.fieldElementByName(typeMirror, propertyDescriptor.getPropertyName());
                if (optionalGenericFieldType.isPresent()) {
                    this.writeValidatePropertyMethod(out, typeMirror, propertyDescriptor, optionalGenericFieldType.get().asType(), true);
                }
                out.println();
            }
            if (!TypeUtils.hasGetter(typeMirror, propertyDescriptor.getPropertyName())) continue;
            Optional<ExecutableElement> optionalGetter = TypeUtils.getGetter(typeMirror, propertyDescriptor.getPropertyName());
            if (optionalGetter.isPresent()) {
                this.writeValidatePropertyMethod(out, typeMirror, propertyDescriptor, optionalGetter.get().getReturnType(), false);
            }
            out.println();
        }
    }

    private void writeValidateAllNonInheritedProperties(PrintWriter out, TypeMirror typeMirror) {
        out.println("  private <T> void validateAllNonInheritedProperties(");
        out.println("      final GwtValidationContext<T> context,");
        out.print("      final ");
        out.print(TypeUtils.getClassNameWithProperties(typeMirror));
        out.println(" object,");
        out.println("      final Set<ConstraintViolation<T>> violations,");
        out.println("      final Class<?>... groups) {");
        if (TypeUtils.isBeanConstrained(typeMirror, this.processingEnv.getTypeUtils(), this.processingEnv.getElementUtils()) && this.generateReflectionGetter && CollectionUtils.isNotEmpty(this.detectAnnotationStringParameters(typeMirror))) {
            out.print("    ");
            out.println("de.knightsoftnet.validators.client.GwtReflectorMap.put(object.getClass(),");
            out.println("        generateReflectionGetterReplacementMap(object));");
        }
        for (TypeElementPropertyDescriptor p : TypeUtils.getTypeElementProperties(typeMirror, this.processingEnv.getElementUtils())) {
            this.writeValidatePropertyCall(out, typeMirror, p, false, true, "    ");
        }
        out.println("  }");
    }

    private void writeValidatePropertyMethod(PrintWriter out, TypeMirror typeMirror, TypeElementPropertyDescriptor ppropertyDescription, TypeMirror pelementType, boolean useField) throws UnexpectedTypeException {
        if (!this.isPropertyConstrained(ppropertyDescription, typeMirror, useField)) {
            return;
        }
        TypeMirror elementClassType = ppropertyDescription.getElementType();
        out.print("  private final <T> void ");
        if (useField) {
            out.print(this.validateMethodFieldName(ppropertyDescription));
        } else {
            out.print(this.validateMethodGetterName(ppropertyDescription));
        }
        out.println("(");
        out.println("      final GwtValidationContext<T> context,");
        out.println("      final Set<ConstraintViolation<T>> violations,");
        out.print("      final ");
        out.println(TypeUtils.getClassNameWithProperties(typeMirror) + " object,");
        out.print("      final ");
        out.print(TypeUtils.getClassNameWithProperties(TypeUtils.fieldType(typeMirror, ppropertyDescription.getPropertyName()).get()));
        out.println(" value,");
        out.println("      final boolean honorValid,");
        out.println("      final Class<?>... groups) {");
        out.print("    final GwtValidationContext<T> myContext = context.append(\"");
        out.print(ppropertyDescription.getPropertyName());
        out.println("\");");
        out.println("    final Node leafNode = myContext.getPath().getLeafNode();");
        out.println("    final PathImpl path = PathImpl.createCopyWithoutLeafNode(myContext.getPath());");
        out.println("    boolean isReachable;");
        out.println("    try {");
        out.println("      isReachable = myContext.getTraversableResolver().isReachable(object, leafNode,");
        out.println("          myContext.getRootBeanClass(), path, " + (useField ? GwtSpecificValidatorClassCreator.asLiteral((Object)ElementType.FIELD) : GwtSpecificValidatorClassCreator.asLiteral((Object)ElementType.METHOD)) + ");");
        out.println("    } catch (Exception e) {");
        out.println("      throw new ValidationException(\"TraversableResolver isReachable caused an exception\", e);");
        out.println("    }");
        out.println("    if (isReachable) {");
        if (ppropertyDescription.isCascaded() && this.hasValid(ppropertyDescription, typeMirror, useField)) {
            out.println("      if (honorValid && value != null) {");
            out.println("        boolean isCascadable;");
            out.println("        try {");
            out.println("          isCascadable = myContext.getTraversableResolver().isCascadable(object, leafNode,");
            out.println("              myContext.getRootBeanClass(), path, " + (useField ? GwtSpecificValidatorClassCreator.asLiteral((Object)ElementType.FIELD) : GwtSpecificValidatorClassCreator.asLiteral((Object)ElementType.METHOD)) + ");");
            out.println("        } catch (Exception e) {");
            out.println("          throw new ValidationException(\"TraversableResolver isCascadable caused an exception\", e);");
            out.println("        }");
            out.println("        if (isCascadable) {");
            if (this.isIterableOrMap(elementClassType)) {
                if (this.isMap(elementClassType)) {
                    this.writeValidateMap(out, ppropertyDescription, elementClassType);
                } else {
                    this.writeValidateIterable(out, ppropertyDescription, elementClassType);
                }
            } else {
                Optional<TypeMirror> elementType = TypeUtils.fieldType(typeMirror, ppropertyDescription.getPropertyName());
                if (elementType.isPresent()) {
                    this.additionalInterfacesToCreate.add(elementType.get());
                }
                out.println("          if (!context.alreadyValidated(value)) {");
                out.print("            violations.addAll(");
                out.print(TypeUtils.getValidationInstanceForType(elementClassType, this.processingEnv.getTypeUtils(), this.processingEnv.getElementUtils()));
                out.println(".validate(");
                out.print("                myContext, (");
                out.print(TypeUtils.getClassNameWithProperties(elementClassType));
                out.println(") value, groups));");
                out.println("          }");
            }
            out.println("        }");
            out.println("      }");
        }
        HashSet includedAnnotations = Sets.newHashSet();
        int count = 0;
        for (TypeElementConstraintDescriptor<?> constraint : ppropertyDescription.getConstraintDescriptors()) {
            if (!this.areConstraintDescriptorGroupsValid(constraint)) continue;
            Object annotation = constraint.getAnnotation();
            if (this.hasMatchingAnnotation(ppropertyDescription, typeMirror, useField, constraint)) {
                String constraintDescriptorVar = this.constraintDescriptorVar(ppropertyDescription.getPropertyName(), count);
                if (includedAnnotations.contains(annotation)) {
                    if (!useField) {
                        this.writeValidateConstraint(out, ppropertyDescription, elementClassType, pelementType, constraint, constraintDescriptorVar);
                    }
                } else if (useField) {
                    this.writeValidateConstraint(out, ppropertyDescription, elementClassType, pelementType, constraint, constraintDescriptorVar);
                } else {
                    boolean hasField = TypeUtils.hasField(typeMirror, ppropertyDescription.getPropertyName());
                    if (!hasField || !this.hasMatchingAnnotation(ppropertyDescription, typeMirror, true, constraint)) {
                        this.writeValidateConstraint(out, ppropertyDescription, elementClassType, pelementType, constraint, constraintDescriptorVar);
                    }
                }
                includedAnnotations.add(annotation);
            }
            ++count;
        }
        out.println("    }");
        out.println("  }");
    }

    private void writeValidateIterable(PrintWriter out, TypeElementPropertyDescriptor ppropertyDescription, TypeMirror elementClassType) {
        String typeParameter;
        Optional optionalTypeParameter = ((DeclaredType)elementClassType).getTypeArguments().stream().findFirst();
        if (optionalTypeParameter.isPresent()) {
            typeParameter = TypeUtils.getClassName((TypeMirror)optionalTypeParameter.get());
            this.additionalInterfacesToCreate.add((TypeMirror)optionalTypeParameter.get());
        } else {
            typeParameter = "Object";
        }
        out.println("          int i = 0;");
        out.println("          for(final " + typeParameter + " instance : value) {");
        out.println("            if (instance != null  && !context.alreadyValidated(instance)) {");
        if (optionalTypeParameter.isPresent()) {
            out.println("              violations.addAll(");
            out.print("                  ");
            out.print(TypeUtils.getValidationInstanceForType((TypeMirror)optionalTypeParameter.get(), this.processingEnv.getTypeUtils(), this.processingEnv.getElementUtils()));
            out.println(".validate(");
            if (elementClassType.getKind() == TypeKind.ARRAY || this.isList(elementClassType)) {
                out.print("                      ");
                out.print("context.appendIndex(\"");
                out.print(ppropertyDescription.getPropertyName());
                out.println("\",i),");
            } else {
                out.print("                      ");
                out.print("context.appendIterable(\"");
                out.print(ppropertyDescription.getPropertyName());
                out.println("\"),");
            }
            out.print("                      ");
            out.println(" (" + typeParameter + ") instance, groups));");
            out.print("            ");
            out.println("}");
        }
        out.print("            ");
        out.println("i++;");
        out.print("          ");
        out.println("}");
    }

    private void writeValidateMap(PrintWriter out, TypeElementPropertyDescriptor ppropertyDescription, TypeMirror typeMirror) {
        out.print("          for(");
        out.print(Map.Entry.class.getCanonicalName());
        out.println("<?, ?> entry : value.entrySet()) {");
        out.print("            ");
        out.println("if (entry.getValue() != null && !context.alreadyValidated(entry.getValue())) {");
        out.println("              violations.addAll(");
        out.print("              ");
        out.print(TypeUtils.getValidationInstanceForType(typeMirror, this.processingEnv.getTypeUtils(), this.processingEnv.getElementUtils()));
        out.println(".validate(");
        out.print("              ");
        out.print("context.appendKey(\"");
        out.print(ppropertyDescription.getPropertyName());
        out.println("\",entry.getKey()),");
        out.print("                  ");
        out.print("(");
        out.print(TypeUtils.getClassNameWithProperties(typeMirror));
        out.println(") entry.getValue(), groups));");
        out.println("            }");
        out.println("          }");
    }

    private void writeValidateConstraint(PrintWriter out, TypeElementPropertyDescriptor ppropertyDescription, TypeMirror elementClassType, TypeMirror elementType, TypeElementConstraintDescriptor<?> constraint, String constraintDescriptorVar) throws UnexpectedTypeException {
        this.writeValidateConstraint(out, ppropertyDescription, elementClassType, elementType, constraint, constraintDescriptorVar, DEFAULT_VIOLATION_VAR, "      ", true);
    }

    private void writeValidateConstraint(PrintWriter out, TypeElementPropertyDescriptor ppropertyDescription, TypeMirror elementClass, TypeMirror elementType, TypeElementConstraintDescriptor<?> constraint, String constraintDescriptorVar, String violationsVar, String indentPrefix, boolean indentFirst) throws UnexpectedTypeException {
        boolean isComposite = !constraint.getComposingConstraints().isEmpty();
        boolean firstReportAsSingleViolation = constraint.isReportAsSingleViolation() && violationsVar.equals(DEFAULT_VIOLATION_VAR) && isComposite;
        boolean reportAsSingleViolation = firstReportAsSingleViolation || !violationsVar.equals(DEFAULT_VIOLATION_VAR);
        boolean hasValidator = !constraint.getConstraintValidatorClasses().isEmpty();
        String compositeViolationsVar = constraintDescriptorVar + "_violations";
        String workIndentPrefix = indentPrefix;
        if (firstReportAsSingleViolation) {
            out.print(workIndentPrefix);
            out.print("// Report ");
            out.print(TypeUtils.getClassNameWithProperties(constraint.getAnnotation().getAnnotationType()));
            out.println(" as Single Violation");
            this.writeNewViolations(out, compositeViolationsVar);
        }
        if (hasValidator) {
            TypeMirror validatorClass = this.getValidatorForType(constraint, elementType);
            if (firstReportAsSingleViolation) {
                out.print(workIndentPrefix);
                out.print("if (!");
                workIndentPrefix = indentPrefix + "  ";
            }
            if (!firstReportAsSingleViolation && indentFirst) {
                out.print(workIndentPrefix);
            }
            out.print("validate(myContext, ");
            out.print(violationsVar);
            out.println(", object, value,");
            out.print(workIndentPrefix);
            out.print("    new ");
            out.print(TypeUtils.getClassNameWithProperties(validatorClass));
            out.println("(),");
            out.print(workIndentPrefix);
            out.print("    ");
            out.print(constraintDescriptorVar);
            out.print(", groups)");
            if (firstReportAsSingleViolation) {
                out.println(") {");
            } else if (reportAsSingleViolation) {
                if (isComposite) {
                    out.println(" ||");
                }
            } else {
                out.println(";");
            }
        } else if (!isComposite) {
            this.processingEnv.getMessager().printMessage(Diagnostic.Kind.WARNING, "No ConstraintValidator of " + constraint + " for " + ppropertyDescription.getPropertyName() + " of type " + elementClass);
        }
        if (firstReportAsSingleViolation) {
            out.print(workIndentPrefix);
            out.print("if (");
        }
        int count = 0;
        for (TypeElementConstraintDescriptor<?> compositeConstraint : constraint.getComposingConstraints()) {
            out.print(workIndentPrefix);
            String compositeVar = constraintDescriptorVar + "_" + count++;
            this.writeValidateConstraint(out, ppropertyDescription, elementClass, elementType, compositeConstraint, compositeVar, firstReportAsSingleViolation ? compositeViolationsVar : violationsVar, workIndentPrefix, count > 1);
            if (reportAsSingleViolation) {
                out.println(" ||");
                continue;
            }
            out.println(";");
        }
        if (isComposite && reportAsSingleViolation) {
            out.print(workIndentPrefix);
            out.print("    false");
        }
        if (firstReportAsSingleViolation) {
            out.println(") {");
            out.print(workIndentPrefix);
            out.print("  ");
            out.print("addSingleViolation(myContext, violations, object, value, ");
            out.print(constraintDescriptorVar);
            out.println(");");
            out.print(workIndentPrefix);
            out.println("}");
            if (hasValidator) {
                out.print(indentPrefix);
                out.println("}");
            }
        }
    }

    private void writeNewViolations(PrintWriter out, String violationName) {
        out.print("      Set<ConstraintViolation<T>> ");
        out.print(violationName);
        out.println(" = ");
        out.println("          new HashSet<ConstraintViolation<T>>();");
    }

    private boolean hasValid(TypeElementPropertyDescriptor ppropertyDescription, TypeMirror typeMirror, boolean useField) {
        return this.getAnnotation(ppropertyDescription, typeMirror, useField, (DeclaredType)this.processingEnv.getElementUtils().getTypeElement("javax.validation.Valid").asType()).isPresent();
    }

    private Optional<? extends AnnotationMirror> getAnnotation(TypeElementPropertyDescriptor ppropertyDescription, TypeMirror typeMirror, boolean useField, DeclaredType expectedAnnotationClass) {
        Optional<Object> annotation = Optional.empty();
        if (useField) {
            Optional<Element> element = TypeUtils.fieldElementByName(typeMirror, ppropertyDescription.getPropertyName());
            if (element.isPresent()) {
                annotation = element.get().getAnnotationMirrors().stream().filter(anno -> TypeUtils.getClassName(anno.getAnnotationType()).equals(TypeUtils.getClassName(expectedAnnotationClass))).findFirst();
            }
        } else {
            Optional<ExecutableElement> element = TypeUtils.getGetter(typeMirror, ppropertyDescription.getPropertyName());
            if (element.isPresent()) {
                annotation = element.get().getAnnotationMirrors().stream().filter(anno -> TypeUtils.getClassName(anno.getAnnotationType()).equals(TypeUtils.getClassName(expectedAnnotationClass))).findFirst();
            }
        }
        return annotation;
    }

    private List<? extends AnnotationMirror> getAnnotations(TypeElementPropertyDescriptor ppropertyDescription, TypeMirror typeMirror, boolean useField) {
        if (useField) {
            Optional<Element> optionalField = TypeUtils.fieldElementByName(typeMirror, ppropertyDescription.getPropertyName());
            if (optionalField.isPresent()) {
                return optionalField.get().getAnnotationMirrors();
            }
        } else {
            Optional<ExecutableElement> optionalMethod = TypeUtils.getGetter(typeMirror, ppropertyDescription.getPropertyName());
            if (optionalMethod.isPresent()) {
                return optionalMethod.get().getAnnotationMirrors();
            }
        }
        return Collections.emptyList();
    }

    private boolean isPropertyConstrained(TypeElementPropertyDescriptor ppropertyDescription, TypeMirror typeMirror, boolean useField) {
        if (this.hasValid(ppropertyDescription, typeMirror, useField)) {
            return true;
        }
        for (TypeElementConstraintDescriptor<?> constraint : ppropertyDescription.getConstraintDescriptors()) {
            if (constraint.getConstraintLocationKind().getElementType() != (useField ? ElementType.FIELD : ElementType.METHOD)) continue;
            return true;
        }
        return false;
    }

    private void writeDefaultNameNotFound(PrintWriter out, TypeMirror typeMirror) {
        out.println("      default:");
        out.println("        if (!ALL_PROPERTY_NAMES.contains(propertyName)) {");
        out.print("          throw new IllegalArgumentException");
        out.println("(propertyName + \" is not a valid property of \"");
        out.print("              + \"");
        out.print(TypeUtils.getClassNameWithProperties(typeMirror));
        out.println("\");");
        out.println("        }");
        out.println("        break;");
    }

    private void writeValidatePropertyCall(PrintWriter out, TypeMirror typeMirror, TypeElementPropertyDescriptor property, boolean useValue, boolean honorValid, String indentPrefix) {
        if (TypeUtils.hasGetter(typeMirror, property.getPropertyName()) && this.isPropertyConstrained(property, typeMirror, false)) {
            if (useValue) {
                out.print(indentPrefix);
                out.print("if (value == null || value instanceof ");
                out.print(this.getQualifiedSourceNonPrimitiveType(TypeUtils.getterReturnType(typeMirror, property.getPropertyName())));
                out.println(") {");
                this.writeValidateGetterCall(out, typeMirror, property, useValue, honorValid, "  " + indentPrefix);
                out.print(indentPrefix);
                out.print("}");
            } else {
                this.writeValidateGetterCall(out, typeMirror, property, useValue, honorValid, indentPrefix);
            }
        }
        if (TypeUtils.hasField(typeMirror, property.getPropertyName()) && this.isPropertyConstrained(property, typeMirror, true)) {
            if (useValue) {
                out.print(indentPrefix);
                out.print("if (value == null || value instanceof ");
                out.print(this.getQualifiedSourceNonPrimitiveType(TypeUtils.fieldType(typeMirror, property.getPropertyName())));
                out.println(") {");
                this.writeValidateFieldCall(out, typeMirror, property, useValue, honorValid, "  " + indentPrefix);
                out.print(indentPrefix);
                out.print("}");
            } else {
                this.writeValidateFieldCall(out, typeMirror, property, useValue, honorValid, indentPrefix);
            }
        }
        if (useValue) {
            if (TypeUtils.hasGetter(typeMirror, property.getPropertyName()) || TypeUtils.hasField(typeMirror, property.getPropertyName())) {
                out.println(" else {");
                out.print(indentPrefix);
                out.print("  throw new ValidationException");
                out.println("(value.getClass() + \" is not a valid type for \" + propertyName);");
                out.print(indentPrefix);
                out.println("}");
            } else {
                out.println();
            }
        }
    }

    private void writeValidateFieldCall(PrintWriter out, TypeMirror typeMirror, TypeElementPropertyDescriptor ppropertyDescription, boolean useValue, boolean honorValid, String indentPrefix) {
        if (!this.isPropertyConstrained(ppropertyDescription, typeMirror, true)) {
            return;
        }
        String propertyName = ppropertyDescription.getPropertyName();
        out.print(indentPrefix);
        out.print(this.validateMethodFieldName(ppropertyDescription));
        out.print("(context, ");
        out.print("violations, ");
        if (useValue) {
            out.println("null,");
            out.print(indentPrefix);
            out.print("    ");
            out.print("(");
            out.print(this.getQualifiedSourceNonPrimitiveType(TypeUtils.fieldType(typeMirror, propertyName)));
            out.print(") value");
        } else {
            out.println("object,");
            out.print(indentPrefix);
            out.print("    ");
            Optional<Element> field = TypeUtils.fieldElementByName(typeMirror, propertyName);
            if (!field.isPresent()) {
                out.print("null");
            } else if (field.get().getModifiers().contains((Object)Modifier.PUBLIC)) {
                out.print("object.");
                out.print(propertyName);
            } else if (this.forceUsingGetter) {
                Optional<ExecutableElement> getter = TypeUtils.getGetter(typeMirror, propertyName);
                if (getter.isPresent()) {
                    out.print("object.");
                    out.print(getter.get().getSimpleName());
                    out.print("()");
                } else {
                    out.print("null");
                }
            } else {
                this.fieldsToWrap.add(field.get());
                out.print(this.toWrapperName(field.get()) + "(object)");
            }
        }
        out.print(", ");
        out.print(Boolean.toString(honorValid));
        out.println(", groups);");
    }

    private void writeValidateGetterCall(PrintWriter out, TypeMirror typeMirror, TypeElementPropertyDescriptor ppropertyDescription, boolean useValue, boolean honorValid, String indentPrefix) {
        if (!this.isPropertyConstrained(ppropertyDescription, typeMirror, false)) {
            return;
        }
        out.print(indentPrefix);
        out.print(this.validateMethodGetterName(ppropertyDescription));
        out.print("(context, ");
        out.print("violations, ");
        if (useValue) {
            out.println("null,");
            out.print(indentPrefix);
            out.print("    (");
            out.print(TypeUtils.getClassNameWithProperties(TypeUtils.getterReturnType(typeMirror, ppropertyDescription.getPropertyName()).get()));
            out.print(") value");
        } else {
            out.println("object,");
            out.print(indentPrefix);
            out.print("    ");
            Optional<ExecutableElement> method = TypeUtils.getGetter(typeMirror, ppropertyDescription.getPropertyName());
            if (!method.isPresent()) {
                out.print("null");
            } else if (method.get().getModifiers().contains((Object)Modifier.PUBLIC)) {
                out.print("object.");
                out.print(method.get().getSimpleName());
                out.print("()");
            } else if (this.forceUsingGetter) {
                out.print("null");
            } else {
                this.gettersToWrap.add(method.get());
                out.print(this.toWrapperName(method.get()) + "(object)");
            }
        }
        out.print(", ");
        out.print(Boolean.toString(honorValid));
        out.println(", groups);");
    }

    private String toWrapperName(ExecutableElement field) {
        return "_" + field.getSimpleName();
    }

    private String toWrapperName(Element method) {
        return "_" + method.getSimpleName();
    }

    private String validateMethodFieldName(TypeElementPropertyDescriptor ppropertyDescription) {
        return "validateProperty_" + ppropertyDescription.getPropertyName();
    }

    private String validateMethodGetterName(TypeElementPropertyDescriptor ppropertyDescription) {
        return "validateProperty_get" + ppropertyDescription.getPropertyName();
    }

    private String getQualifiedSourceNonPrimitiveType(Optional<TypeMirror> elementType) {
        if (elementType.isPresent()) {
            switch (elementType.get().getKind()) {
                case BOOLEAN: {
                    return "Boolean";
                }
                case BYTE: {
                    return "Byte";
                }
                case SHORT: {
                    return "Short";
                }
                case INT: {
                    return "Integer";
                }
                case LONG: {
                    return "Long";
                }
                case CHAR: {
                    return "Char";
                }
                case FLOAT: {
                    return "Float";
                }
                case DOUBLE: {
                    return "Double";
                }
            }
            return TypeUtils.getClassName(elementType.get());
        }
        return null;
    }

    private void writeExpandDefaultAndValidate(PrintWriter out, TypeMirror typeMirror, Stage stage) throws UnexpectedTypeException {
        TypeElement typeElement;
        out.println("    final ArrayList<Class<?>> justGroups = new ArrayList<>();");
        out.println("    for (Group g : groups) {");
        out.println("      if (!g.isDefaultGroup() || !getBeanMetadata().defaultGroupSequenceIsRedefined()) {");
        out.println("        justGroups.add(g.getGroup());");
        out.println("      }");
        out.println("    }");
        out.println("    final Class<?>[] justGroupsArray = justGroups.toArray(new Class<?>[justGroups.size()]);");
        switch (stage) {
            case OBJECT: {
                out.println("    validateAllNonInheritedProperties(context, object, violations, justGroupsArray);");
                this.writeClassLevelConstraintsValidation(out, typeMirror, "justGroupsArray", "    ");
                break;
            }
            case PROPERTY: {
                out.println("    validatePropertyGroups(context, object, propertyName, violations, justGroupsArray);");
                break;
            }
            case VALUE: {
                out.println("    validateValueGroups(context, beanType, propertyName, value, violations, justGroupsArray);");
                break;
            }
            default: {
                throw new IllegalStateException();
            }
        }
        out.println("    if (getBeanMetadata().defaultGroupSequenceIsRedefined()) {");
        out.println("      for (Class<?> g : beanMetadata.getDefaultGroupSequence()) {");
        out.println("        int numberOfViolations = violations.size();");
        switch (stage) {
            case OBJECT: {
                out.println("        validateAllNonInheritedProperties(context, object, violations, g);");
                this.writeClassLevelConstraintsValidation(out, typeMirror, "g", "        ");
                this.writeValidateInheritance(out, typeMirror, Stage.OBJECT, null, false, "g");
                break;
            }
            case PROPERTY: {
                out.println("        validatePropertyGroups(context, object, propertyName, violations, g);");
                break;
            }
            case VALUE: {
                out.println("        validateValueGroups(context, beanType, propertyName, value, violations, g);");
                break;
            }
            default: {
                throw new IllegalStateException();
            }
        }
        out.println("        if (violations.size() > numberOfViolations) {");
        out.println("          break;");
        out.println("        }");
        out.println("      }");
        if (stage == Stage.OBJECT && typeMirror != null && (typeElement = this.processingEnv.getElementUtils().getTypeElement(TypeUtils.getClassName(typeMirror))) != null && CollectionUtils.isNotEmpty(typeElement.getInterfaces())) {
            out.println("    } else {");
            this.writeValidateInheritance(out, typeMirror, Stage.OBJECT, null, true, "groups");
        }
        out.println("    }");
    }

    private void writeBeanMetadata(PrintWriter out, TypeMirror typeMirror) {
        out.println("  private final BeanMetadata beanMetadata =");
        out.println("      new " + BeanMetadata.class.getSimpleName() + "(");
        out.print("          ");
        out.print(TypeUtils.getClassName(typeMirror));
        out.print(".class");
        GroupSequence groupSeqAnnotation = typeMirror.getAnnotation(GroupSequence.class);
        ArrayList<String> groupSequence = new ArrayList<String>();
        if (groupSeqAnnotation == null) {
            groupSequence.add(TypeUtils.getClassName(typeMirror));
        } else {
            groupSequence.addAll(Arrays.asList(groupSeqAnnotation.value()).stream().map(group -> group.getName()).collect(Collectors.toList()));
        }
        boolean groupSequenceContainsDefault = false;
        for (String group2 : groupSequence) {
            out.println(",");
            if (group2.equals(TypeUtils.getClassName(typeMirror))) {
                out.print("          ");
                out.print(GwtSpecificValidatorClassCreator.asLiteral(Default.class));
                groupSequenceContainsDefault = true;
                continue;
            }
            if (group2.equals(Default.class.getName())) {
                this.processingEnv.getMessager().printMessage(Diagnostic.Kind.ERROR, "'Default.class' cannot appear in default group sequence list.");
                continue;
            }
            out.print("          ");
            out.print(GwtSpecificValidatorClassCreator.asLiteral(group2));
        }
        if (!groupSequenceContainsDefault) {
            this.processingEnv.getMessager().printMessage(Diagnostic.Kind.ERROR, TypeUtils.getClassNameWithProperties(typeMirror) + " must be part of the redefined default group sequence.");
        }
        out.println(");");
    }

    /*
     * WARNING - void declaration
     */
    private void writeConstraintDescriptor(PrintWriter out, TypeElementConstraintDescriptor<? extends AnnotationMirror> constraint, ElementType elementType, ConstraintOrigin origin, String constraintDescripotorVar, TypeElementPropertyDescriptor ppropertyDescription) throws UnexpectedTypeException {
        void var10_16;
        DeclaredType annotationType = constraint.getAnnotation().getAnnotationType();
        int count = 0;
        for (TypeElementConstraintDescriptor<?> typeElementConstraintDescriptor : constraint.getComposingConstraints()) {
            this.writeConstraintDescriptor(out, typeElementConstraintDescriptor, elementType, origin, constraintDescripotorVar + "_" + count++, ppropertyDescription);
        }
        out.print("  private final ConstraintDescriptorImpl<");
        out.print(TypeUtils.getClassNameWithProperties(annotationType));
        out.print("> ");
        out.println(constraintDescripotorVar + "  = ");
        out.print("      ConstraintDescriptorImpl.<");
        out.print(TypeUtils.getClassNameWithProperties(annotationType));
        out.println("> builder()");
        out.println("          .setAnnotation(");
        this.writeNewAnnotation(out, constraint);
        out.println("              )");
        out.println("          .setAttributes(attributeBuilder()");
        for (Map.Entry entry : constraint.getAttributes().entrySet()) {
            out.print("            .put(");
            String key = (String)entry.getKey();
            out.print(GwtSpecificValidatorClassCreator.asLiteral(key));
            out.print(", ");
            Class[] value = ((AnnotationValue)((Map.Entry)entry.getValue()).getValue()).getValue();
            if ("groups".equals(key) && value instanceof List && ((List)value).isEmpty()) {
                value = new Class[]{Default.class};
            }
            out.print(GwtSpecificValidatorClassCreator.asLiteral(value, ((ExecutableElement)((Map.Entry)entry.getValue()).getKey()).getReturnType()));
            out.println(")");
            if (!StringUtils.startsWith((CharSequence)key, (CharSequence)"message")) continue;
            out.print("            .put(\"");
            out.print(key);
            out.print("Localized");
            out.println("\",");
            out.println("                Stream.of(new String[][] {");
            Map<String, String> messages = ValidationMessagesMap.getMessages(StringUtils.removeEnd((String)StringUtils.removeStart((String)GwtSpecificValidatorClassCreator.asLiteral(value, ((ExecutableElement)((Map.Entry)entry.getValue()).getKey()).getReturnType()), (String)"\"{"), (String)"}\""));
            if (messages != null) {
                messages.entrySet().forEach(messageEntry -> {
                    out.print("                  {\"");
                    out.print(StringEscapeUtils.escapeJava((String)((String)messageEntry.getKey())));
                    out.print("\", \"");
                    out.print(StringEscapeUtils.escapeJava((String)((String)messageEntry.getValue())));
                    out.println("\"},");
                });
            }
            out.println("                }).collect(Collectors.toMap(data -> data[0], data -> data[1]))");
            out.println("            )");
        }
        out.println("            .build())");
        out.print("          .setConstraintValidatorClasses(");
        try {
            out.print(GwtSpecificValidatorClassCreator.asLiteral(Arrays.asList(this.getValidatorForType(constraint, ppropertyDescription.getElementType()))));
        }
        catch (UnexpectedTypeException e) {
            out.print(GwtSpecificValidatorClassCreator.asLiteral(constraint.getConstraintValidatorClasses()));
        }
        out.println(")");
        int ccCount = constraint.getComposingConstraints().size();
        boolean bl = false;
        while (var10_16 < ccCount) {
            out.print("          .addComposingConstraint(");
            out.print(constraintDescripotorVar + "_" + (int)var10_16);
            out.println(")");
            ++var10_16;
        }
        out.print("          .setGroups(");
        Set<TypeMirror> set = constraint.getGroups();
        out.print(GwtSpecificValidatorClassCreator.asLiteral(set));
        out.println(")");
        out.print("          .setPayload(");
        Set<TypeElement> payload = constraint.getPayload();
        out.print(GwtSpecificValidatorClassCreator.asLiteral(payload));
        out.println(")");
        out.print("          .setReportAsSingleViolation(");
        out.print(Boolean.toString(constraint.isReportAsSingleViolation()));
        out.println(")");
        out.print("          .setElementType(");
        out.print(GwtSpecificValidatorClassCreator.asLiteral((Object)elementType));
        out.println(")");
        out.print("          .setDefinedOn(");
        out.print(GwtSpecificValidatorClassCreator.asLiteral(origin));
        out.println(")");
        out.println("          .build();");
        out.println();
    }

    private void writeNewAnnotation(PrintWriter out, TypeElementConstraintDescriptor<? extends AnnotationMirror> constraint) throws UnexpectedTypeException {
        AnnotationMirror annotation = constraint.getAnnotation();
        DeclaredType annotationType = annotation.getAnnotationType();
        out.print("              new ");
        out.print(TypeUtils.getClassNameWithProperties(annotationType));
        out.println("() {");
        out.println("                  public Class<? extends Annotation> annotationType() {");
        out.print("                    return ");
        out.print(TypeUtils.getClassName(annotationType));
        out.println(".class;");
        out.println("                  }");
        for (Map.Entry<ExecutableElement, AnnotationValue> element : constraint.getAttributes().values()) {
            ExecutableElement method = element.getKey();
            if (!method.getModifiers().contains((Object)Modifier.ABSTRACT)) continue;
            out.print("                  public ");
            out.print(TypeUtils.getClassNameWithProperties(method.getReturnType()));
            out.print(" ");
            out.print(method.getSimpleName().toString());
            out.println("() {");
            out.print("                    return ");
            try {
                Set value = "groups".equals(method.getSimpleName().toString()) ? constraint.getGroups().stream().filter(group -> !"javax.validation.groups.Default".equals(TypeUtils.getClassName(group))).collect(Collectors.toSet()) : element.getValue().getValue();
                out.print(GwtSpecificValidatorClassCreator.asLiteral(value, method.asType()));
            }
            catch (IllegalArgumentException e) {
                this.processingEnv.getMessager().printMessage(Diagnostic.Kind.ERROR, e.getMessage());
            }
            out.println(";");
            out.println("                  }");
        }
        out.println("              }");
    }

    private void writePropertyDescriptor(PrintWriter out, TypeElementPropertyDescriptor ppropertyDescription) {
        out.print("  private final PropertyDescriptorImpl ");
        out.print(ppropertyDescription.getPropertyName());
        out.println("_pd =");
        out.println("      new PropertyDescriptorImpl(");
        out.println("          \"" + ppropertyDescription.getPropertyName() + "\",");
        out.print("          ");
        out.println(TypeUtils.getClassName(ppropertyDescription.getElementType()) + ".class,");
        out.print("          ");
        out.print(Boolean.toString(ppropertyDescription.isCascaded()) + ",");
        out.print("beanMetadata");
        int count = 0;
        for (TypeElementConstraintDescriptor<?> constraint : ppropertyDescription.getConstraintDescriptors()) {
            if (!this.areConstraintDescriptorGroupsValid(constraint)) continue;
            out.println(",");
            out.print("          ");
            out.print(this.constraintDescriptorVar(ppropertyDescription.getPropertyName(), count));
            ++count;
        }
        out.println(");");
    }

    private void writeBeanDescriptor(PrintWriter out, TypeMirror typeMirror) {
        out.print("  private final GwtBeanDescriptor<" + TypeUtils.getClassNameWithProperties(typeMirror) + ">");
        out.println(" beanDescriptor = ");
        out.print("      GwtBeanDescriptorImpl.builder(");
        out.print(TypeUtils.getClassName(typeMirror));
        out.println(".class)");
        out.println("          .setConstrained(" + TypeUtils.isBeanConstrained(typeMirror, this.processingEnv.getTypeUtils(), this.processingEnv.getElementUtils()) + ")");
        int count = 0;
        for (TypeElementConstraintDescriptor<?> constraint : TypeUtils.getTypeElementConstraintDescriptors(typeMirror, this.processingEnv.getElementUtils(), this.processingEnv.getTypeUtils())) {
            if (!this.areConstraintDescriptorGroupsValid(constraint)) continue;
            out.println("          .add(" + this.constraintDescriptorVar("this", count) + ")");
            ++count;
        }
        for (TypeElementPropertyDescriptor p : TypeUtils.getTypeElementProperties(typeMirror, this.processingEnv.getElementUtils())) {
            out.print("          .put(\"");
            out.print(p.getPropertyName());
            out.print("\", ");
            out.print(p.getPropertyName());
            out.println("_pd)");
        }
        out.println("          .setBeanMetadata(beanMetadata)");
        out.println("          .build();");
    }

    private void writeValidateClassGroups(PrintWriter out, TypeMirror typeMirror) throws UnexpectedTypeException {
        out.println("  public <T> void validateClassGroups(");
        out.println("      final GwtValidationContext<T> context,");
        out.print("      final ");
        out.println(TypeUtils.getClassNameWithProperties(typeMirror) + " object,");
        out.println("      final Set<ConstraintViolation<T>> violations,");
        out.println("      final Class<?>... groups) {");
        out.println("    validateAllNonInheritedProperties(context, object, violations, groups);");
        this.writeValidateInheritance(out, typeMirror, Stage.OBJECT, null, false, "groups");
        this.writeClassLevelConstraintsValidation(out, typeMirror, "groups", "    ");
        out.println("  }");
    }

    private void writeValidateInheritance(PrintWriter out, TypeMirror typeMirror, Stage stage, TypeElementPropertyDescriptor property) throws UnexpectedTypeException {
        this.writeValidateInheritance(out, typeMirror, stage, property, false, "groups");
    }

    private void writeValidateInheritance(PrintWriter out, TypeMirror typeMirror, Stage stage, TypeElementPropertyDescriptor property, boolean expandDefaultGroupSequence, String groupsVarName) throws UnexpectedTypeException {
        this.writeValidateInterfaces(out, typeMirror, stage, property, expandDefaultGroupSequence, groupsVarName);
    }

    private void writeValidateInterfaces(PrintWriter out, TypeMirror typeMirror, Stage stage, TypeElementPropertyDescriptor ppropertyDescription, boolean expandDefaultGroupSequence, String groupsVarName) throws UnexpectedTypeException {
        TypeElement typeElement;
        if (typeMirror != null && (typeElement = this.processingEnv.getElementUtils().getTypeElement(TypeUtils.getClassName(typeMirror))) != null) {
            for (TypeMirror typeMirror2 : typeElement.getInterfaces()) {
                this.writeValidateInterfaces(out, typeMirror2, stage, ppropertyDescription, expandDefaultGroupSequence, groupsVarName);
            }
        }
    }

    private void writeClassLevelConstraintsValidation(PrintWriter out, TypeMirror typeMirror, String groupsVarName, String offset) throws UnexpectedTypeException {
        int count = 0;
        for (TypeElementConstraintDescriptor<?> constraint : TypeUtils.getTypeElementConstraintDescriptors(typeMirror, this.processingEnv.getElementUtils(), this.processingEnv.getTypeUtils())) {
            if (!this.areConstraintDescriptorGroupsValid(constraint)) continue;
            if (this.hasMatchingAnnotation(typeMirror, constraint)) {
                if (!constraint.getConstraintValidatorClasses().isEmpty()) {
                    TypeMirror validatorClass = this.getValidatorForType(constraint, typeMirror);
                    out.print(offset);
                    out.println("validate(context, violations, null, object, ");
                    out.print(offset);
                    out.print("    new ");
                    out.print(TypeUtils.getClassNameWithProperties(validatorClass));
                    out.print("(), ");
                    out.print(this.constraintDescriptorVar("this", count));
                    out.print(", ");
                    out.print(groupsVarName);
                    out.println(");");
                } else if (constraint.getComposingConstraints().isEmpty()) {
                    this.processingEnv.getMessager().printMessage(Diagnostic.Kind.WARNING, "No ConstraintValidator of " + constraint + " for type " + TypeUtils.getClassNameWithProperties(typeMirror));
                }
            }
            ++count;
        }
    }

    private Optional<TypeMirror> typeOfValdator(TypeMirror ptype, TypeMirror validationClass, List<TypeMirror> constraintValidatorClasses) {
        TypeMirror superClass;
        Optional<ExecutableElement> optionalIsValidMethod = TypeUtils.getMethod(validationClass, "isValid");
        if (optionalIsValidMethod.isPresent()) {
            VariableElement validationVariableType = optionalIsValidMethod.get().getParameters().get(0);
            if (this.processingEnv.getTypeUtils().isAssignable(ptype, validationVariableType.asType())) {
                return Optional.of(validationVariableType.asType());
            }
        }
        if ((superClass = ((TypeElement)((DeclaredType)validationClass).asElement()).getSuperclass()) != null && !"java.lang.Object".equals(TypeUtils.getClassName(superClass))) {
            if (CollectionUtils.isNotEmpty(((DeclaredType)superClass).getTypeArguments()) && this.processingEnv.getTypeUtils().isAssignable(ptype, ((DeclaredType)superClass).getTypeArguments().get(0))) {
                return Optional.of(((DeclaredType)superClass).getTypeArguments().get(0));
            }
            return this.typeOfValdator(ptype, superClass, constraintValidatorClasses);
        }
        return Optional.empty();
    }

    private Optional<TypeMirror> getValidatorForTypeElement(TypeMirror ptype, List<TypeMirror> constraintValidatorClasses) {
        Map<TypeMirror, TypeMirror> map = constraintValidatorClasses.stream().map(typeMirror -> Pair.of(this.typeOfValdator(ptype, (TypeMirror)typeMirror, constraintValidatorClasses), (Object)typeMirror)).filter(pair -> ((Optional)pair.getKey()).isPresent()).collect(Collectors.toMap(pair -> (TypeMirror)((Optional)pair.getKey()).get(), pair -> (TypeMirror)pair.getValue()));
        Optional<TypeMirror> bestMatchingKey = this.findBestMatches(ptype, map.keySet());
        if (bestMatchingKey.isPresent()) {
            return Optional.ofNullable(map.get(bestMatchingKey.get()));
        }
        return Optional.empty();
    }

    private Optional<TypeMirror> findBestMatches(TypeMirror ptype, Set<TypeMirror> keySet) {
        if (CollectionUtils.isEmpty(keySet)) {
            return Optional.empty();
        }
        if (keySet.size() == 1) {
            return keySet.stream().findFirst();
        }
        Optional<TypeMirror> sameTypeValidator = keySet.stream().filter(type -> this.processingEnv.getTypeUtils().isSameType((TypeMirror)type, ptype)).findAny();
        if (sameTypeValidator.isPresent()) {
            return sameTypeValidator;
        }
        return keySet.stream().findFirst();
    }

    protected TypeMirror getValidatorForType(TypeElementConstraintDescriptor<?> constraint, TypeMirror targetType) throws UnexpectedTypeException {
        List<TypeMirror> constraintValidatorClasses = constraint.getConstraintValidatorClasses();
        if (constraintValidatorClasses.isEmpty()) {
            throw new UnexpectedTypeException("No ConstraintValidator found for  " + constraint.getAnnotation());
        }
        Optional<TypeMirror> best = this.getValidatorForTypeElement(targetType, constraintValidatorClasses);
        if (!best.isPresent()) {
            throw new UnexpectedTypeException("No " + constraint.getAnnotation() + " ConstraintValidator for type " + targetType);
        }
        return best.get();
    }

    private boolean hasMatchingAnnotation(AnnotationMirror expectedAnnotation, List<? extends AnnotationMirror> annotations) throws UnexpectedTypeException {
        for (AnnotationMirror annotationMirror : annotations) {
            if (annotationMirror.getAnnotationType().getAnnotation(Constraint.class) != null) continue;
            try {
                TypeMirror valueType;
                Optional<ExecutableElement> valueMethod = this.processingEnv.getTypeUtils().asElement(annotationMirror.getAnnotationType()).getEnclosedElements().stream().filter(entry -> entry.getKind() == ElementKind.METHOD && "value".equals(entry.getSimpleName().toString())).map(ExecutableElement.class::cast).findFirst();
                if (!valueMethod.isPresent() || (valueType = valueMethod.get().getReturnType()).getKind() != TypeKind.ARRAY || !this.processingEnv.getTypeUtils().isAssignable(expectedAnnotation.getAnnotationType(), valueType)) continue;
                List<? extends AnnotationMirror> valueAnnotions = valueMethod.get().getAnnotationMirrors();
                for (AnnotationMirror annotationMirror2 : valueAnnotions) {
                    if (!expectedAnnotation.equals(annotationMirror2)) continue;
                    return true;
                }
            }
            catch (Exception e) {
                this.processingEnv.getMessager().printMessage(Diagnostic.Kind.ERROR, e.getMessage());
            }
        }
        return false;
    }

    private boolean hasMatchingAnnotation(TypeMirror typeMirror, TypeElementConstraintDescriptor<?> constraint) throws UnexpectedTypeException {
        Object expectedAnnotation = constraint.getAnnotation();
        List<AnnotationMirror> annotations = TypeUtils.getAnnotationsForType(typeMirror, this.processingEnv.getTypeUtils(), this.processingEnv.getElementUtils());
        if (annotations.contains(expectedAnnotation)) {
            return true;
        }
        return this.hasMatchingAnnotation((AnnotationMirror)expectedAnnotation, (List<? extends AnnotationMirror>)annotations);
    }

    private boolean hasMatchingAnnotation(TypeElementPropertyDescriptor ppropertyDescription, TypeMirror typeMirror, boolean useField, TypeElementConstraintDescriptor<?> constraint) throws UnexpectedTypeException {
        Object expectedAnnotation = constraint.getAnnotation();
        DeclaredType expectedAnnotationClass = expectedAnnotation.getAnnotationType();
        if (this.getAnnotation(ppropertyDescription, typeMirror, useField, expectedAnnotationClass).isPresent()) {
            return true;
        }
        return this.hasMatchingAnnotation((AnnotationMirror)expectedAnnotation, this.getAnnotations(ppropertyDescription, typeMirror, useField));
    }

    private boolean areConstraintDescriptorGroupsValid(TypeElementConstraintDescriptor<?> constraintDescriptor) {
        if (this.validTypeElementConstraintsMap.containsKey(constraintDescriptor)) {
            return this.validTypeElementConstraintsMap.get(constraintDescriptor);
        }
        boolean areValid = this.checkGroupsTypeMirror(constraintDescriptor.getGroups());
        this.validTypeElementConstraintsMap.put(constraintDescriptor, areValid);
        return areValid;
    }

    private boolean checkGroupsTypeMirror(Set<TypeMirror> groups) {
        return groups.stream().map(TypeMirror::toString).anyMatch(this.validGroupsTypeMirror::contains);
    }

    private List<String> detectAnnotationStringParameters(TypeMirror typeMirror) {
        List<AnnotationMirror> annotations = TypeUtils.getAnnotationsForType(typeMirror, this.processingEnv.getTypeUtils(), this.processingEnv.getElementUtils());
        return annotations.stream().flatMap(mirror -> this.streamOfAnnotationValues((AnnotationMirror)mirror)).flatMap(entry -> {
            if (entry instanceof AnnotationMirror) {
                return this.streamOfAnnotationValues((AnnotationMirror)entry);
            }
            if (entry instanceof List) {
                return ((List)entry).stream().flatMap(mirror -> {
                    if (mirror instanceof AnnotationMirror) {
                        return this.streamOfAnnotationValues((AnnotationMirror)mirror);
                    }
                    return Stream.of(mirror);
                });
            }
            return Stream.of(entry);
        }).filter(entry -> entry instanceof String && !((String)entry).matches("^\\{.*\\}$")).map(String.class::cast).collect(Collectors.toList());
    }

    private Stream<Object> streamOfAnnotationValues(AnnotationMirror mirror) {
        return this.processingEnv.getElementUtils().getElementValuesWithDefaults(mirror).values().stream().map(AnnotationValue::getValue);
    }

    private String constraintDescriptorVar(String name, int count) {
        return name + "_c" + count;
    }

    private void writeWrappers(PrintWriter out, TypeMirror typeMirror) {
        out.println("  // Write the wrappers after we know which are needed");
        for (Element field : this.fieldsToWrap) {
            this.writeFieldWrapperMethod(out, field, typeMirror);
            out.println();
        }
        for (ExecutableElement method : this.gettersToWrap) {
            this.writeGetterWrapperMethod(out, method, typeMirror);
            out.println();
        }
    }

    private void writeFieldWrapperMethod(PrintWriter out, Element field, TypeMirror typeMirror) {
        this.writeUnsafeNativeLongIfNeeded(out, field.asType());
        out.print("  private native ");
        out.print(TypeUtils.getClassNameWithProperties(field.asType()));
        out.print(" ");
        out.print(this.toWrapperName(field));
        out.println("(");
        out.print("      final ");
        out.print(TypeUtils.getClassNameWithProperties(typeMirror));
        out.println(" object) /*-{");
        out.print("    return object.@");
        out.print(TypeUtils.getClassNameWithPropertiesOfElement(typeMirror, field));
        out.print("::");
        out.print(field.getSimpleName());
        out.println(";");
        out.println("  }-*/;");
    }

    private void writeGetterWrapperMethod(PrintWriter out, ExecutableElement method, TypeMirror typeMirror) {
        this.writeUnsafeNativeLongIfNeeded(out, method.getReturnType());
        out.print("  private native ");
        out.print(TypeUtils.getClassNameWithProperties(method.getReturnType()));
        out.print(" ");
        out.print(this.toWrapperName(method));
        out.println("(");
        out.print("      final ");
        out.print(TypeUtils.getClassNameWithProperties(typeMirror));
        out.println(" object) /*-{");
        out.print("    return object.");
        out.print(method.getSimpleName());
        out.println("();");
        out.println("  }-*/;");
    }

    protected void writeUnsafeNativeLongIfNeeded(PrintWriter out, TypeMirror typeMirror) {
        if (typeMirror.getKind() == TypeKind.LONG) {
            out.println("  @com.google.gwt.core.client.UnsafeNativeLong");
        }
    }

    private void writeReflectionGetterReplacement(PrintWriter out, TypeMirror typeMirror, List<String> parameters) throws UnexpectedTypeException {
        out.println("  private java.util.Map<String, Object> generateReflectionGetterReplacementMap(");
        out.print("      ");
        out.println(TypeUtils.getClassNameWithProperties(typeMirror) + " object) {");
        out.println("    final java.util.Map<String, Object> reflectionMap = new java.util.HashMap<>();");
        this.writeRecursiveGetterReplacmentEntries(out, "    ", typeMirror, "object", Optional.empty(), true, 0, parameters);
        out.println("    return reflectionMap;");
        out.println("  }");
    }

    private void writeRecursiveGetterReplacmentEntries(PrintWriter out, String offset, TypeMirror typeMirror, String objectName, Optional<String> prefix, boolean hasValue, int count, List<String> parameters) {
        if (count >= 2) {
            return;
        }
        TypeUtils.getGetter(typeMirror).forEach(getter -> {
            String pureGetterName = TypeUtils.getterNameFromElement(getter);
            String pureField = TypeUtils.valueFromGetter(pureGetterName);
            if (!"class".equals(pureField)) {
                String field = (prefix.isPresent() ? (String)prefix.get() + "." : "") + pureField;
                String getterName = objectName + "." + pureGetterName + "()";
                if (parameters.contains(field)) {
                    out.print(offset);
                    out.print("reflectionMap.put(\"");
                    out.print(field);
                    out.print("\", ");
                    if (hasValue) {
                        out.print(objectName);
                        out.print(" == null ? null : ");
                        out.print(getterName);
                    } else {
                        out.print("null");
                    }
                    out.println(");");
                }
                if (getter.getReturnType().getKind() == TypeKind.DECLARED && this.processingEnv.getTypeUtils().asElement(getter.getReturnType()).getKind() != ElementKind.ENUM && !StringUtils.startsWith((CharSequence)TypeUtils.getClassName(getter.getReturnType()), (CharSequence)"java") && parameters.stream().anyMatch(entry -> StringUtils.startsWith((CharSequence)entry, (CharSequence)field))) {
                    if (hasValue) {
                        out.print(offset);
                        out.print("if (");
                        out.print(objectName);
                        out.print(" == null || ");
                        out.print(getterName);
                        out.println(" == null) {");
                        this.writeRecursiveGetterReplacmentEntries(out, offset + "  ", getter.getReturnType(), getterName, Optional.of(field), false, count + 1, parameters);
                        out.print(offset);
                        out.println("} else {");
                        this.writeRecursiveGetterReplacmentEntries(out, offset + "  ", getter.getReturnType(), getterName, Optional.of(field), hasValue, count + 1, parameters);
                        out.print(offset);
                        out.println("}");
                    } else {
                        this.writeRecursiveGetterReplacmentEntries(out, offset, getter.getReturnType(), getterName, Optional.of(field), false, count + 1, parameters);
                    }
                }
            }
        });
    }

    private static enum Stage {
        OBJECT,
        PROPERTY,
        VALUE;

    }
}

