/*
 * Decompiled with CFR 0.152.
 */
package de.knightsoftnet.validators.annotation.processor;

import java.util.HashMap;
import java.util.Locale;
import java.util.Map;

public class ValidationMessagesMap {
    private static final String DEFAULT_LANG = "en";
    private static final Map<String, Map<String, String>> MESSAGES_MAP = new HashMap<String, Map<String, String>>();

    public static void addMessages(String code, Map<String, String> localizedMap) {
        MESSAGES_MAP.put(ValidationMessagesMap.clearCode(code), localizedMap);
    }

    public static void addMessage(String code, Locale locale, String localizedMessage) {
        ValidationMessagesMap.addMessage(code, locale.toString(), localizedMessage);
    }

    public static void addMessage(String code, String lang, String localizedMessage) {
        Map<String, String> localizedMap = ValidationMessagesMap.getMessages(code);
        if (localizedMap == null) {
            localizedMap = new HashMap<String, String>();
            MESSAGES_MAP.put(ValidationMessagesMap.clearCode(code), localizedMap);
        }
        localizedMap.put(lang == null ? "" : lang, localizedMessage);
    }

    public static Map<String, String> getMessages(String code) {
        return MESSAGES_MAP.get(ValidationMessagesMap.clearCode(code));
    }

    public static String getMessage(String code, Locale locale) {
        return ValidationMessagesMap.getMessage(code, locale.toString());
    }

    public static String getMessage(String code, String lang) {
        String reducedLang;
        Map<String, String> localizedMap = ValidationMessagesMap.getMessages(code);
        if (localizedMap == null || localizedMap.isEmpty()) {
            return null;
        }
        if (localizedMap.containsKey(lang)) {
            return localizedMap.get(lang);
        }
        String string = reducedLang = lang == null ? DEFAULT_LANG : lang;
        while (reducedLang.contains("_")) {
            if (!localizedMap.containsKey(reducedLang = reducedLang.substring(0, reducedLang.length() - 3))) continue;
            return localizedMap.get(reducedLang);
        }
        return localizedMap.get(DEFAULT_LANG);
    }

    private static String clearCode(String code) {
        int length = code.length();
        if (length < 2) {
            return code;
        }
        return code.substring(code.charAt(0) == '{' ? 1 : 0, code.charAt(length - 1) == '}' ? length - 1 : length);
    }

    public static boolean isEmpty() {
        return MESSAGES_MAP.isEmpty();
    }
}

