/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.javacpp;

import com.googlecode.javacpp.Generator;
import com.googlecode.javacpp.Loader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.net.MalformedURLException;
import java.net.URISyntaxException;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.Arrays;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.Map;
import java.util.Properties;
import java.util.jar.JarInputStream;
import java.util.jar.JarOutputStream;
import java.util.zip.ZipEntry;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Builder {
    UserClassLoader classLoader = null;
    File outputDirectory = null;
    String outputName = null;
    String jarPrefix = null;
    boolean compile = true;
    boolean header = false;
    Properties properties = null;
    LinkedList<Class> classes = null;
    ClassScanner classScanner = null;
    Map<String, String> environmentVariables = null;
    LinkedList<String> compilerOptions = null;

    public static void includeJavaPaths(Properties properties) {
        String macpath;
        String platformName = Loader.getPlatformName();
        String pathSeparator = properties.getProperty("path.separator");
        final String jvmlink = properties.getProperty("compiler.link.prefix", "") + "jvm" + properties.getProperty("compiler.link.suffix", "");
        final String jvmlib = properties.getProperty("library.prefix", "") + "jvm" + properties.getProperty("library.suffix", "");
        final String[] jnipath = new String[2];
        final String[] jvmpath = new String[2];
        FilenameFilter filter = new FilenameFilter(){

            public boolean accept(File dir, String name) {
                if (new File(dir, "jni.h").exists()) {
                    jnipath[0] = dir.getAbsolutePath();
                }
                if (new File(dir, "jni_md.h").exists()) {
                    jnipath[1] = dir.getAbsolutePath();
                }
                if (new File(dir, jvmlink).exists()) {
                    jvmpath[0] = dir.getAbsolutePath();
                }
                if (new File(dir, jvmlib).exists()) {
                    jvmpath[1] = dir.getAbsolutePath();
                }
                return new File(dir, name).isDirectory();
            }
        };
        File javaHome = new File(System.getProperty("java.home")).getParentFile();
        try {
            javaHome = javaHome.getCanonicalFile();
        }
        catch (IOException e) {
            // empty catch block
        }
        LinkedList<File> dirs = new LinkedList<File>(Arrays.asList(javaHome.listFiles(filter)));
        while (!dirs.isEmpty()) {
            File d = dirs.pop();
            String dpath = d.getPath();
            for (File f : d.listFiles(filter)) {
                try {
                    f = f.getCanonicalFile();
                }
                catch (IOException e) {
                    // empty catch block
                }
                if (dpath.startsWith(f.getPath())) continue;
                dirs.add(f);
            }
        }
        if (jnipath[0] != null && jnipath[0].equals(jnipath[1])) {
            jnipath[1] = null;
        } else if (jnipath[0] == null && new File(macpath = "/System/Library/Frameworks/JavaVM.framework/Headers/").isDirectory()) {
            jnipath[0] = macpath;
        }
        if (jvmpath[0] != null && jvmpath[0].equals(jvmpath[1])) {
            jvmpath[1] = null;
        }
        Loader.appendProperty(properties, "compiler.includepath", pathSeparator, jnipath);
        if (platformName.equals(properties.getProperty("platform.name", platformName))) {
            Loader.appendProperty(properties, "compiler.link", pathSeparator, "jvm");
            Loader.appendProperty(properties, "compiler.linkpath", pathSeparator, jvmpath);
            if (platformName.startsWith("macosx")) {
                Loader.appendProperty(properties, "compiler.framework", pathSeparator, "JavaVM");
            }
        }
    }

    public int compile(String sourceFilename, String outputFilename, Properties properties) throws IOException, InterruptedException {
        String framework;
        String link;
        String includepath;
        LinkedList<String> command = new LinkedList<String>();
        Builder.includeJavaPaths(properties);
        String platformName = Loader.getPlatformName();
        String pathSeparator = properties.getProperty("path.separator");
        String platformRoot = properties.getProperty("platform.root");
        if (platformRoot == null || platformRoot.length() == 0) {
            platformRoot = ".";
        }
        if (!platformRoot.endsWith(File.separator)) {
            platformRoot = platformRoot + File.separator;
        }
        String compilerPath = properties.getProperty("compiler.path");
        if (platformRoot != null && !new File(compilerPath).isAbsolute() && new File(platformRoot + compilerPath).exists()) {
            compilerPath = platformRoot + compilerPath;
        }
        command.add(compilerPath);
        String sysroot = properties.getProperty("compiler.sysroot");
        if (sysroot != null && sysroot.length() > 0) {
            String p = properties.getProperty("compiler.sysroot.prefix", "");
            for (String s : sysroot.split(pathSeparator)) {
                if (platformRoot != null && !new File(s).isAbsolute()) {
                    s = platformRoot + s;
                }
                if (!new File(s).isDirectory()) continue;
                if (p.endsWith(" ")) {
                    command.add(p.trim());
                    command.add(s);
                    continue;
                }
                command.add(p + s);
            }
        }
        if ((includepath = properties.getProperty("compiler.includepath")) != null && includepath.length() > 0) {
            String p = properties.getProperty("compiler.includepath.prefix", "");
            for (String s : includepath.split(pathSeparator)) {
                if (platformRoot != null && !new File(s).isAbsolute()) {
                    s = platformRoot + s;
                }
                if (!new File(s).isDirectory()) continue;
                if (p.endsWith(" ")) {
                    command.add(p.trim());
                    command.add(s);
                    continue;
                }
                command.add(p + s);
            }
        }
        command.add(sourceFilename);
        String options = properties.getProperty("compiler.options");
        if (options != null && options.length() > 0) {
            command.addAll(Arrays.asList(options.split(" ")));
        }
        command.addAll(this.compilerOptions);
        String outputPrefix = properties.getProperty("compiler.output.prefix");
        if (outputPrefix != null && outputPrefix.length() > 0) {
            command.addAll(Arrays.asList(outputPrefix.split(" ")));
        }
        if (outputPrefix == null || outputPrefix.length() == 0 || outputPrefix.endsWith(" ")) {
            command.add(outputFilename);
        } else {
            command.add((String)command.removeLast() + outputFilename);
        }
        String linkpath = properties.getProperty("compiler.linkpath");
        if (linkpath != null && linkpath.length() > 0) {
            String p = properties.getProperty("compiler.linkpath.prefix", "");
            String p2 = properties.getProperty("compiler.linkpath.prefix2");
            for (String s : linkpath.split(pathSeparator)) {
                if (platformRoot != null && !new File(s).isAbsolute()) {
                    s = platformRoot + s;
                }
                if (!new File(s).isDirectory()) continue;
                if (p.endsWith(" ")) {
                    command.add(p.trim());
                    command.add(s);
                } else {
                    command.add(p + s);
                }
                if (p2 == null) continue;
                if (p2.endsWith(" ")) {
                    command.add(p2.trim());
                    command.add(s);
                    continue;
                }
                command.add(p2 + s);
            }
        }
        if ((link = properties.getProperty("compiler.link")) != null && link.length() > 0) {
            String p = properties.getProperty("compiler.link.prefix", "");
            String x = properties.getProperty("compiler.link.suffix", "");
            for (String s : link.split(pathSeparator)) {
                String[] libnameversion = s.split("@");
                s = libnameversion.length == 3 && libnameversion[1].length() == 0 ? libnameversion[0] + libnameversion[2] : libnameversion[0];
                if (p.endsWith(" ") && x.startsWith(" ")) {
                    command.add(p.trim());
                    command.add(s);
                    command.add(x.trim());
                    continue;
                }
                if (p.endsWith(" ")) {
                    command.add(p.trim());
                    command.add(s + x);
                    continue;
                }
                if (x.startsWith(" ")) {
                    command.add(p + s);
                    command.add(x.trim());
                    continue;
                }
                command.add(p + s + x);
            }
        }
        if ((framework = properties.getProperty("compiler.framework")) != null && framework.length() > 0) {
            String p = properties.getProperty("compiler.framework.prefix", "");
            String x = properties.getProperty("compiler.framework.suffix", "");
            for (String s : framework.split(pathSeparator)) {
                if (p.endsWith(" ") && x.startsWith(" ")) {
                    command.add(p.trim());
                    command.add(s);
                    command.add(x.trim());
                    continue;
                }
                if (p.endsWith(" ")) {
                    command.add(p.trim());
                    command.add(s + x);
                    continue;
                }
                if (x.startsWith(" ")) {
                    command.add(p + s);
                    command.add(x.trim());
                    continue;
                }
                command.add(p + s + x);
            }
        }
        boolean windows = platformName.startsWith("windows");
        for (String s : command) {
            boolean hasSpaces;
            boolean bl = hasSpaces = s.indexOf(" ") > 0;
            if (hasSpaces) {
                System.out.print(windows ? "\"" : "'");
            }
            System.out.print(s);
            if (hasSpaces) {
                System.out.print(windows ? "\"" : "'");
            }
            System.out.print(" ");
        }
        System.out.println();
        ProcessBuilder pb = new ProcessBuilder(command);
        if (this.environmentVariables != null) {
            pb.environment().putAll(this.environmentVariables);
        }
        Process p = pb.start();
        new Piper(p.getErrorStream(), System.err).start();
        new Piper(p.getInputStream(), System.out).start();
        return p.waitFor();
    }

    public File generateAndCompile(Class[] classes, String outputName) throws IOException, InterruptedException {
        String sourcePrefix;
        File outputPath;
        File outputFile = null;
        Properties p = (Properties)this.properties.clone();
        for (Class c : classes) {
            Loader.appendProperties(p, c);
        }
        String platformName = p.getProperty("platform.name");
        String sourceSuffix = p.getProperty("source.suffix", ".cpp");
        String libraryName = p.getProperty("library.prefix", "") + outputName + p.getProperty("library.suffix", "");
        if (this.outputDirectory == null) {
            try {
                URL resourceURL = classes[0].getResource('/' + classes[0].getName().replace('.', '/') + ".class");
                File packageDir = new File(resourceURL.toURI()).getParentFile();
                outputPath = new File(packageDir, platformName);
                sourcePrefix = packageDir.getPath() + File.separator + outputName;
            }
            catch (URISyntaxException e) {
                throw new RuntimeException(e);
            }
        } else {
            outputPath = this.outputDirectory;
            sourcePrefix = outputPath.getPath() + File.separator + outputName;
        }
        if (!outputPath.exists()) {
            outputPath.mkdirs();
        }
        Generator generator = new Generator(p);
        String sourceFilename = sourcePrefix + sourceSuffix;
        String headerFilename = this.header ? sourcePrefix + ".h" : null;
        String classPath = System.getProperty("java.class.path");
        for (String s : this.classLoader.getPaths()) {
            classPath = classPath + File.pathSeparator + s;
        }
        System.out.println("Generating source file: " + sourceFilename);
        if (generator.generate(sourceFilename, headerFilename, classPath, classes)) {
            generator.close();
            if (this.compile) {
                String libraryFilename = outputPath.getPath() + File.separator + libraryName;
                System.out.println("Building library file: " + libraryFilename);
                int exitValue = this.compile(sourceFilename, libraryFilename, p);
                if (exitValue == 0) {
                    new File(sourceFilename).delete();
                    outputFile = new File(libraryFilename);
                } else {
                    System.exit(exitValue);
                }
            } else {
                outputFile = new File(sourceFilename);
            }
        } else {
            System.out.println("Source file not generated: " + sourceFilename);
        }
        return outputFile;
    }

    public static void createJar(File jarFile, String[] classpath, LinkedList<File> files) throws IOException {
        System.out.println("Creating JAR file: " + jarFile);
        JarOutputStream jos = new JarOutputStream(new FileOutputStream(jarFile));
        for (File f : files) {
            int n;
            String name = f.getPath();
            if (classpath != null) {
                int i;
                String[] names = new String[classpath.length];
                for (i = 0; i < classpath.length; ++i) {
                    String path = new File(classpath[i]).getCanonicalPath();
                    if (!name.startsWith(path)) continue;
                    names[i] = name.substring(path.length() + 1);
                }
                for (i = 0; i < names.length; ++i) {
                    if (names[i] == null || names[i].length() >= name.length()) continue;
                    name = names[i];
                }
            }
            ZipEntry e = new ZipEntry(name.replace(File.separatorChar, '/'));
            e.setTime(f.lastModified());
            jos.putNextEntry(e);
            FileInputStream fis = new FileInputStream(f);
            byte[] data = new byte[fis.available()];
            while ((n = fis.read(data)) > 0) {
                jos.write(data, 0, n);
            }
            fis.close();
            jos.closeEntry();
        }
        jos.close();
    }

    public Builder() {
        Loader.loadLibraries = false;
        this.classLoader = new UserClassLoader(Thread.currentThread().getContextClassLoader());
        this.properties = Loader.getProperties();
        this.classes = new LinkedList();
        this.classScanner = new ClassScanner(this.classes, this.classLoader);
        this.compilerOptions = new LinkedList();
    }

    public Builder classPaths(String classPaths) {
        this.classPaths(classPaths == null ? null : classPaths.split(File.pathSeparator));
        return this;
    }

    public Builder classPaths(String ... classPaths) {
        this.classLoader.addPaths(classPaths);
        return this;
    }

    public Builder outputDirectory(String outputDirectory) {
        this.outputDirectory(outputDirectory == null ? null : new File(outputDirectory));
        return this;
    }

    public Builder outputDirectory(File outputDirectory) {
        this.outputDirectory = outputDirectory;
        return this;
    }

    public Builder compile(boolean compile) {
        this.compile = compile;
        return this;
    }

    public Builder header(boolean header) {
        this.header = header;
        return this;
    }

    public Builder outputName(String outputName) {
        this.outputName = outputName;
        return this;
    }

    public Builder jarPrefix(String jarPrefix) {
        this.jarPrefix = jarPrefix;
        return this;
    }

    public Builder properties(String platformName) {
        this.properties(platformName == null ? null : Loader.getProperties(platformName));
        return this;
    }

    public Builder properties(Properties properties) {
        if (properties != null) {
            this.properties.putAll((Map<?, ?>)properties);
        }
        return this;
    }

    public Builder propertyFile(String filename) throws IOException {
        this.propertyFile(filename == null ? null : new File(filename));
        return this;
    }

    public Builder propertyFile(File propertyFile) throws IOException {
        if (propertyFile == null) {
            return this;
        }
        FileInputStream fis = new FileInputStream(propertyFile);
        this.properties = new Properties(this.properties);
        try {
            this.properties.load(new InputStreamReader(fis));
        }
        catch (NoSuchMethodError e) {
            this.properties.load(fis);
        }
        fis.close();
        return this;
    }

    public Builder property(String keyValue) {
        int equalIndex = keyValue.indexOf(61);
        if (equalIndex < 0) {
            equalIndex = keyValue.indexOf(58);
        }
        this.property(keyValue.substring(2, equalIndex), keyValue.substring(equalIndex + 1));
        return this;
    }

    public Builder property(String key, String value) {
        if (key.length() > 0 && value.length() > 0) {
            this.properties.put(key, value);
        }
        return this;
    }

    public Builder classesOrPackages(String ... classesOrPackages) throws IOException {
        if (classesOrPackages == null) {
            this.classScanner.addPackage(null, true);
        } else {
            for (String s : classesOrPackages) {
                this.classScanner.addClassOrPackage(s);
            }
        }
        return this;
    }

    public Builder environmentVariables(Map<String, String> environmentVariables) {
        this.environmentVariables = environmentVariables;
        return this;
    }

    public Builder compilerOptions(String ... options) {
        if (options != null) {
            this.compilerOptions.addAll(Arrays.asList(options));
        }
        return this;
    }

    public Collection<File> build() throws IOException, InterruptedException {
        LinkedList<File> outputFiles;
        if (this.classes.isEmpty()) {
            return null;
        }
        if (this.outputName == null) {
            outputFiles = new LinkedList<File>();
            LinkedHashMap<String, LinkedList<Class>> map = new LinkedHashMap<String, LinkedList<Class>>();
            for (Class c : this.classes) {
                String libraryName;
                Properties p = (Properties)this.properties.clone();
                if (Loader.appendProperties(p, c) != c || (libraryName = p.getProperty("loader.library", "")).length() == 0) continue;
                LinkedList<Class> classList = (LinkedList<Class>)map.get(libraryName);
                if (classList == null) {
                    classList = new LinkedList<Class>();
                    map.put(libraryName, classList);
                }
                classList.add(c);
            }
            for (String libraryName : map.keySet()) {
                LinkedList classList = (LinkedList)map.get(libraryName);
                File f = this.generateAndCompile(classList.toArray(new Class[classList.size()]), libraryName);
                if (f == null) continue;
                outputFiles.add(f);
            }
        } else {
            outputFiles = new LinkedList();
            File f = this.generateAndCompile(this.classes.toArray(new Class[this.classes.size()]), this.outputName);
            if (f != null) {
                outputFiles.add(f);
            }
        }
        if (this.jarPrefix != null && !outputFiles.isEmpty()) {
            File jarFile = new File(this.jarPrefix + "-" + this.properties.get("platform.name") + ".jar");
            File d = jarFile.getParentFile();
            if (d != null && !d.exists()) {
                d.mkdir();
            }
            Builder.createJar(jarFile, this.outputDirectory == null ? this.classLoader.getPaths() : null, outputFiles);
        }
        return outputFiles;
    }

    public static void printHelp() {
        String version = Builder.class.getPackage().getImplementationVersion();
        if (version == null) {
            version = "unknown";
        }
        System.out.println("JavaCPP version " + version + "\n" + "Copyright (C) 2011-2013 Samuel Audet <samuel.audet@gmail.com>\n" + "Project site: http://code.google.com/p/javacpp/\n\n" + "Licensed under the GNU General Public License version 2 (GPLv2) with Classpath exception.\n" + "Please refer to LICENSE.txt or http://www.gnu.org/licenses/ for details.");
        System.out.println();
        System.out.println("Usage: java -jar javacpp.jar [options] [class or package (suffixed with .* or .**)]");
        System.out.println();
        System.out.println("where options include:");
        System.out.println();
        System.out.println("    -classpath <path>      Load user classes from path");
        System.out.println("    -d <directory>         Output all generated files to directory");
        System.out.println("    -o <name>              Output everything in a file named after given name");
        System.out.println("    -nocompile             Do not compile or delete the generated source files");
        System.out.println("    -header                Generate header file with declarations of callbacks functions");
        System.out.println("    -jarprefix <prefix>    Also create a JAR file named \"<prefix>-<platform.name>.jar\"");
        System.out.println("    -properties <resource> Load all properties from resource");
        System.out.println("    -propertyfile <file>   Load all properties from file");
        System.out.println("    -D<property>=<value>   Set property to value");
        System.out.println("    -Xcompiler <option>    Pass option directly to compiler");
        System.out.println();
    }

    public static void main(String[] args) throws Exception {
        boolean addedClasses = false;
        Builder builder = new Builder();
        for (int i = 0; i < args.length; ++i) {
            if ("-help".equals(args[i]) || "--help".equals(args[i])) {
                Builder.printHelp();
                System.exit(0);
                continue;
            }
            if ("-classpath".equals(args[i]) || "-cp".equals(args[i]) || "-lib".equals(args[i])) {
                builder.classPaths(args[++i]);
                continue;
            }
            if ("-d".equals(args[i])) {
                builder.outputDirectory(args[++i]);
                continue;
            }
            if ("-o".equals(args[i])) {
                builder.outputName(args[++i]);
                continue;
            }
            if ("-cpp".equals(args[i]) || "-nocompile".equals(args[i])) {
                builder.compile(false);
                continue;
            }
            if ("-header".equals(args[i])) {
                builder.header(true);
                continue;
            }
            if ("-jarprefix".equals(args[i])) {
                builder.jarPrefix(args[++i]);
                continue;
            }
            if ("-properties".equals(args[i])) {
                builder.properties(args[++i]);
                continue;
            }
            if ("-propertyfile".equals(args[i])) {
                builder.propertyFile(args[++i]);
                continue;
            }
            if (args[i].startsWith("-D")) {
                builder.property(args[i]);
                continue;
            }
            if ("-Xcompiler".equals(args[i])) {
                builder.compilerOptions(args[++i]);
                continue;
            }
            if (args[i].startsWith("-")) {
                System.err.println("Error: Invalid option \"" + args[i] + "\"");
                Builder.printHelp();
                System.exit(1);
                continue;
            }
            builder.classesOrPackages(args[i]);
            addedClasses = true;
        }
        if (!addedClasses) {
            builder.classesOrPackages(null);
        }
        builder.build();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class ClassScanner {
        private Collection<Class> classes;
        private UserClassLoader loader;

        public ClassScanner(Collection<Class> classes, UserClassLoader loader) {
            this.classes = classes;
            this.loader = loader;
        }

        public void addClass(String className) {
            if (className == null) {
                return;
            }
            if (className.endsWith(".class")) {
                className = className.substring(0, className.length() - 6);
            }
            try {
                Class<?> c = Class.forName(className, false, this.loader);
                if (!this.classes.contains(c)) {
                    this.classes.add(c);
                }
            }
            catch (ClassNotFoundException e) {
                System.err.println("Warning: Could not find class " + className + ": " + e);
            }
            catch (NoClassDefFoundError e) {
                System.err.println("Warning: Could not load class " + className + ": " + e);
            }
        }

        public void addMatchingFile(String filename, String packagePath, boolean recursive) {
            if (filename != null && filename.endsWith(".class") && (packagePath == null || recursive && filename.startsWith(packagePath) || filename.regionMatches(0, packagePath, 0, Math.max(filename.lastIndexOf(47), packagePath.lastIndexOf(47))))) {
                this.addClass(filename.replace('/', '.'));
            }
        }

        public void addMatchingDir(String parentName, File dir, String packagePath, boolean recursive) {
            Object[] files = dir.listFiles();
            Arrays.sort(files);
            for (Object f : files) {
                String pathName;
                String string = pathName = parentName == null ? ((File)f).getName() : parentName + ((File)f).getName();
                if (((File)f).isDirectory()) {
                    this.addMatchingDir(pathName + "/", (File)f, packagePath, recursive);
                    continue;
                }
                this.addMatchingFile(pathName, packagePath, recursive);
            }
        }

        public void addPackage(String packageName, boolean recursive) throws IOException {
            String[] paths = this.loader.getPaths();
            String packagePath = packageName == null ? null : packageName.replace('.', '/') + "/";
            int prevSize = this.classes.size();
            for (String p : paths) {
                File file = new File(p);
                if (file.isDirectory()) {
                    this.addMatchingDir(null, file, packagePath, recursive);
                    continue;
                }
                JarInputStream jis = new JarInputStream(new FileInputStream(file));
                ZipEntry e = jis.getNextEntry();
                while (e != null) {
                    this.addMatchingFile(e.getName(), packagePath, recursive);
                    jis.closeEntry();
                    e = jis.getNextEntry();
                }
                jis.close();
            }
            if (this.classes.size() == 0 && packageName == null) {
                System.err.println("Warning: No classes found in the unnamed package");
                Builder.printHelp();
            } else if (prevSize == this.classes.size() && packageName != null) {
                System.err.println("Warning: No classes found in package " + packageName);
            }
        }

        public void addClassOrPackage(String name) throws IOException {
            if (name == null) {
                return;
            }
            if ((name = name.replace('/', '.')).endsWith(".**")) {
                this.addPackage(name.substring(0, name.length() - 3), true);
            } else if (name.endsWith(".*")) {
                this.addPackage(name.substring(0, name.length() - 2), false);
            } else {
                this.addClass(name);
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class UserClassLoader
    extends URLClassLoader {
        private LinkedList<String> paths = new LinkedList();

        public UserClassLoader() {
            super(new URL[0]);
        }

        public UserClassLoader(ClassLoader parent) {
            super(new URL[0], parent);
        }

        public void addPaths(String ... paths) {
            if (paths == null) {
                return;
            }
            for (String path : paths) {
                this.paths.add(path);
                try {
                    this.addURL(new File(path).toURI().toURL());
                }
                catch (MalformedURLException e) {
                    throw new RuntimeException(e);
                }
            }
        }

        public String[] getPaths() {
            if (this.paths.isEmpty()) {
                this.addPaths(System.getProperty("user.dir"));
            }
            return this.paths.toArray(new String[this.paths.size()]);
        }

        @Override
        protected Class<?> findClass(String name) throws ClassNotFoundException {
            if (this.paths.isEmpty()) {
                this.addPaths(System.getProperty("user.dir"));
            }
            return super.findClass(name);
        }
    }

    public static class Piper
    extends Thread {
        InputStream is;
        OutputStream os;

        public Piper(InputStream is, OutputStream os) {
            this.is = is;
            this.os = os;
        }

        public void run() {
            try {
                int length;
                byte[] buffer = new byte[1024];
                while ((length = this.is.read(buffer)) > 0) {
                    this.os.write(buffer, 0, length);
                }
            }
            catch (IOException e) {
                System.err.println("Could not pipe from the InputStream to the OutputStream: " + e.getMessage());
            }
        }
    }
}

