/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.javacpp;

import com.googlecode.javacpp.Pointer;
import com.googlecode.javacpp.annotation.Platform;
import com.googlecode.javacpp.annotation.Properties;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.URL;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.Map;
import java.util.MissingResourceException;
import java.util.WeakHashMap;
import java.util.logging.Level;
import java.util.logging.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Loader {
    private static final Logger logger = Logger.getLogger(Loader.class.getName());
    private static String platformName = null;
    private static java.util.Properties platformProperties = null;
    static File tempDir = null;
    static boolean loadLibraries = true;
    static Map<String, String> loadedLibraries = Collections.synchronizedMap(new HashMap());
    static WeakHashMap<Class<? extends Pointer>, HashMap<String, Integer>> memberOffsets;

    public static String getPlatformName() {
        if (platformName != null) {
            return platformName;
        }
        String jvmName = System.getProperty("java.vm.name").toLowerCase();
        String osName = System.getProperty("os.name").toLowerCase();
        String osArch = System.getProperty("os.arch").toLowerCase();
        if (jvmName.startsWith("dalvik") && osName.startsWith("linux")) {
            osName = "android";
        } else if (osName.startsWith("mac os x")) {
            osName = "macosx";
        } else {
            int spaceIndex = osName.indexOf(32);
            if (spaceIndex > 0) {
                osName = osName.substring(0, spaceIndex);
            }
        }
        if (osArch.equals("i386") || osArch.equals("i486") || osArch.equals("i586") || osArch.equals("i686")) {
            osArch = "x86";
        } else if (osArch.equals("amd64") || osArch.equals("x86-64")) {
            osArch = "x86_64";
        } else if (osArch.startsWith("arm")) {
            osArch = "arm";
        }
        platformName = osName + "-" + osArch;
        return platformName;
    }

    public static void setPlatformName(String platformName) {
        Loader.platformName = platformName;
        platformProperties = null;
    }

    public static java.util.Properties getProperties() {
        if (platformProperties != null) {
            return platformProperties;
        }
        platformProperties = Loader.getProperties(Loader.getPlatformName());
        return platformProperties;
    }

    public static java.util.Properties getProperties(String name) {
        java.util.Properties p = new java.util.Properties();
        p.put("platform.name", name);
        name = "properties/" + name + ".properties";
        InputStream is = Loader.class.getResourceAsStream(name);
        try {
            try {
                p.load(new InputStreamReader(is));
            }
            catch (NoSuchMethodError e) {
                p.load(is);
            }
        }
        catch (Exception e) {
            name = "properties/generic.properties";
            is = Loader.class.getResourceAsStream(name);
            try {
                try {
                    p.load(new InputStreamReader(is));
                }
                catch (NoSuchMethodError e2) {
                    p.load(is);
                }
            }
            catch (Exception e2) {
                throw new MissingResourceException("Could not even get generic properties: " + e2.getMessage(), Loader.class.getName(), name);
            }
        }
        return p;
    }

    public static Class appendProperties(java.util.Properties properties, Class cls) {
        Platform[] platforms;
        Platform p;
        Class<?> c = cls;
        while (c.getDeclaringClass() != null && !c.isAnnotationPresent(Properties.class) && (!c.isAnnotationPresent(Platform.class) || (p = c.getAnnotation(Platform.class)).define().length <= 0 && p.include().length <= 0 && p.cinclude().length <= 0 && p.includepath().length <= 0 && p.options().length <= 0 && p.linkpath().length <= 0 && p.link().length <= 0 && p.framework().length <= 0 && p.preloadpath().length <= 0 && p.preload().length <= 0 && p.library().length() <= 0)) {
            c = c.getDeclaringClass();
        }
        String platformName = properties.getProperty("platform.name");
        Properties classProperties = c.getAnnotation(Properties.class);
        if (classProperties == null) {
            try {
                Platform platform = c.getAnnotation(Platform.class);
                if (platform == null) {
                    return c;
                }
                platforms = new Platform[]{platform};
            }
            catch (Throwable t) {
                logger.log(Level.WARNING, "Could not append properties for " + c.getCanonicalName() + ": " + t);
                return c;
            }
        } else {
            platforms = classProperties.value();
        }
        String[] define = new String[]{};
        String[] include = new String[]{};
        String[] cinclude = new String[]{};
        String[] includepath = new String[]{};
        String[] options = new String[]{};
        String[] linkpath = new String[]{};
        String[] link = new String[]{};
        String[] framework = new String[]{};
        String[] preloadpath = new String[]{};
        String[] preload = new String[]{};
        String library = "jni" + c.getSimpleName();
        for (Platform p2 : platforms) {
            String[][] names = new String[][]{p2.value(), p2.not()};
            boolean[] matches = new boolean[]{false, false};
            block4: for (int i = 0; i < names.length; ++i) {
                for (String s : names[i]) {
                    if (!platformName.startsWith(s)) continue;
                    matches[i] = true;
                    continue block4;
                }
            }
            if (names[0].length != 0 && !matches[0] || names[1].length != 0 && matches[1]) continue;
            if (p2.define().length > 0) {
                define = p2.define();
            }
            if (p2.include().length > 0) {
                include = p2.include();
            }
            if (p2.cinclude().length > 0) {
                cinclude = p2.cinclude();
            }
            if (p2.includepath().length > 0) {
                includepath = p2.includepath();
            }
            if (p2.options().length > 0) {
                options = p2.options();
            }
            if (p2.linkpath().length > 0) {
                linkpath = p2.linkpath();
            }
            if (p2.link().length > 0) {
                link = p2.link();
            }
            if (p2.framework().length > 0) {
                framework = p2.framework();
            }
            if (p2.preloadpath().length > 0) {
                preloadpath = p2.preloadpath();
            }
            if (p2.preload().length > 0) {
                preload = p2.preload();
            }
            if (p2.library().length() <= 0) continue;
            library = p2.library();
        }
        String s = properties.getProperty("path.separator");
        Loader.appendProperty(properties, "generator.define", "\u0000", define);
        Loader.appendProperty(properties, "generator.include", "\u0000", include);
        Loader.appendProperty(properties, "generator.cinclude", "\u0000", cinclude);
        Loader.appendProperty(properties, "compiler.includepath", s, includepath);
        if (options.length > 0) {
            String defaultOptions = properties.getProperty("compiler.options");
            properties.setProperty("compiler.options", "");
            for (int i = 0; i < options.length; ++i) {
                String o = defaultOptions;
                if (options[i].length() > 0 && (o = properties.getProperty("compiler.options." + options[i])) == null) {
                    logger.log(Level.WARNING, "Could not find a property name \"compiler.options." + options[i] + "\".");
                    continue;
                }
                Loader.appendProperty(properties, "compiler.options", " ", o);
            }
        }
        Loader.appendProperty(properties, "compiler.linkpath", s, linkpath);
        Loader.appendProperty(properties, "compiler.link", s, link);
        Loader.appendProperty(properties, "compiler.framework", s, framework);
        Loader.appendProperty(properties, "loader.preloadpath", s, linkpath);
        Loader.appendProperty(properties, "loader.preloadpath", s, preloadpath);
        Loader.appendProperty(properties, "loader.preload", s, link);
        Loader.appendProperty(properties, "loader.preload", s, preload);
        properties.setProperty("loader.library", library);
        return c;
    }

    public static void appendProperty(java.util.Properties properties, String name, String separator, String ... values) {
        if (values == null || values.length == 0) {
            return;
        }
        if (values.length == 1 && values[0] != null) {
            values = values[0].split(separator);
        }
        String oldValue = properties.getProperty(name, "");
        String[] oldValues = oldValue.split(separator);
        String value = "";
        block0: for (String v : values) {
            if (v == null || v.length() == 0) continue;
            for (String ov : oldValues) {
                if (v.equals(ov)) continue block0;
            }
            if (value.length() > 0 && !value.endsWith(separator)) {
                value = value + separator;
            }
            value = value + v;
        }
        if (value.length() > 0 && oldValue.length() > 0) {
            value = value + separator;
        }
        properties.setProperty(name, value + oldValue);
    }

    public static Class getCallerClass(int i) {
        Class[] classContext = new SecurityManager(){

            public Class[] getClassContext() {
                return super.getClassContext();
            }
        }.getClassContext();
        if (classContext != null) {
            for (int j = 0; j < classContext.length; ++j) {
                if (classContext[j] != Loader.class) continue;
                return classContext[i + j];
            }
        } else {
            try {
                StackTraceElement[] classNames = Thread.currentThread().getStackTrace();
                for (int j = 0; j < classNames.length; ++j) {
                    if (Class.forName(classNames[j].getClassName()) != Loader.class) continue;
                    return Class.forName(classNames[i + j].getClassName());
                }
            }
            catch (ClassNotFoundException classNotFoundException) {
                // empty catch block
            }
        }
        return null;
    }

    public static File extractResource(String name, File directory, String prefix, String suffix) throws IOException {
        Class cls = Loader.getCallerClass(2);
        return Loader.extractResource(cls, name, directory, prefix, suffix);
    }

    public static File extractResource(Class cls, String name, File directory, String prefix, String suffix) throws IOException {
        return Loader.extractResource(cls.getResource(name), directory, prefix, suffix);
    }

    public static File extractResource(URL resourceURL, File directory, String prefix, String suffix) throws IOException {
        InputStream is;
        InputStream inputStream = is = resourceURL != null ? resourceURL.openStream() : null;
        if (is == null) {
            return null;
        }
        File file = null;
        boolean fileExisted = false;
        try {
            int n;
            if (prefix == null && suffix == null) {
                if (directory == null) {
                    directory = new File(System.getProperty("java.io.tmpdir"));
                }
                file = new File(directory, new File(resourceURL.getPath()).getName());
                fileExisted = file.exists();
            } else {
                file = File.createTempFile(prefix, suffix, directory);
            }
            FileOutputStream os = new FileOutputStream(file);
            byte[] data = new byte[is.available()];
            while ((n = is.read(data)) > 0) {
                os.write(data, 0, n);
            }
            is.close();
            os.close();
        }
        catch (IOException e) {
            if (file != null && !fileExisted) {
                file.delete();
            }
            throw e;
        }
        return file;
    }

    public static File getTempDir() {
        if (tempDir == null) {
            File tmpdir = new File(System.getProperty("java.io.tmpdir"));
            File f = null;
            for (int i = 0; i < 1000; ++i) {
                f = new File(tmpdir, "javacpp" + System.nanoTime());
                if (!f.mkdir()) continue;
                tempDir = f;
                tempDir.deleteOnExit();
                break;
            }
        }
        return tempDir;
    }

    public static boolean isLoadLibraries() {
        return loadLibraries;
    }

    public static String load() {
        Class cls = Loader.getCallerClass(2);
        return Loader.load(cls);
    }

    public static String load(Class cls) {
        if (!loadLibraries || cls == null) {
            return null;
        }
        java.util.Properties p = (java.util.Properties)Loader.getProperties().clone();
        cls = Loader.appendProperties(p, cls);
        try {
            cls = Class.forName(cls.getName(), true, cls.getClassLoader());
        }
        catch (ClassNotFoundException ex) {
            NoClassDefFoundError e = new NoClassDefFoundError(ex.toString());
            e.initCause(ex);
            throw e;
        }
        String pathSeparator = p.getProperty("path.separator");
        String platformRoot = p.getProperty("platform.root");
        if (platformRoot != null && !platformRoot.endsWith(File.separator)) {
            platformRoot = platformRoot + File.separator;
        }
        String preloadPath = p.getProperty("loader.preloadpath");
        String preloadLibraries = p.getProperty("loader.preload");
        UnsatisfiedLinkError preloadError = null;
        if (preloadLibraries != null) {
            String[] preloadPaths;
            String[] stringArray = preloadPaths = preloadPath == null ? null : preloadPath.split(pathSeparator);
            if (preloadPaths != null && platformRoot != null) {
                for (int i = 0; i < preloadPaths.length; ++i) {
                    if (new File(preloadPaths[i]).isAbsolute()) continue;
                    preloadPaths[i] = platformRoot + preloadPaths[i];
                }
            }
            String[] libnames = preloadLibraries.split(pathSeparator);
            for (int i = 0; i < libnames.length; ++i) {
                try {
                    Loader.loadLibrary(cls, preloadPaths, libnames[i]);
                    continue;
                }
                catch (UnsatisfiedLinkError e) {
                    preloadError = e;
                }
            }
        }
        try {
            return Loader.loadLibrary(cls, null, p.getProperty("loader.library"));
        }
        catch (UnsatisfiedLinkError e) {
            if (preloadError != null) {
                e.initCause(preloadError);
            }
            throw e;
        }
    }

    public static String loadLibrary(String libnameversion) {
        Class cls = Loader.getCallerClass(2);
        return Loader.loadLibrary(cls, null, libnameversion);
    }

    public static String loadLibrary(String[] paths, String libnameversion) {
        Class cls = Loader.getCallerClass(2);
        return Loader.loadLibrary(cls, paths, libnameversion);
    }

    public static String loadLibrary(Class cls, String[] paths, String libnameversion) {
        if (!loadLibraries || cls == null) {
            return null;
        }
        String className = cls.getName();
        int packageIndex = className.lastIndexOf(46);
        String packageName = packageIndex != -1 ? className.substring(0, packageIndex + 1) : "";
        String hashkey = packageName + libnameversion;
        String filename = loadedLibraries.get(hashkey);
        if (filename != null) {
            return filename;
        }
        String[] s = libnameversion.split("@");
        String libname = s[0];
        String version = s.length > 1 ? s[s.length - 1] : "";
        java.util.Properties p = Loader.getProperties();
        String subdir = p.getProperty("platform.name") + '/';
        String prefix = p.getProperty("library.prefix") + libname;
        String suffix = p.getProperty("library.suffix");
        URL resourceURL = cls.getResource(subdir + prefix + suffix + version);
        if (resourceURL == null) {
            resourceURL = cls.getResource(subdir + prefix + version + suffix);
        }
        if (resourceURL == null) {
            resourceURL = cls.getResource(subdir + prefix + suffix);
        }
        File tempFile = null;
        UnsatisfiedLinkError loadError = null;
        try {
            if (resourceURL != null) {
                tempFile = Loader.extractResource(resourceURL, Loader.getTempDir(), null, null);
                String tempFilename = tempFile.getAbsolutePath();
                loadedLibraries.put(hashkey, tempFilename);
                System.load(tempFilename);
                String string = tempFilename;
                return string;
            }
            for (int j = 0; paths != null && j < paths.length; ++j) {
                File file = new File(paths[j], prefix + suffix + version);
                if (!file.exists()) {
                    file = new File(paths[j], prefix + version + suffix);
                }
                if (!file.exists()) {
                    file = new File(paths[j], prefix + suffix);
                }
                if (!file.exists()) continue;
                filename = file.getPath();
                try {
                    loadedLibraries.put(hashkey, filename);
                    System.load(filename);
                    String string = filename;
                    return string;
                }
                catch (UnsatisfiedLinkError e) {
                    loadError = e;
                    loadedLibraries.remove(hashkey);
                    continue;
                }
            }
            loadedLibraries.put(hashkey, libname);
        }
        catch (UnsatisfiedLinkError e) {
            loadedLibraries.remove(hashkey);
            if (loadError != null) {
                throw loadError;
            }
            throw e;
        }
        catch (IOException ex) {
            loadedLibraries.remove(hashkey);
            UnsatisfiedLinkError e = new UnsatisfiedLinkError(ex.toString());
            e.initCause(ex);
            throw e;
        }
        finally {
            if (tempFile != null && tempFile.exists()) {
                tempFile.deleteOnExit();
            }
        }
        System.loadLibrary(libname);
        String j = libname;
        return j;
    }

    public static void main(String[] args) {
        File tempDir;
        File tmpdir = new File(System.getProperty("java.io.tmpdir"));
        if (!tmpdir.equals((tempDir = new File(args[0])).getParentFile()) || !tempDir.getName().startsWith("javacpp")) {
            return;
        }
        for (File file : tempDir.listFiles()) {
            while (file.exists() && !file.delete()) {
                try {
                    Thread.sleep(100L);
                }
                catch (InterruptedException e) {}
            }
        }
        tempDir.delete();
    }

    static void putMemberOffset(String typeName, String member, int offset) throws ClassNotFoundException {
        Class<?> c = Class.forName(typeName.replace('/', '.'), false, Loader.class.getClassLoader());
        Loader.putMemberOffset(c.asSubclass(Pointer.class), member, offset);
    }

    static synchronized void putMemberOffset(Class<? extends Pointer> type, String member, int offset) {
        HashMap<String, Integer> offsets = memberOffsets.get(type);
        if (offsets == null) {
            offsets = new HashMap();
            memberOffsets.put(type, offsets);
        }
        offsets.put(member, offset);
    }

    public static int offsetof(Class<? extends Pointer> type, String member) {
        return memberOffsets.get(type).get(member);
    }

    public static int sizeof(Class<? extends Pointer> type) {
        return memberOffsets.get(type).get("sizeof");
    }

    static {
        if (Loader.getPlatformName().startsWith("windows")) {
            Runtime.getRuntime().addShutdownHook(new Thread(){

                public void run() {
                    if (tempDir == null) {
                        return;
                    }
                    try {
                        LinkedList<String> command = new LinkedList<String>();
                        command.add(System.getProperty("java.home") + "/bin/java");
                        command.add("-classpath");
                        command.add(System.getProperty("java.class.path"));
                        command.add(Loader.class.getName());
                        command.add(tempDir.getAbsolutePath());
                        new ProcessBuilder(command).start();
                    }
                    catch (IOException e) {
                        throw new RuntimeException(e);
                    }
                }
            });
        }
        memberOffsets = new WeakHashMap();
    }
}

