/*
 * Decompiled with CFR 0.152.
 */
package de.matrixweb.ne;

import com.googlecode.javacpp.BytePointer;
import com.googlecode.javacpp.FunctionPointer;
import com.googlecode.javacpp.Loader;
import com.googlecode.javacpp.Pointer;
import com.googlecode.javacpp.annotation.ByVal;
import com.googlecode.javacpp.annotation.Cast;
import com.googlecode.javacpp.annotation.Name;
import com.googlecode.javacpp.annotation.Namespace;
import com.googlecode.javacpp.annotation.Platform;
import com.googlecode.javacpp.annotation.StdString;
import de.matrixweb.ne.StringFunctor;
import java.util.HashMap;
import java.util.Map;

@Platform(include={"native-engine.h"}, includepath={"src/main/cpp", "target/v8/include"}, link={"native-engine", "v8"}, linkpath={"target/ne"})
public class NativeEngine {
    private NativeEngineImpl impl;
    private FunctionCallback requireCallback;
    private final Map<String, FunctionCallback> functors = new HashMap<String, FunctionCallback>();

    public NativeEngine() {
        this.createNativeEngine(new FunctionCallback("__requireCallback__"){

            @Override
            @Cast(value={"char*"})
            public BytePointer call(@Cast(value={"const char*"}) BytePointer input) {
                throw new IllegalStateException("No require callback defined");
            }
        });
    }

    public NativeEngine(final StringFunctor requireCallback) {
        this.createNativeEngine(new FunctionCallback("__requireCallback__"){

            @Override
            @Cast(value={"char*"})
            public BytePointer call(@Cast(value={"const char*"}) BytePointer input) {
                return new BytePointer(requireCallback.call(input.getString()));
            }
        });
    }

    private synchronized void createNativeEngine(FunctionCallback requireCallback) {
        this.requireCallback = requireCallback;
        this.impl = new NativeEngineImpl();
        this.impl.setRequireCallback(this.requireCallback);
    }

    public void addCallbackFunction(final StringFunctor functor) {
        this.functors.put(functor.getName(), new FunctionCallback(functor.getName()){

            @Override
            @Cast(value={"char*"})
            public BytePointer call(@Cast(value={"const char*"}) BytePointer input) {
                String result = functor.call(input.getString());
                return new BytePointer(result == null ? "" : result);
            }
        });
        this.impl.addFunctionCallback(functor.getName(), this.functors.get(functor.getName()));
    }

    public synchronized void addScript(String script) {
        this.addScript("<unknown>", script);
    }

    public synchronized void addScript(String name, String script) {
        this.impl.addScript(name, script);
    }

    public synchronized String execute(String input) throws NativeEngineException {
        try {
            return this.impl.execute(input);
        }
        catch (RuntimeException e) {
            throw new NativeEngineException("Failed to execute", e);
        }
    }

    public synchronized void dispose() {
        this.impl.deallocate();
        this.impl = null;
    }

    @Name(value={"FunctionCallback"})
    private static class FunctionCallback
    extends FunctionPointer {
        private final String name;

        static {
            Loader.load();
        }

        protected FunctionCallback(String name) {
            this.allocate();
            this.name = name;
        }

        private final native void allocate();

        public String getName() {
            return this.name;
        }

        @Cast(value={"char*"})
        public native BytePointer call(@Cast(value={"const char*"}) BytePointer var1);
    }

    public static class NativeEngineException
    extends Exception {
        private static final long serialVersionUID = 4372554400816327101L;

        public NativeEngineException(String message, Throwable cause) {
            super(message, cause);
        }
    }

    @Namespace(value="ne")
    @Name(value={"NativeEngine<FunctionCallback>"})
    private static class NativeEngineImpl
    extends Pointer {
        static {
            Loader.load();
        }

        public NativeEngineImpl() {
            this.allocate();
        }

        private native void allocate();

        public native void setRequireCallback(@ByVal FunctionCallback var1);

        public native void addFunctionCallback(@StdString String var1, @ByVal FunctionCallback var2);

        public native void addScript(@StdString String var1, @StdString String var2);

        @StdString
        public native String execute(@StdString String var1);
    }
}

