/*
 * Decompiled with CFR 0.152.
 */
package de.matrixweb.smaller.javascript;

import de.matrixweb.smaller.javascript.JavaScriptExecutor;
import de.matrixweb.smaller.javascript.JavaScriptExecutorRhino;
import de.matrixweb.smaller.javascript.JavaScriptExecutorV8;
import java.io.IOException;
import java.io.Reader;
import java.io.Writer;
import java.net.URL;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JavaScriptExecutorFast
implements JavaScriptExecutor {
    private static final Logger LOGGER = LoggerFactory.getLogger(JavaScriptExecutorFast.class);
    private JavaScriptExecutor executor;

    public JavaScriptExecutorFast(String name, int optimizationLevel, Class<?> clazz) {
        try {
            LOGGER.info("Try v8 executor");
            this.executor = new JavaScriptExecutorV8(name, clazz);
        }
        catch (NoClassDefFoundError e) {
            LOGGER.info("Fallback to rhino executor", (Throwable)e);
            this.executor = new JavaScriptExecutorRhino(name, optimizationLevel, clazz);
        }
        catch (UnsatisfiedLinkError e) {
            LOGGER.info("Fallback to rhino executor", (Throwable)e);
            this.executor = new JavaScriptExecutorRhino(name, optimizationLevel, clazz);
        }
    }

    @Override
    public void addGlobalFunction(String name, Object object) {
        this.executor.addGlobalFunction(name, object);
    }

    @Override
    public void addGlobalFunction(String name, Object object, String method) {
        this.executor.addGlobalFunction(name, object, method);
    }

    @Override
    public void addScriptSource(String source, String name) {
        this.executor.addScriptSource(source, name);
    }

    @Override
    public void addScriptFile(String file) {
        this.executor.addScriptFile(file);
    }

    @Override
    public void addScriptFile(URL url) {
        this.executor.addScriptFile(url);
    }

    @Override
    public void addCallScript(String source) {
        this.executor.addCallScript(source);
    }

    @Override
    public void run(Reader input, Writer output) throws IOException {
        this.executor.run(input, output);
    }

    @Override
    public void dispose() {
        this.executor.dispose();
    }
}

