/*
 * Decompiled with CFR 0.152.
 */
package de.matrixweb.smaller.javascript;

import com.fasterxml.jackson.databind.ObjectMapper;
import de.matrixweb.smaller.common.SmallerException;
import de.matrixweb.smaller.javascript.JavaScriptExecutor;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.io.Writer;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import org.apache.commons.io.IOUtils;
import org.mozilla.javascript.Context;
import org.mozilla.javascript.JavaScriptException;
import org.mozilla.javascript.Scriptable;
import org.mozilla.javascript.ScriptableObject;
import org.mozilla.javascript.commonjs.module.ModuleScope;
import org.mozilla.javascript.commonjs.module.ModuleScript;
import org.mozilla.javascript.commonjs.module.ModuleScriptProvider;
import org.mozilla.javascript.commonjs.module.Require;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JavaScriptExecutorRhino
implements JavaScriptExecutor {
    private static final Logger LOGGER = LoggerFactory.getLogger(JavaScriptExecutorRhino.class);
    private boolean initializing = true;
    private final String name;
    private final int optimizationLevel;
    private ModuleScope moduleScope;
    private String source;

    public JavaScriptExecutorRhino(String name) {
        this(name, 9, JavaScriptException.class);
    }

    public JavaScriptExecutorRhino(String name, Class<?> clazz) {
        this(name, 9, clazz);
    }

    public JavaScriptExecutorRhino(String name, int optimizationLevel) {
        this(name, optimizationLevel, JavaScriptException.class);
    }

    public JavaScriptExecutorRhino(String name, int optimizationLevel, Class<?> clazz) {
        this.name = name;
        this.optimizationLevel = optimizationLevel;
        this.init(clazz);
    }

    private void init(Class<?> clazz) {
        Context context = Context.enter();
        context.setOptimizationLevel(this.optimizationLevel);
        context.setLanguageVersion(170);
        ScriptableObject scope = context.initStandardObjects();
        Require require = new Require(Context.getCurrentContext(), scope, this.getModuleScriptProvider(clazz), null, null, false);
        require.install(scope);
        try {
            this.moduleScope = new ModuleScope(scope, new URI("./" + this.name), null);
        }
        catch (URISyntaxException e) {
            throw new SmallerException("Failed to create moduleScope", (Throwable)e);
        }
        this.addGlobalFunction("print", LOGGER, "info");
    }

    @Override
    public final void addGlobalFunction(String name, Object object) {
        this.addGlobalFunction(name, object, name);
    }

    @Override
    public final void addGlobalFunction(String name, Object object, String method) {
        String script = "this['" + name + "'] = (function() {\n" + "    var fn = __" + name + "__['" + method + "'];\n" + "    return function() { return fn.apply(__" + name + "__, arguments); }\n" + "})();\n";
        ScriptableObject.putProperty((Scriptable)this.moduleScope, "__" + name + "__", Context.javaToJS(object, this.moduleScope));
        this.addScriptSource(script, name + "_function_publisher");
    }

    @Override
    public void addScriptSource(String source, String name) {
        Context.getCurrentContext().evaluateString(this.moduleScope, source, name, 1, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addScriptFile(String file) {
        try {
            InputStream script = this.getClass().getResourceAsStream(file);
            try {
                Context.getCurrentContext().evaluateString(this.moduleScope, IOUtils.toString((InputStream)script), file, 1, null);
            }
            finally {
                IOUtils.closeQuietly((InputStream)script);
            }
        }
        catch (IOException e) {
            throw new SmallerException("Failed to include script file", (Throwable)e);
        }
    }

    @Override
    public void addScriptFile(URL url) {
        try {
            Context.getCurrentContext().evaluateString(this.moduleScope, IOUtils.toString((URL)url), url.getFile(), 1, null);
        }
        catch (IOException e) {
            throw new SmallerException("Failed to include script file", (Throwable)e);
        }
    }

    @Override
    public void addCallScript(String source) {
        this.source = source;
    }

    @Override
    public void run(Reader input, Writer output) throws IOException {
        LOGGER.info("Executeing Rhino engine");
        if (this.initializing && Context.getCurrentContext() != null) {
            this.initializing = false;
            Context.exit();
        }
        String data = new ObjectMapper().writeValueAsString((Object)IOUtils.toString((Reader)input));
        Context context = Context.enter();
        try {
            ScriptableObject scope = (ScriptableObject)context.initStandardObjects(this.moduleScope);
            Object result = context.evaluateString(scope, String.format(this.source, data), this.name, 1, null);
            output.append(String.valueOf(result));
        }
        catch (JavaScriptException e) {
            throw new SmallerException("Failed to run javascript", (Throwable)e);
        }
        finally {
            Context.exit();
        }
    }

    @Override
    public void dispose() {
    }

    private ModuleScriptProvider getModuleScriptProvider(final Class<?> clazz) {
        return new ModuleScriptProvider(){

            @Override
            public ModuleScript getModuleScript(Context cx, String moduleId, URI moduleUri, URI baseUri, Scriptable paths) throws IOException, URISyntaxException {
                return JavaScriptExecutorRhino.this.getModuleScript(cx, moduleId, clazz);
            }
        };
    }

    private ModuleScript getModuleScript(Context cx, String moduleId, Class<?> clazz) throws IOException, URISyntaxException {
        String path = '/' + this.name + '/' + moduleId + ".js";
        URL url = clazz.getResource(path);
        if (url == null) {
            return null;
        }
        return new ModuleScript(cx.compileString(IOUtils.toString((URL)url), moduleId, 1, null), new URI(moduleId), null);
    }
}

