/*
 * Decompiled with CFR 0.152.
 */
package org.opalj.br.instructions;

import org.opalj.br.ConstantClass;
import org.opalj.br.ConstantDouble;
import org.opalj.br.ConstantFloat;
import org.opalj.br.ConstantInteger;
import org.opalj.br.ConstantLong;
import org.opalj.br.ConstantString;
import org.opalj.br.ConstantValue;
import org.opalj.br.FieldType;
import org.opalj.br.MethodDescriptor;
import org.opalj.br.MethodHandle;
import org.opalj.br.ReferenceType;
import org.opalj.br.instructions.ACONST_NULL$;
import org.opalj.br.instructions.BIPUSH$;
import org.opalj.br.instructions.DCONST_0$;
import org.opalj.br.instructions.FCONST_0$;
import org.opalj.br.instructions.ICONST_0$;
import org.opalj.br.instructions.ICONST_1$;
import org.opalj.br.instructions.ICONST_2$;
import org.opalj.br.instructions.ICONST_3$;
import org.opalj.br.instructions.ICONST_4$;
import org.opalj.br.instructions.ICONST_5$;
import org.opalj.br.instructions.ICONST_M1$;
import org.opalj.br.instructions.LCONST_0$;
import org.opalj.br.instructions.LoadClass;
import org.opalj.br.instructions.LoadClass_W;
import org.opalj.br.instructions.LoadConstantInstruction;
import org.opalj.br.instructions.LoadDouble;
import org.opalj.br.instructions.LoadFloat;
import org.opalj.br.instructions.LoadFloat_W;
import org.opalj.br.instructions.LoadInt;
import org.opalj.br.instructions.LoadInt_W;
import org.opalj.br.instructions.LoadLong;
import org.opalj.br.instructions.LoadMethodHandle;
import org.opalj.br.instructions.LoadMethodHandle_W;
import org.opalj.br.instructions.LoadMethodType;
import org.opalj.br.instructions.LoadMethodType_W;
import org.opalj.br.instructions.LoadString;
import org.opalj.br.instructions.LoadString_W;
import org.opalj.br.instructions.SIPUSH;
import scala.MatchError;
import scala.Some;

public final class LoadConstantInstruction$ {
    public static LoadConstantInstruction$ MODULE$;

    static {
        new LoadConstantInstruction$();
    }

    public LoadConstantInstruction<Object> apply(int i) {
        LoadConstantInstruction loadConstantInstruction;
        int n = i;
        switch (n) {
            case -1: {
                loadConstantInstruction = ICONST_M1$.MODULE$;
                break;
            }
            case 0: {
                loadConstantInstruction = ICONST_0$.MODULE$;
                break;
            }
            case 1: {
                loadConstantInstruction = ICONST_1$.MODULE$;
                break;
            }
            case 2: {
                loadConstantInstruction = ICONST_2$.MODULE$;
                break;
            }
            case 3: {
                loadConstantInstruction = ICONST_3$.MODULE$;
                break;
            }
            case 4: {
                loadConstantInstruction = ICONST_4$.MODULE$;
                break;
            }
            case 5: {
                loadConstantInstruction = ICONST_5$.MODULE$;
                break;
            }
            default: {
                if (i >= -128 && i <= 127) {
                    loadConstantInstruction = BIPUSH$.MODULE$.apply(i);
                    break;
                }
                if (i >= Short.MIN_VALUE && i <= Short.MAX_VALUE) {
                    loadConstantInstruction = new SIPUSH(i);
                    break;
                }
                loadConstantInstruction = new LoadInt(i);
                break;
            }
        }
        return loadConstantInstruction;
    }

    public LoadConstantInstruction<?> apply(ConstantValue<?> c, boolean wide) {
        LoadConstantInstruction loadConstantInstruction;
        ConstantValue<?> constantValue = c;
        if (constantValue instanceof ConstantDouble) {
            ConstantDouble constantDouble = (ConstantDouble)constantValue;
            double d = constantDouble.value();
            loadConstantInstruction = new LoadDouble(d);
        } else if (constantValue instanceof ConstantFloat) {
            ConstantFloat constantFloat = (ConstantFloat)constantValue;
            float f = constantFloat.value();
            loadConstantInstruction = wide ? new LoadFloat_W(f) : new LoadFloat(f);
        } else if (constantValue instanceof ConstantInteger) {
            ConstantInteger constantInteger = (ConstantInteger)constantValue;
            int i = constantInteger.value();
            loadConstantInstruction = wide ? new LoadInt_W(i) : new LoadInt(i);
        } else if (constantValue instanceof ConstantLong) {
            ConstantLong constantLong = (ConstantLong)constantValue;
            long l = constantLong.value();
            loadConstantInstruction = new LoadLong(l);
        } else if (constantValue instanceof ConstantString) {
            ConstantString constantString = (ConstantString)constantValue;
            String s = constantString.value();
            loadConstantInstruction = wide ? new LoadString_W(s) : new LoadString(s);
        } else if (constantValue instanceof ConstantClass) {
            ConstantClass constantClass = (ConstantClass)constantValue;
            ReferenceType c2 = constantClass.value();
            loadConstantInstruction = wide ? new LoadClass_W(c2) : new LoadClass(c2);
        } else if (constantValue instanceof MethodDescriptor) {
            MethodDescriptor methodDescriptor = (MethodDescriptor)constantValue;
            loadConstantInstruction = wide ? new LoadMethodType_W(methodDescriptor) : new LoadMethodType(methodDescriptor);
        } else if (constantValue instanceof MethodHandle) {
            MethodHandle methodHandle = (MethodHandle)constantValue;
            loadConstantInstruction = wide ? new LoadMethodHandle_W(methodHandle) : new LoadMethodHandle(methodHandle);
        } else {
            throw new MatchError(constantValue);
        }
        return loadConstantInstruction;
    }

    public <T> Some<T> unapply(LoadConstantInstruction<T> ldc) {
        return new Some(ldc.value());
    }

    public LoadConstantInstruction<?> defaultValue(FieldType fieldType) {
        LoadConstantInstruction loadConstantInstruction;
        int n = fieldType.id();
        switch (n) {
            case -2147483638: {
                loadConstantInstruction = ICONST_0$.MODULE$;
                break;
            }
            case -2147483640: {
                loadConstantInstruction = ICONST_0$.MODULE$;
                break;
            }
            case -2147483643: {
                loadConstantInstruction = ICONST_0$.MODULE$;
                break;
            }
            case -2147483639: {
                loadConstantInstruction = ICONST_0$.MODULE$;
                break;
            }
            case -2147483644: {
                loadConstantInstruction = ICONST_0$.MODULE$;
                break;
            }
            case -2147483637: {
                loadConstantInstruction = LCONST_0$.MODULE$;
                break;
            }
            case -2147483642: {
                loadConstantInstruction = FCONST_0$.MODULE$;
                break;
            }
            case -2147483641: {
                loadConstantInstruction = DCONST_0$.MODULE$;
                break;
            }
            default: {
                loadConstantInstruction = ACONST_NULL$.MODULE$;
                break;
            }
        }
        return loadConstantInstruction;
    }

    private LoadConstantInstruction$() {
        MODULE$ = this;
    }
}

