/*
 * Decompiled with CFR 0.152.
 */
package org.opalj.br;

import com.typesafe.config.Config;
import com.typesafe.config.ConfigFactory;
import java.io.Serializable;
import org.opalj.bi.AccessFlags$;
import org.opalj.bi.AccessFlagsContexts$;
import org.opalj.br.Annotation;
import org.opalj.br.ArrayType;
import org.opalj.br.Attribute;
import org.opalj.br.BaseType;
import org.opalj.br.CTIntType$;
import org.opalj.br.ElementValuePair;
import org.opalj.br.ExceptionHandler;
import org.opalj.br.Field;
import org.opalj.br.FieldTemplate;
import org.opalj.br.FieldType;
import org.opalj.br.Method;
import org.opalj.br.MethodDescriptor;
import org.opalj.br.MethodTemplate;
import org.opalj.br.ObjectType;
import org.opalj.br.Type;
import org.opalj.br.TypeAnnotation;
import org.opalj.br.VoidType$;
import org.opalj.collection.immutable.IntTrieSet;
import org.opalj.collection.immutable.IntTrieSet$;
import org.opalj.collection.immutable.RefArray;
import org.opalj.collection.immutable.RefArray$;
import org.opalj.log.GlobalLogContext$;
import org.opalj.log.LogContext;
import org.opalj.log.OPALLogger$;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.Predef$;
import scala.collection.Seq;
import scala.collection.TraversableOnce;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.Builder;
import scala.xml.Elem;
import scala.xml.MetaData;
import scala.xml.NamespaceBinding;
import scala.xml.Node;
import scala.xml.NodeBuffer;
import scala.xml.Null$;
import scala.xml.Text;
import scala.xml.Text$;
import scala.xml.TopScope$;
import scala.xml.UnprefixedAttribute;

public final class package$ {
    public static package$ MODULE$;
    private final Config BaseConfig;
    private final RefArray$ Attributes;
    private final RefArray$ ElementValuePairs;
    private final RefArray$ Methods;
    private final RefArray$ ObjectTypes;
    private final RefArray$ FieldTypes;
    private final IntTrieSet NoPCs;

    static {
        new package$();
    }

    public final String FrameworkName() {
        return "OPAL Bytecode Representation";
    }

    public Config BaseConfig() {
        return this.BaseConfig;
    }

    public final String ConfigKeyPrefix() {
        return "org.opalj.br.";
    }

    public RefArray$ Attributes() {
        return this.Attributes;
    }

    public final RefArray<Attribute> NoAttributes() {
        return RefArray$.MODULE$.empty();
    }

    public RefArray$ ElementValuePairs() {
        return this.ElementValuePairs;
    }

    public final RefArray<ElementValuePair> NoElementValuePairs() {
        return RefArray$.MODULE$.empty();
    }

    public RefArray<Annotation> NoAnnotations() {
        return RefArray$.MODULE$.empty();
    }

    public final RefArray<TypeAnnotation> NoTypeAnnotations() {
        return RefArray$.MODULE$.empty();
    }

    public final RefArray<ObjectType> NoInterfaces() {
        return RefArray$.MODULE$.empty();
    }

    public RefArray$ Methods() {
        return this.Methods;
    }

    public final RefArray<Method> NoMethods() {
        return RefArray$.MODULE$.empty();
    }

    public final RefArray<MethodTemplate> NoMethodTemplates() {
        return RefArray$.MODULE$.empty();
    }

    public final RefArray<ExceptionHandler> NoExceptionHandlers() {
        return RefArray$.MODULE$.empty();
    }

    public final RefArray<RefArray<Annotation>> NoParameterAnnotations() {
        return RefArray$.MODULE$.empty();
    }

    public final RefArray<Field> NoFields() {
        return RefArray$.MODULE$.empty();
    }

    public final RefArray<FieldTemplate> NoFieldTemplates() {
        return RefArray$.MODULE$.empty();
    }

    public RefArray$ ObjectTypes() {
        return this.ObjectTypes;
    }

    public RefArray$ FieldTypes() {
        return this.FieldTypes;
    }

    public final RefArray<FieldType> NoFieldTypes() {
        return RefArray$.MODULE$.empty();
    }

    public final Builder<FieldType, RefArray<FieldType>> newFieldTypesBuilder() {
        return RefArray$.MODULE$.newBuilder();
    }

    public final IntTrieSet NoPCs() {
        return this.NoPCs;
    }

    public String annotationsToJava(RefArray<Annotation> annotations, String before, String after) {
        Function1 & Serializable & scala.Serializable annotationToJava = (Function1 & Serializable & scala.Serializable)annotation -> {
            void var1_1;
            String s = annotation.toJava();
            return s.length() > 50 && annotation.elementValuePairs().nonEmpty() ? new StringBuilder(5).append(annotation.annotationType().toJava()).append("(...)").toString() : var1_1;
        };
        return annotations.nonEmpty() ? new StringBuilder(0).append(before).append(annotations.map((Function1)annotationToJava).mkString(" ")).append(after).toString() : "";
    }

    public String annotationsToJava$default$2() {
        return "";
    }

    public String annotationsToJava$default$3() {
        return "";
    }

    public Node typeToXHTML(Type t, boolean abbreviateType) {
        Elem elem;
        Type type = t;
        if (type instanceof ObjectType) {
            Elem elem2;
            ObjectType objectType = (ObjectType)type;
            if (abbreviateType) {
                Null$ $md = Null$.MODULE$;
                $md = new UnprefixedAttribute("title", objectType.toJava(), (MetaData)$md);
                $md = new UnprefixedAttribute("class", (Seq)new Text("type object_type"), (MetaData)$md);
                NodeBuffer $buf = new NodeBuffer();
                $buf.$amp$plus((Object)new Text("\n                        "));
                $buf.$amp$plus((Object)objectType.simpleName());
                $buf.$amp$plus((Object)new Text("\n                    "));
                Elem elem3 = new Elem(null, "abbr", (MetaData)$md, (NamespaceBinding)TopScope$.MODULE$, false, (Seq)$buf);
                elem2 = elem3;
            } else {
                Null$ $md = Null$.MODULE$;
                $md = new UnprefixedAttribute("class", (Seq)new Text("type object_type"), (MetaData)$md);
                NodeBuffer $buf = new NodeBuffer();
                $buf.$amp$plus((Object)objectType.toJava());
                Elem elem4 = new Elem(null, "span", (MetaData)$md, (NamespaceBinding)TopScope$.MODULE$, false, (Seq)$buf);
                elem2 = elem4;
            }
            elem = elem2;
        } else if (type instanceof ArrayType) {
            ArrayType arrayType = (ArrayType)type;
            Null$ $md = Null$.MODULE$;
            $md = new UnprefixedAttribute("class", (Seq)new Text("type array_type"), (MetaData)$md);
            NodeBuffer $buf = new NodeBuffer();
            $buf.$amp$plus((Object)new Text("\n                    "));
            $buf.$amp$plus((Object)this.typeToXHTML(arrayType.elementType(), abbreviateType));
            $buf.$amp$plus((Object)new StringOps(Predef$.MODULE$.augmentString("[]")).$times(arrayType.dimensions()));
            $buf.$amp$plus((Object)new Text("\n                "));
            elem = new Elem(null, "span", (MetaData)$md, (NamespaceBinding)TopScope$.MODULE$, false, (Seq)$buf);
        } else if (type instanceof BaseType) {
            BaseType baseType = (BaseType)type;
            Null$ $md = Null$.MODULE$;
            $md = new UnprefixedAttribute("class", (Seq)new Text("type base_type"), (MetaData)$md);
            NodeBuffer $buf = new NodeBuffer();
            $buf.$amp$plus((Object)baseType.toJava());
            elem = new Elem(null, "span", (MetaData)$md, (NamespaceBinding)TopScope$.MODULE$, false, (Seq)$buf);
        } else if (((Object)VoidType$.MODULE$).equals(type)) {
            Null$ $md = Null$.MODULE$;
            $md = new UnprefixedAttribute("class", (Seq)new Text("type void_type"), (MetaData)$md);
            NodeBuffer $buf = new NodeBuffer();
            $buf.$amp$plus((Object)new Text("void"));
            elem = new Elem(null, "span", (MetaData)$md, (NamespaceBinding)TopScope$.MODULE$, false, (Seq)$buf);
        } else if (((Object)CTIntType$.MODULE$).equals(type)) {
            Null$ $md = Null$.MODULE$;
            $md = new UnprefixedAttribute("class", (Seq)new Text("type base_type"), (MetaData)$md);
            NodeBuffer $buf = new NodeBuffer();
            $buf.$amp$plus((Object)"<Computational Type Integer>");
            elem = new Elem(null, "span", (MetaData)$md, (NamespaceBinding)TopScope$.MODULE$, false, (Seq)$buf);
        } else {
            throw new MatchError((Object)type);
        }
        return elem;
    }

    /*
     * WARNING - void declaration
     */
    public Node classAccessFlagsToXHTML(int accessFlags) {
        void var3_3;
        Null$ $md = Null$.MODULE$;
        $md = new UnprefixedAttribute("class", (Seq)new Text("access_flags"), (MetaData)$md);
        NodeBuffer $buf = new NodeBuffer();
        $buf.$amp$plus((Object)AccessFlags$.MODULE$.toString(accessFlags, AccessFlagsContexts$.MODULE$.CLASS()));
        return new Elem(null, "span", (MetaData)$md, (NamespaceBinding)TopScope$.MODULE$, false, (Seq)var3_3);
    }

    public String classAccessFlagsToString(int accessFlags) {
        return AccessFlags$.MODULE$.toString(accessFlags, AccessFlagsContexts$.MODULE$.CLASS());
    }

    public Node typeToXHTML(int accessFlags, Type t, boolean abbreviateTypes) {
        Node signature = this.typeToXHTML(t, abbreviateTypes);
        Null$ $md = Null$.MODULE$;
        $md = new UnprefixedAttribute("class", (Seq)new Text("type_signature_with_access_flags"), (MetaData)$md);
        NodeBuffer $buf = new NodeBuffer();
        $buf.$amp$plus((Object)new Text("\n            "));
        $buf.$amp$plus((Object)this.classAccessFlagsToXHTML(accessFlags));
        $buf.$amp$plus((Object)new Text("\n            "));
        $buf.$amp$plus((Object)signature);
        $buf.$amp$plus((Object)new Text("\n        "));
        return new Elem(null, "span", (MetaData)$md, (NamespaceBinding)TopScope$.MODULE$, false, (Seq)$buf);
    }

    public boolean typeToXHTML$default$2() {
        return true;
    }

    public Node methodToXHTML(String name, MethodDescriptor descriptor, boolean abbreviateTypes) {
        .colon.colon colon2;
        if (descriptor.parametersCount() == 0) {
            colon2 = new .colon.colon((Object)Text$.MODULE$.apply(""), (List)Nil$.MODULE$);
        } else {
            RefArray parameterTypes = descriptor.parameterTypes().map((Function1 & Serializable & scala.Serializable)x$1 -> MODULE$.typeToXHTML((Type)x$1, abbreviateTypes));
            colon2 = ((List)((TraversableOnce)parameterTypes.tail()).foldLeft((Object)new .colon.colon((Object)((Node)parameterTypes.head()), (List)Nil$.MODULE$), (Function2 & Serializable & scala.Serializable)(c, r) -> {
                Node node = r;
                Text text = Text$.MODULE$.apply(", ");
                return c.$colon$colon((Object)text).$colon$colon((Object)node);
            })).reverse();
        }
        .colon.colon parameterTypes = colon2;
        Null$ $md = Null$.MODULE$;
        $md = new UnprefixedAttribute("class", (Seq)new Text("method_signature"), (MetaData)$md);
        NodeBuffer $buf = new NodeBuffer();
        $buf.$amp$plus((Object)new Text("\n            "));
        Null$ $md2 = Null$.MODULE$;
        $md2 = new UnprefixedAttribute("class", (Seq)new Text("method_return_type"), (MetaData)$md2);
        NodeBuffer $buf2 = new NodeBuffer();
        $buf2.$amp$plus((Object)this.typeToXHTML(descriptor.returnType(), abbreviateTypes));
        $buf.$amp$plus((Object)new Elem(null, "span", (MetaData)$md2, (NamespaceBinding)TopScope$.MODULE$, false, (Seq)$buf2));
        $buf.$amp$plus((Object)new Text("\n            "));
        Null$ $md3 = Null$.MODULE$;
        $md3 = new UnprefixedAttribute("class", (Seq)new Text("method_name"), (MetaData)$md3);
        NodeBuffer $buf3 = new NodeBuffer();
        $buf3.$amp$plus((Object)name);
        $buf.$amp$plus((Object)new Elem(null, "span", (MetaData)$md3, (NamespaceBinding)TopScope$.MODULE$, false, (Seq)$buf3));
        $buf.$amp$plus((Object)new Text("\n            "));
        Null$ $md4 = Null$.MODULE$;
        $md4 = new UnprefixedAttribute("class", (Seq)new Text("method_parameters"), (MetaData)$md4);
        NodeBuffer $buf4 = new NodeBuffer();
        $buf4.$amp$plus((Object)new Text("("));
        $buf4.$amp$plus((Object)parameterTypes);
        $buf4.$amp$plus((Object)new Text(")"));
        $buf.$amp$plus((Object)new Elem(null, "span", (MetaData)$md4, (NamespaceBinding)TopScope$.MODULE$, false, (Seq)$buf4));
        $buf.$amp$plus((Object)new Text("\n        "));
        return new Elem(null, "span", (MetaData)$md, (NamespaceBinding)TopScope$.MODULE$, false, (Seq)$buf);
    }

    public Node methodToXHTML(int accessFlags, String name, MethodDescriptor descriptor, boolean abbreviateTypes) {
        Node signature = this.methodToXHTML(name, descriptor, abbreviateTypes);
        Null$ $md = Null$.MODULE$;
        $md = new UnprefixedAttribute("class", (Seq)new Text("method_signature_with_access_flags"), (MetaData)$md);
        NodeBuffer $buf = new NodeBuffer();
        $buf.$amp$plus((Object)new Text("\n            "));
        Null$ $md2 = Null$.MODULE$;
        $md2 = new UnprefixedAttribute("class", (Seq)new Text("access_flags"), (MetaData)$md2);
        NodeBuffer $buf2 = new NodeBuffer();
        $buf2.$amp$plus((Object)this.methodAccessFlagsToString(accessFlags));
        $buf.$amp$plus((Object)new Elem(null, "span", (MetaData)$md2, (NamespaceBinding)TopScope$.MODULE$, false, (Seq)$buf2));
        $buf.$amp$plus((Object)new Text("\n            "));
        $buf.$amp$plus((Object)signature);
        $buf.$amp$plus((Object)new Text("\n        "));
        return new Elem(null, "span", (MetaData)$md, (NamespaceBinding)TopScope$.MODULE$, false, (Seq)$buf);
    }

    public boolean methodToXHTML$default$3() {
        return true;
    }

    public String methodAccessFlagsToString(int accessFlags) {
        return AccessFlags$.MODULE$.toString(accessFlags, AccessFlagsContexts$.MODULE$.METHOD());
    }

    private package$() {
        MODULE$ = this;
        GlobalLogContext$ logContext = GlobalLogContext$.MODULE$;
        try {
            Predef$.MODULE$.assert(false);
            OPALLogger$.MODULE$.info("OPAL Bytecode Representation", "Production Build", (LogContext)logContext);
        }
        catch (AssertionError assertionError) {
            OPALLogger$.MODULE$.info("OPAL Bytecode Representation", "Development Build with Assertions", (LogContext)logContext);
        }
        this.BaseConfig = ConfigFactory.load((ClassLoader)this.getClass().getClassLoader());
        this.Attributes = RefArray$.MODULE$;
        this.ElementValuePairs = RefArray$.MODULE$;
        this.Methods = RefArray$.MODULE$;
        this.ObjectTypes = RefArray$.MODULE$;
        this.FieldTypes = RefArray$.MODULE$;
        this.NoPCs = IntTrieSet$.MODULE$.empty();
    }
}

