/*
 * Decompiled with CFR 0.152.
 */
package org.opalj.fpcf;

import com.typesafe.config.Config;
import com.typesafe.config.ConfigFactory;
import com.typesafe.config.ConfigObject;
import com.typesafe.config.ConfigValue;
import java.util.Map;
import org.opalj.fpcf.AbstractFPCFAnalysisScheduler;
import org.opalj.fpcf.FPCFEagerAnalysisScheduler;
import org.opalj.fpcf.FPCFLazyAnalysisScheduler;
import org.opalj.log.GlobalLogContext$;
import org.opalj.log.LogContext;
import org.opalj.log.OPALLogger$;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.ScalaReflectionException;
import scala.Some;
import scala.Tuple2;
import scala.collection.Iterable;
import scala.collection.immutable.Map;
import scala.reflect.api.JavaUniverse;
import scala.reflect.api.Mirror;
import scala.reflect.api.Symbols;
import scala.reflect.runtime.package$;

public final class FPCFAnalysesRegistry$ {
    public static FPCFAnalysesRegistry$ MODULE$;
    private Map<String, FPCFEagerAnalysisScheduler> idToEagerScheduler;
    private Map<String, FPCFLazyAnalysisScheduler> idToLazyScheduler;
    private Map<String, String> idToDescription;

    static {
        new FPCFAnalysesRegistry$();
    }

    private LogContext logContext() {
        return GlobalLogContext$.MODULE$;
    }

    public synchronized void register(String analysisID, String analysisDescription, String analysisFactory, boolean lazyFactory) {
        Option<AbstractFPCFAnalysisScheduler> analysisRunner = this.resolveAnalysisRunner(analysisFactory);
        if (analysisRunner.nonEmpty()) {
            if (lazyFactory) {
                this.idToLazyScheduler = this.idToLazyScheduler.$plus(new Tuple2((Object)analysisID, (Object)((FPCFLazyAnalysisScheduler)analysisRunner.get())));
            } else {
                this.idToEagerScheduler = this.idToEagerScheduler.$plus(new Tuple2((Object)analysisID, (Object)((FPCFEagerAnalysisScheduler)analysisRunner.get())));
            }
            this.idToDescription = this.idToDescription.$plus(new Tuple2((Object)analysisID, (Object)analysisDescription));
            OPALLogger$.MODULE$.info("OPAL Setup", new StringBuilder(24).append("registered analysis: ").append(analysisID).append(" (").append(analysisDescription).append(")").toString(), this.logContext());
        } else {
            OPALLogger$.MODULE$.error("OPAL Setup", new StringBuilder(33).append("unknown analysis implementation: ").append(analysisFactory).toString(), this.logContext());
        }
    }

    private Option<AbstractFPCFAnalysisScheduler> resolveAnalysisRunner(String fqn) {
        Some some;
        JavaUniverse.JavaMirror mirror = package$.MODULE$.universe().runtimeMirror(this.getClass().getClassLoader());
        try {
            Symbols.ModuleSymbolApi module2 = ((Mirror)mirror).staticModule(fqn);
            some = new Some((Object)((AbstractFPCFAnalysisScheduler)mirror.reflectModule(module2).instance()));
        }
        catch (ScalaReflectionException sre) {
            OPALLogger$.MODULE$.error("FPCF registry", "cannot find analysis scheduler", (Throwable)sre, this.logContext());
            some = None$.MODULE$;
        }
        catch (ClassCastException cce) {
            OPALLogger$.MODULE$.error("FPCF registry", "analysis scheduler class is invalid", (Throwable)cce, this.logContext());
            some = None$.MODULE$;
        }
        return some;
    }

    public void registerFromConfig() {
        Config config = ConfigFactory.load();
        try {
            ConfigObject registeredAnalyses = config.getObject("org.opalj.fpcf.registry.analyses");
            for (Map.Entry entry : registeredAnalyses.entrySet()) {
                ConfigValue lazyFactory;
                String id = (String)entry.getKey();
                ConfigObject metaData = (ConfigObject)entry.getValue();
                String description = ((ConfigValue)metaData.getOrDefault((Object)"description", null)).unwrapped().toString();
                ConfigValue eagerFactory = (ConfigValue)metaData.getOrDefault((Object)"eagerFactory", null);
                if (eagerFactory != null) {
                    this.register(id, description, eagerFactory.unwrapped().toString(), false);
                }
                if ((lazyFactory = (ConfigValue)metaData.getOrDefault((Object)"lazyFactory", null)) == null) continue;
                this.register(id, description, lazyFactory.unwrapped().toString(), true);
            }
        }
        catch (Exception e) {
            OPALLogger$.MODULE$.error("OPAL Setup", "registration of FPCF eager analyses failed", (Throwable)e, this.logContext());
        }
    }

    public synchronized Iterable<String> analysisIDs() {
        return this.idToDescription.keys();
    }

    public synchronized Iterable<String> analysisDescriptions() {
        return this.idToDescription.values();
    }

    public synchronized Iterable<FPCFEagerAnalysisScheduler> eagerFactories() {
        return this.idToEagerScheduler.values();
    }

    public synchronized Iterable<FPCFLazyAnalysisScheduler> lazyFactories() {
        return this.idToLazyScheduler.values();
    }

    public synchronized FPCFEagerAnalysisScheduler eagerFactory(String id) {
        return (FPCFEagerAnalysisScheduler)this.idToEagerScheduler.apply((Object)id);
    }

    public synchronized FPCFLazyAnalysisScheduler lazyFactory(String id) {
        return (FPCFLazyAnalysisScheduler)this.idToLazyScheduler.apply((Object)id);
    }

    private FPCFAnalysesRegistry$() {
        MODULE$ = this;
        this.idToEagerScheduler = Predef$.MODULE$.Map().empty();
        this.idToLazyScheduler = Predef$.MODULE$.Map().empty();
        this.idToDescription = Predef$.MODULE$.Map().empty();
        this.registerFromConfig();
    }
}

