/*
 * Decompiled with CFR 0.152.
 */
package de.quantummaid.eventmaid.channel.action;

import de.quantummaid.eventmaid.channel.action.Action;
import de.quantummaid.eventmaid.channel.action.ActionHandler;
import de.quantummaid.eventmaid.channel.action.NoHandlerForUnknownActionException;
import java.util.HashMap;
import java.util.Map;

public final class ActionHandlerSet<T> {
    private final Map<Class<? extends Action>, ActionHandler<? extends Action<T>, T>> actionHandlerMap;

    private ActionHandlerSet(Map<Class<? extends Action>, ActionHandler<? extends Action<T>, T>> actionHandlerMap) {
        this.actionHandlerMap = actionHandlerMap;
    }

    public static <T> ActionHandlerSet<T> actionHandlerSet(Map<Class<? extends Action>, ActionHandler<? extends Action<T>, T>> handlerMap) {
        return new ActionHandlerSet<T>(handlerMap);
    }

    public static <T> ActionHandlerSet<T> emptyActionHandlerSet() {
        HashMap<Class<? extends Action>, ActionHandler<? extends Action<T>, T>> map = new HashMap<Class<? extends Action>, ActionHandler<? extends Action<T>, T>>();
        return new ActionHandlerSet<T>(map);
    }

    public ActionHandler<Action<T>, T> getActionHandlerFor(Action<T> action) {
        Class<?> actionClass = action.getClass();
        ActionHandler<? extends Action<T>, T> actionHandler = this.actionHandlerMap.get(actionClass);
        if (actionHandler != null) {
            return actionHandler;
        }
        throw new NoHandlerForUnknownActionException(action);
    }

    public void registerActionHandler(Class<? extends Action> actionClass, ActionHandler<? extends Action<T>, T> actionHandler) {
        this.actionHandlerMap.put(actionClass, actionHandler);
    }
}

