/*
 * Decompiled with CFR 0.152.
 */
package de.quantummaid.eventmaid.channel.action;

import de.quantummaid.eventmaid.channel.ChannelProcessingFrame;
import de.quantummaid.eventmaid.channel.action.Action;
import de.quantummaid.eventmaid.channel.action.ActionHandler;
import de.quantummaid.eventmaid.channel.action.Call;
import de.quantummaid.eventmaid.channel.action.Return;
import de.quantummaid.eventmaid.channel.action.ReturnWithoutCallException;
import de.quantummaid.eventmaid.processingContext.ProcessingContext;

public final class ReturnActionHandler<T>
implements ActionHandler<Return<T>, T> {
    public static <T> ReturnActionHandler<T> returnActionHandler() {
        return new ReturnActionHandler<T>();
    }

    @Override
    public void handle(Return<T> returnAction, ProcessingContext<T> processingContext) {
        ChannelProcessingFrame currentProcessingFrame = processingContext.getCurrentProcessingFrame();
        ChannelProcessingFrame<T> callProcessingFrame = this.locateLastNotYetReturnedCallProcessingFrame(currentProcessingFrame);
        Call callAction = (Call)callProcessingFrame.getAction();
        callAction.setReturnFrame(currentProcessingFrame);
        returnAction.setRelatedCallFrame(callProcessingFrame);
        ChannelProcessingFrame nextProcessingFrame = callAction.getProcessingFrameToContinueAfterReturn();
        currentProcessingFrame.setNextFrame(nextProcessingFrame);
        nextProcessingFrame.setPreviousFrame(currentProcessingFrame);
        processingContext.setCurrentProcessingFrame(nextProcessingFrame);
    }

    private ChannelProcessingFrame<T> locateLastNotYetReturnedCallProcessingFrame(ChannelProcessingFrame<T> latestFrame) {
        ChannelProcessingFrame<T> currentProcessingFrame = latestFrame;
        while (currentProcessingFrame != null) {
            Action<T> action = currentProcessingFrame.getAction();
            if (action instanceof Call) {
                Call callAction = (Call)action;
                ChannelProcessingFrame returnFrame = callAction.getReturnFrame();
                if (returnFrame == null) {
                    return currentProcessingFrame;
                }
                currentProcessingFrame = currentProcessingFrame.getPreviousFrame();
                continue;
            }
            currentProcessingFrame = currentProcessingFrame.getPreviousFrame();
        }
        throw new ReturnWithoutCallException();
    }

    private ReturnActionHandler() {
    }
}

