/*
 * Decompiled with CFR 0.152.
 */
package de.quantummaid.eventmaid.internal.collections.predicatemap;

import de.quantummaid.eventmaid.internal.enforcing.NotNullEnforcer;
import java.util.Map;
import java.util.function.Predicate;

public final class PredicateMap<P, T> {
    private final Map<Predicate<P>, T> entries;
    private final T defaultValue;

    static <P, T> PredicateMap<P, T> predicateMap(Map<Predicate<P>, T> entries, T defaultValue) {
        NotNullEnforcer.ensureNotNull(entries, "entries");
        NotNullEnforcer.ensureNotNull(defaultValue, "defaultValue");
        return new PredicateMap<P, T>(entries, defaultValue);
    }

    public T get(P condition) {
        return (T)this.entries.entrySet().stream().filter(e -> ((Predicate)e.getKey()).test(condition)).map(Map.Entry::getValue).findFirst().orElse(this.defaultValue);
    }

    private PredicateMap(Map<Predicate<P>, T> entries, T defaultValue) {
        this.entries = entries;
        this.defaultValue = defaultValue;
    }
}

