/*
 * Decompiled with CFR 0.152.
 */
package de.quantummaid.eventmaid.internal.pipe.statistics;

import de.quantummaid.eventmaid.internal.pipe.statistics.PipeStatistics;
import de.quantummaid.eventmaid.internal.pipe.statistics.PipeStatisticsCollector;
import java.math.BigInteger;
import java.util.Date;
import java.util.concurrent.atomic.AtomicLong;

public final class AtomicPipeStatisticsCollector
implements PipeStatisticsCollector {
    private final AtomicLong acceptedMessages = new AtomicLong();
    private final AtomicLong queuedMessages = new AtomicLong();
    private final AtomicLong successfulMessages = new AtomicLong();
    private final AtomicLong failedMessages = new AtomicLong();

    public static AtomicPipeStatisticsCollector atomicPipeStatisticsCollector() {
        return new AtomicPipeStatisticsCollector();
    }

    @Override
    public PipeStatistics getCurrentStatistics() {
        BigInteger acceptedMessages = this.asBigInt(this.acceptedMessages);
        BigInteger queuedMessages = this.asBigInt(this.queuedMessages);
        BigInteger successfulMessages = this.asBigInt(this.successfulMessages);
        BigInteger failedMessages = this.asBigInt(this.failedMessages);
        Date timestamp = new Date();
        return PipeStatistics.pipeStatistics(timestamp, acceptedMessages, queuedMessages, successfulMessages, failedMessages);
    }

    @Override
    public void informMessageAccepted() {
        this.acceptedMessages.incrementAndGet();
    }

    @Override
    public void informMessageQueued() {
        this.queuedMessages.incrementAndGet();
    }

    @Override
    public void informMessageDequeued() {
        this.queuedMessages.decrementAndGet();
    }

    @Override
    public void informMessageDeliveredSucceeded() {
        this.successfulMessages.incrementAndGet();
    }

    @Override
    public void informMessageDeliveryFailed() {
        this.failedMessages.incrementAndGet();
    }

    private BigInteger asBigInt(AtomicLong atomicLong) {
        long value = atomicLong.get();
        return BigInteger.valueOf(value);
    }

    private AtomicPipeStatisticsCollector() {
    }
}

