/*
 * Decompiled with CFR 0.152.
 */
package de.quantummaid.eventmaid.messageBus.internal.exception;

import de.quantummaid.eventmaid.channel.Channel;
import de.quantummaid.eventmaid.channel.exception.ChannelExceptionHandler;
import de.quantummaid.eventmaid.internal.exceptions.BubbleUpWrappedException;
import de.quantummaid.eventmaid.messageBus.exception.MessageBusExceptionHandler;
import de.quantummaid.eventmaid.processingContext.ProcessingContext;

public final class DelegatingChannelExceptionHandler<T>
implements ChannelExceptionHandler<T> {
    private final MessageBusExceptionHandler messageBusExceptionHandler;
    private final DeliveryAbortDecision<T> deliveryAbortDecision;
    private Channel<Object> channel;

    public static <T> DelegatingChannelExceptionHandler<T> delegatingChannelExceptionHandlerForDeliveryChannel(MessageBusExceptionHandler messageBusExceptionHandler) {
        DeliveryAbortDecision<T> d = DelegatingChannelExceptionHandler.delegatingDeliveryAbortingException(messageBusExceptionHandler);
        return new DelegatingChannelExceptionHandler<T>(messageBusExceptionHandler, d);
    }

    private static <T> DeliveryAbortDecision<T> delegatingDeliveryAbortingException(MessageBusExceptionHandler messageBusExceptionHandler) {
        return (message, e, c) -> {
            ProcessingContext ungenericMessage = message;
            Channel ungericChannel = c;
            return messageBusExceptionHandler.shouldDeliveryChannelErrorBeHandledAndDeliveryAborted(ungenericMessage, e, ungericChannel);
        };
    }

    public static <T> DelegatingChannelExceptionHandler<T> delegatingChannelExceptionHandlerForAcceptingChannel(MessageBusExceptionHandler messageBusExceptionHandler) {
        DeliveryAbortDecision d = (m3, e, c) -> true;
        return new DelegatingChannelExceptionHandler(messageBusExceptionHandler, d);
    }

    @Override
    public boolean shouldSubscriberErrorBeHandledAndDeliveryAborted(ProcessingContext<T> message, Exception e) {
        return this.deliveryAbortDecision.shouldSubscriberErrorBeHandledAndDeliveryAborted(message, e, this.channel);
    }

    @Override
    public void handleSubscriberException(ProcessingContext<T> message, Exception e) {
        this.handleDeliveryException(message, e);
    }

    private void handleDeliveryException(ProcessingContext message, Exception e) {
        this.messageBusExceptionHandler.handleDeliveryChannelException(message, e, this.channel);
    }

    @Override
    public void handleFilterException(ProcessingContext<T> message, Exception e) {
        this.handleFilterExceptionUngenerified(message, e);
    }

    private void handleFilterExceptionUngenerified(ProcessingContext message, Exception e) {
        this.messageBusExceptionHandler.handleFilterException(message, e, this.channel);
    }

    @Override
    public void handleBubbledUpException(BubbleUpWrappedException e) {
        throw e;
    }

    private DelegatingChannelExceptionHandler(MessageBusExceptionHandler messageBusExceptionHandler, DeliveryAbortDecision<T> deliveryAbortDecision) {
        this.messageBusExceptionHandler = messageBusExceptionHandler;
        this.deliveryAbortDecision = deliveryAbortDecision;
    }

    public void setChannel(Channel<Object> channel) {
        this.channel = channel;
    }

    private static interface DeliveryAbortDecision<T> {
        public boolean shouldSubscriberErrorBeHandledAndDeliveryAborted(ProcessingContext<T> var1, Exception var2, Channel<?> var3);
    }
}

