/*
 * Decompiled with CFR 0.152.
 */
package de.quantummaid.eventmaid.messageBus.internal.statistics;

import de.quantummaid.eventmaid.channel.Channel;
import de.quantummaid.eventmaid.channel.ChannelStatusInformation;
import de.quantummaid.eventmaid.channel.statistics.ChannelStatistics;
import de.quantummaid.eventmaid.messageBus.internal.statistics.MessageBusStatisticsCollector;
import de.quantummaid.eventmaid.messageBus.statistics.MessageBusStatistics;
import java.math.BigInteger;
import java.util.Date;

public final class ChannelBasedMessageBusStatisticsCollector
implements MessageBusStatisticsCollector {
    private final Channel<?> channel;

    public static ChannelBasedMessageBusStatisticsCollector channelBasedMessageBusStatisticsCollector(Channel<?> channel) {
        return new ChannelBasedMessageBusStatisticsCollector(channel);
    }

    @Override
    public MessageBusStatistics getStatistics() {
        ChannelStatusInformation statusInformation = this.channel.getStatusInformation();
        ChannelStatistics channelStatistics = statusInformation.getChannelStatistics();
        MessageBusStatistics messageBusStatistics = this.getMessageBusStatistics(channelStatistics);
        return messageBusStatistics;
    }

    private MessageBusStatistics getMessageBusStatistics(ChannelStatistics channelStatistics) {
        Date timestamp = channelStatistics.getTimestamp();
        BigInteger acceptedMessages = channelStatistics.getAcceptedMessages();
        BigInteger successfulMessages = channelStatistics.getSuccessfulMessages();
        BigInteger failedMessages = channelStatistics.getFailedMessages();
        BigInteger blockedMessages = channelStatistics.getBlockedMessages();
        BigInteger forgottenMessages = channelStatistics.getForgottenMessages();
        BigInteger queuedMessages = channelStatistics.getQueuedMessages();
        return MessageBusStatistics.messageBusStatistics(timestamp, acceptedMessages, successfulMessages, failedMessages, blockedMessages, forgottenMessages, queuedMessages);
    }

    private ChannelBasedMessageBusStatisticsCollector(Channel<?> channel) {
        this.channel = channel;
    }
}

