/*
 * Decompiled with CFR 0.152.
 */
package de.quantummaid.httpmaid.chains;

import de.quantummaid.httpmaid.chains.MetaData;
import de.quantummaid.httpmaid.chains.RunId;
import de.quantummaid.httpmaid.util.Validators;
import java.util.function.Consumer;

final class ProcessingContext {
    private final RunId runId;
    private final MetaData metaData;
    private final Consumer<MetaData> consumer;

    static ProcessingContext processingContext(MetaData metaData, Consumer<MetaData> consumer) {
        Validators.validateNotNull(metaData, "metaData");
        Validators.validateNotNull(consumer, "consumer");
        RunId runId = RunId.randomRunId();
        return new ProcessingContext(runId, metaData, consumer);
    }

    MetaData metaData() {
        return this.metaData;
    }

    void consume() {
        this.consumer.accept(this.metaData);
    }

    RunId runId() {
        return this.runId;
    }

    public String toString() {
        return "ProcessingContext(runId=" + this.runId + ", metaData=" + this.metaData + ", consumer=" + this.consumer + ")";
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ProcessingContext)) {
            return false;
        }
        ProcessingContext other = (ProcessingContext)o;
        RunId this$runId = this.runId;
        RunId other$runId = other.runId;
        if (this$runId == null ? other$runId != null : !((Object)this$runId).equals(other$runId)) {
            return false;
        }
        MetaData this$metaData = this.metaData;
        MetaData other$metaData = other.metaData;
        if (this$metaData == null ? other$metaData != null : !((Object)this$metaData).equals(other$metaData)) {
            return false;
        }
        Consumer<MetaData> this$consumer = this.consumer;
        Consumer<MetaData> other$consumer = other.consumer;
        return !(this$consumer == null ? other$consumer != null : !this$consumer.equals(other$consumer));
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        RunId $runId = this.runId;
        result = result * 59 + ($runId == null ? 43 : ((Object)$runId).hashCode());
        MetaData $metaData = this.metaData;
        result = result * 59 + ($metaData == null ? 43 : ((Object)$metaData).hashCode());
        Consumer<MetaData> $consumer = this.consumer;
        result = result * 59 + ($consumer == null ? 43 : $consumer.hashCode());
        return result;
    }

    private ProcessingContext(RunId runId, MetaData metaData, Consumer<MetaData> consumer) {
        this.runId = runId;
        this.metaData = metaData;
        this.consumer = consumer;
    }
}

