/*
 * Decompiled with CFR 0.152.
 */
package de.quantummaid.httpmaid.handler.http.files;

import de.quantummaid.httpmaid.handler.http.files.MultiformatPath;
import de.quantummaid.httpmaid.util.Validators;

public final class FileDoesNotExistException
extends RuntimeException {
    private FileDoesNotExistException(String message, Throwable cause) {
        super(message, cause);
    }

    private static FileDoesNotExistException fileDoesNotExistException(String path, String type, Throwable cause) {
        Validators.validateNotNull(path, "path");
        String message = String.format("Could not find %s at %s", type, path);
        return new FileDoesNotExistException(message, cause);
    }

    static FileDoesNotExistException javaResourceDoesNotExistException(MultiformatPath path, Throwable cause) {
        Validators.validateNotNull(path, "path");
        String formatted = path.formatted("", "");
        return FileDoesNotExistException.fileDoesNotExistException(formatted, "java resource", cause);
    }

    static FileDoesNotExistException javaResourceDoesNotExistException(MultiformatPath path) {
        return FileDoesNotExistException.javaResourceDoesNotExistException(path, null);
    }

    static FileDoesNotExistException filesystemFileDoesNotExistException(String path, Throwable cause) {
        return FileDoesNotExistException.fileDoesNotExistException(path, "file", cause);
    }
}

