/*
 * Decompiled with CFR 0.152.
 */
package de.quantummaid.httpmaid.mapmaid.advancedscanner;

import de.quantummaid.httpmaid.mapmaid.advancedscanner.VirtualDeserializer;
import de.quantummaid.httpmaid.usecases.method.UseCaseMethod;
import de.quantummaid.mapmaid.builder.GenericType;
import de.quantummaid.mapmaid.builder.MapMaidBuilder;
import de.quantummaid.mapmaid.builder.RequiredCapabilities;
import de.quantummaid.mapmaid.builder.customtypes.DeserializationOnlyType;
import de.quantummaid.mapmaid.builder.recipes.advancedscanner.deserialization_wrappers.MethodParameterDeserializationWrapper;
import de.quantummaid.mapmaid.builder.recipes.advancedscanner.deserialization_wrappers.MultipleParametersDeserializationWrapper;
import de.quantummaid.mapmaid.mapper.deserialization.deserializers.TypeDeserializer;
import de.quantummaid.mapmaid.mapper.deserialization.deserializers.serializedobjects.SerializedObjectDeserializer;
import de.quantummaid.mapmaid.shared.identifier.TypeIdentifier;
import de.quantummaid.mapmaid.shared.identifier.VirtualTypeIdentifier;
import de.quantummaid.mapmaid.shared.types.ResolvedType;
import de.quantummaid.mapmaid.shared.validators.NotNullValidator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public final class UseCaseClassScanner {
    private UseCaseClassScanner() {
    }

    public static Map<Class<?>, MethodParameterDeserializationWrapper> addAllReferencedClassesIn(List<UseCaseMethod> useCaseMethods, MapMaidBuilder builder) {
        NotNullValidator.validateNotNull(useCaseMethods, "useCaseMethods");
        NotNullValidator.validateNotNull(builder, "builder");
        HashMap deserializationWrappers = new HashMap(useCaseMethods.size());
        useCaseMethods.forEach(useCaseMethod -> {
            MethodParameterDeserializationWrapper deserializationWrapper = UseCaseClassScanner.addMethod(useCaseMethod, builder);
            deserializationWrappers.put(useCaseMethod.useCaseClass(), deserializationWrapper);
        });
        return deserializationWrappers;
    }

    private static MethodParameterDeserializationWrapper addMethod(UseCaseMethod method, MapMaidBuilder builder) {
        Map<String, Class<?>> parameters = method.parameters();
        parameters.values().stream().map(ResolvedType::resolvedType).map(GenericType::fromResolvedType).forEach(type -> builder.withType((GenericType<?>)type, RequiredCapabilities.deserialization(), String.format("because parameter type of method %s", method.describe())));
        method.returnType().ifPresent(type -> {
            GenericType genericType = GenericType.genericType(type);
            builder.withType(genericType, RequiredCapabilities.serialization(), String.format("because return type of method %s", method.describe()));
        });
        DeserializationOnlyType<?> virtualType = UseCaseClassScanner.createVirtualObjectFor(method.describe(), parameters);
        builder.deserializing(virtualType);
        return MultipleParametersDeserializationWrapper.multipleParamters(virtualType.type());
    }

    private static DeserializationOnlyType<?> createVirtualObjectFor(String method, Map<String, Class<?>> parameters) {
        TypeIdentifier typeIdentifier = VirtualTypeIdentifier.uniqueVirtualTypeIdentifier();
        SerializedObjectDeserializer deserializer = VirtualDeserializer.virtualDeserializerFor(method, parameters);
        return DeserializationOnlyType.deserializationOnlyType(typeIdentifier, (TypeDeserializer)deserializer);
    }
}

