/*
 * Decompiled with CFR 0.152.
 */
package de.quantummaid.httpmaid.path;

import de.quantummaid.httpmaid.util.Validators;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Arrays;

final class PathResolver {
    private PathResolver() {
    }

    static String resolvePath(String base, String userProvidedAppendix) {
        Validators.validateNotNull(base, "base");
        Validators.validateNotNull(userProvidedAppendix, "userProvidedAppendix");
        String absoluteBase = PathResolver.makeAbsolute(base);
        Path basePath = Paths.get(absoluteBase, new String[0]);
        String relativeUserProvidedAppendix = PathResolver.makeRelative(userProvidedAppendix);
        Path userProvidedAppendixPath = Paths.get(relativeUserProvidedAppendix, new String[0]);
        Path resolvedPath = basePath.resolve(userProvidedAppendixPath).normalize();
        PathResolver.validateAbsolutePath(resolvedPath);
        if (!resolvedPath.startsWith(basePath)) {
            throw new IllegalArgumentException("User path escapes the base path");
        }
        return resolvedPath.toString();
    }

    private static String makeRelative(String path) {
        if (!path.startsWith("/")) {
            return path;
        }
        String withoutFirst = path.substring(1);
        return PathResolver.makeRelative(withoutFirst);
    }

    private static String makeAbsolute(String path) {
        if (path.startsWith("/")) {
            return path;
        }
        return "/" + path;
    }

    private static void validateAbsolutePath(Path path) {
        Validators.validateNotNull(path, "path");
        String pathString = path.toString();
        String[] elements = pathString.split("/");
        Arrays.stream(elements).forEach(element -> {
            if ("..".equals(element)) {
                throw new RuntimeException(String.format("path '%s' is not absolute", pathString));
            }
            if (".".equals(element)) {
                throw new RuntimeException(String.format("path '%s' is not absolute", pathString));
            }
        });
    }
}

