/*
 * Decompiled with CFR 0.152.
 */
package de.quantummaid.httpmaid.path.statemachine;

import de.quantummaid.httpmaid.path.statemachine.State;
import de.quantummaid.httpmaid.path.statemachine.StateMachine;
import de.quantummaid.httpmaid.path.statemachine.Transition;
import de.quantummaid.httpmaid.path.statemachine.TransitionFunction;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;

public final class StateMachineBuilder<T> {
    private int stateNumber;
    private State initialState;
    private final List<State> finalState;
    private final Map<State, List<Transition<T>>> transitions;

    public static <T> StateMachineBuilder<T> stateMachineBuilder() {
        return new StateMachineBuilder<T>(0, null, new LinkedList<State>(), new HashMap<State, List<Transition<T>>>());
    }

    public State createState() {
        State state = State.aState(this.stateNumber);
        ++this.stateNumber;
        if (this.initialState == null) {
            this.initialState = state;
        }
        return state;
    }

    public void addTransition(State state, Transition<T> transition) {
        List transitionsForState = this.transitions.computeIfAbsent(state, s2 -> new LinkedList());
        transitionsForState.add(transition);
    }

    public void markAsFinal(State state) {
        this.finalState.add(state);
    }

    public StateMachine<T> build() {
        TransitionFunction<T> transitionFunction = TransitionFunction.transitionFunction(this.transitions);
        return StateMachine.stateMachine(this.initialState, transitionFunction, this.finalState);
    }

    public String toString() {
        return "StateMachineBuilder(stateNumber=" + this.stateNumber + ", initialState=" + this.initialState + ", finalState=" + this.finalState + ", transitions=" + this.transitions + ")";
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof StateMachineBuilder)) {
            return false;
        }
        StateMachineBuilder other = (StateMachineBuilder)o;
        if (this.stateNumber != other.stateNumber) {
            return false;
        }
        State this$initialState = this.initialState;
        State other$initialState = other.initialState;
        if (this$initialState == null ? other$initialState != null : !((Object)this$initialState).equals(other$initialState)) {
            return false;
        }
        List<State> this$finalState = this.finalState;
        List<State> other$finalState = other.finalState;
        if (this$finalState == null ? other$finalState != null : !((Object)this$finalState).equals(other$finalState)) {
            return false;
        }
        Map<State, List<Transition<T>>> this$transitions = this.transitions;
        Map<State, List<Transition<T>>> other$transitions = other.transitions;
        return !(this$transitions == null ? other$transitions != null : !((Object)this$transitions).equals(other$transitions));
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + this.stateNumber;
        State $initialState = this.initialState;
        result = result * 59 + ($initialState == null ? 43 : ((Object)$initialState).hashCode());
        List<State> $finalState = this.finalState;
        result = result * 59 + ($finalState == null ? 43 : ((Object)$finalState).hashCode());
        Map<State, List<Transition<T>>> $transitions = this.transitions;
        result = result * 59 + ($transitions == null ? 43 : ((Object)$transitions).hashCode());
        return result;
    }

    private StateMachineBuilder(int stateNumber, State initialState, List<State> finalState, Map<State, List<Transition<T>>> transitions) {
        this.stateNumber = stateNumber;
        this.initialState = initialState;
        this.finalState = finalState;
        this.transitions = transitions;
    }
}

