/*
 * Decompiled with CFR 0.152.
 */
package de.quantummaid.httpmaid.security.basicauth;

import de.quantummaid.httpmaid.handler.http.HttpRequest;
import de.quantummaid.httpmaid.security.authentication.Authenticator;
import de.quantummaid.httpmaid.security.authorization.AuthorizationHeader;
import de.quantummaid.httpmaid.security.basicauth.Base64Decoder;
import java.util.Optional;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public interface BasicAuthAuthenticator
extends Authenticator<HttpRequest> {
    public static final Pattern PATTERN = Pattern.compile("(?<username>[^:]+):(?<password>.*)");

    @Override
    default public Optional<?> authenticate(HttpRequest request) {
        return request.headers().getOptionalHeader("Authorization").flatMap(AuthorizationHeader::parse).filter(authorizationHeader -> authorizationHeader.type().equals("Basic")).map(AuthorizationHeader::credentials).map(Base64Decoder::decodeBase64).map(PATTERN::matcher).filter(Matcher::matches).flatMap(matcher -> {
            String password;
            String username = matcher.group("username");
            if (this.isAuthenticated(username, password = matcher.group("password"))) {
                return Optional.of(username);
            }
            return Optional.empty();
        });
    }

    public boolean isAuthenticated(String var1, String var2);
}

