/*
 * Decompiled with CFR 0.152.
 */
package de.quantummaid.httpmaid.usecases;

import de.quantummaid.eventmaid.internal.collections.filtermap.FilterMapBuilder;
import de.quantummaid.eventmaid.internal.collections.predicatemap.PredicateMapBuilder;
import de.quantummaid.eventmaid.mapping.Demapifier;
import de.quantummaid.eventmaid.mapping.ExceptionMapifier;
import de.quantummaid.eventmaid.mapping.Mapifier;
import de.quantummaid.eventmaid.messageBus.MessageBus;
import de.quantummaid.eventmaid.processingContext.EventType;
import de.quantummaid.eventmaid.serializedMessageBus.SerializedMessageBus;
import de.quantummaid.eventmaid.useCases.useCaseAdapter.LowLevelUseCaseAdapterBuilder;
import de.quantummaid.eventmaid.useCases.useCaseAdapter.UseCaseAdapter;
import de.quantummaid.httpmaid.chains.ChainExtender;
import de.quantummaid.httpmaid.chains.ChainModule;
import de.quantummaid.httpmaid.chains.DependencyRegistry;
import de.quantummaid.httpmaid.chains.MetaData;
import de.quantummaid.httpmaid.chains.MetaDataKey;
import de.quantummaid.httpmaid.events.EventFactory;
import de.quantummaid.httpmaid.events.EventModule;
import de.quantummaid.httpmaid.handler.distribution.DistributableHandler;
import de.quantummaid.httpmaid.handler.distribution.HandlerDistributors;
import de.quantummaid.httpmaid.startupchecks.StartupChecks;
import de.quantummaid.httpmaid.usecases.eventfactories.MultipleParametersEventFactory;
import de.quantummaid.httpmaid.usecases.eventfactories.SingleParameterEventFactory;
import de.quantummaid.httpmaid.usecases.instantiation.UseCaseInstantiator;
import de.quantummaid.httpmaid.usecases.instantiation.ZeroArgumentsConstructorUseCaseInstantiator;
import de.quantummaid.httpmaid.usecases.method.UseCaseMethod;
import de.quantummaid.httpmaid.usecases.serializing.SerializationAndDeserializationProvider;
import de.quantummaid.httpmaid.usecases.serializing.UseCaseSerializationAndDeserialization;
import de.quantummaid.httpmaid.util.Validators;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;

public final class UseCasesModule
implements ChainModule {
    public static final MetaDataKey<SerializedMessageBus> SERIALIZED_MESSAGE_BUS = MetaDataKey.metaDataKey("SERIALIZED_MESSAGE_BUS");
    private SerializationAndDeserializationProvider serializationAndDeserializationProvider;
    private UseCaseInstantiator useCaseInstantiator = ZeroArgumentsConstructorUseCaseInstantiator.zeroArgumentsConstructorUseCaseInstantiator();
    private final Map<Class<?>, EventType> useCaseToEventMappings = new HashMap();
    private final List<UseCaseMethod> useCaseMethods = new ArrayList<UseCaseMethod>();

    public static UseCasesModule useCasesModule() {
        return new UseCasesModule();
    }

    public void setUseCaseInstantiator(UseCaseInstantiator useCaseInstantiator) {
        this.useCaseInstantiator = useCaseInstantiator;
    }

    public void addUseCaseToEventMapping(Class<?> useCaseClass, EventType eventType) {
        Validators.validateNotNull(useCaseClass, "useCaseClass");
        Validators.validateNotNull(eventType, "eventType");
        this.useCaseToEventMappings.put(useCaseClass, eventType);
    }

    public void setSerializationAndDeserializationProvider(SerializationAndDeserializationProvider serializationAndDeserializationProvider) {
        this.serializationAndDeserializationProvider = serializationAndDeserializationProvider;
    }

    @Override
    public List<ChainModule> supplyModulesIfNotAlreadyPresent() {
        return Collections.singletonList(EventModule.eventModule());
    }

    @Override
    public void init(MetaData configurationMetaData) {
        HandlerDistributors handlerDistributors = configurationMetaData.get(HandlerDistributors.HANDLER_DISTRIBUTORS);
        handlerDistributors.register(handler -> handler.handler() instanceof Class, handler -> {
            Class useCaseClass = (Class)handler.handler();
            EventType eventType = EventType.eventTypeFromClass(useCaseClass);
            this.useCaseToEventMappings.put(useCaseClass, eventType);
            this.useCaseMethods.add(UseCaseMethod.useCaseMethodOf(useCaseClass));
            DistributableHandler eventHandler = DistributableHandler.distributableHandler(handler.condition(), eventType, handler.perRouteConfigurators());
            return Collections.singletonList(eventHandler);
        });
    }

    @Override
    public void configure(DependencyRegistry dependencyRegistry) {
        EventModule eventModule = dependencyRegistry.getDependency(EventModule.class);
        this.useCaseMethods.forEach(useCaseMethod -> {
            Class<?> useCaseClass = useCaseMethod.useCaseClass();
            EventType eventType = this.useCaseToEventMappings.get(useCaseClass);
            EventFactory eventFactory = UseCasesModule.buildEventFactory(useCaseMethod);
            eventModule.setEventFactoryFor(eventType, eventFactory);
        });
    }

    @Override
    public void register(ChainExtender extender) {
        LowLevelUseCaseAdapterBuilder lowLevelUseCaseAdapterBuilder = LowLevelUseCaseAdapterBuilder.aLowLevelUseCaseInvocationBuilder();
        UseCaseSerializationAndDeserialization serializationAndDeserialization = this.serializationAndDeserializationProvider.provide(this.useCaseMethods);
        StartupChecks startupChecks = extender.getMetaDatum(StartupChecks.STARTUP_CHECKS);
        this.useCaseMethods.forEach(useCaseMethod -> {
            Class<?> useCaseClass = useCaseMethod.useCaseClass();
            EventType eventType = this.useCaseToEventMappings.get(useCaseClass);
            lowLevelUseCaseAdapterBuilder.addUseCase(useCaseClass, eventType, (useCase, event, callingContext) -> {
                Map<String, Object> parameters = serializationAndDeserialization.deserializeParameters(event, useCaseClass);
                Optional<Object> returnValue = useCaseMethod.invoke(useCase, parameters, event);
                return returnValue.map(serializationAndDeserialization::serializeReturnValue).orElse(null);
            });
            startupChecks.addStartupCheck(() -> this.useCaseInstantiator.check(useCaseClass));
        });
        lowLevelUseCaseAdapterBuilder.setUseCaseInstantiator(this.useCaseInstantiator::instantiate);
        lowLevelUseCaseAdapterBuilder.setRequestSerializers(UseCasesModule.failingPredicateMap());
        lowLevelUseCaseAdapterBuilder.setRequestDeserializers(UseCasesModule.failingFilterMap());
        lowLevelUseCaseAdapterBuilder.setReseponseSerializers(UseCasesModule.failingPredicateMap());
        lowLevelUseCaseAdapterBuilder.setResponseDeserializers(UseCasesModule.failingFilterMap());
        PredicateMapBuilder<Exception, Mapifier<Exception>> exceptionSerializers = PredicateMapBuilder.predicateMapBuilder();
        exceptionSerializers.setDefaultValue(ExceptionMapifier.defaultExceptionMapifier());
        lowLevelUseCaseAdapterBuilder.setExceptionSerializers(exceptionSerializers);
        UseCaseAdapter useCaseAdapter = lowLevelUseCaseAdapterBuilder.build();
        MessageBus messageBus = extender.getMetaDatum(EventModule.MESSAGE_BUS);
        SerializedMessageBus serializedMessageBus = useCaseAdapter.attachAndEnhance(messageBus);
        extender.addMetaDatum(SERIALIZED_MESSAGE_BUS, serializedMessageBus);
    }

    private static FilterMapBuilder<Class<?>, Object, Demapifier<?>> failingFilterMap() {
        FilterMapBuilder<Class<?>, Object, Demapifier<?>> filterMap = FilterMapBuilder.filterMapBuilder();
        filterMap.setDefaultValue((targetType, map) -> {
            throw new UnsupportedOperationException();
        });
        return filterMap;
    }

    private static PredicateMapBuilder<Object, Mapifier<Object>> failingPredicateMap() {
        PredicateMapBuilder<Object, Mapifier<Object>> predicateMap = PredicateMapBuilder.predicateMapBuilder();
        predicateMap.setDefaultValue(object -> {
            throw new UnsupportedOperationException();
        });
        return predicateMap;
    }

    private static EventFactory buildEventFactory(UseCaseMethod useCaseMethod) {
        if (useCaseMethod.isSingleParameterUseCase()) {
            String name = useCaseMethod.singleParameterName();
            return SingleParameterEventFactory.singleParameterEventFactory(name);
        }
        List<String> parameterNames = useCaseMethod.parameterNames();
        return MultipleParametersEventFactory.multipleParametersEventFactory(parameterNames);
    }

    public String toString() {
        return "UseCasesModule(serializationAndDeserializationProvider=" + this.serializationAndDeserializationProvider + ", useCaseInstantiator=" + this.useCaseInstantiator + ", useCaseToEventMappings=" + this.useCaseToEventMappings + ", useCaseMethods=" + this.useCaseMethods + ")";
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof UseCasesModule)) {
            return false;
        }
        UseCasesModule other = (UseCasesModule)o;
        SerializationAndDeserializationProvider this$serializationAndDeserializationProvider = this.serializationAndDeserializationProvider;
        SerializationAndDeserializationProvider other$serializationAndDeserializationProvider = other.serializationAndDeserializationProvider;
        if (this$serializationAndDeserializationProvider == null ? other$serializationAndDeserializationProvider != null : !this$serializationAndDeserializationProvider.equals(other$serializationAndDeserializationProvider)) {
            return false;
        }
        UseCaseInstantiator this$useCaseInstantiator = this.useCaseInstantiator;
        UseCaseInstantiator other$useCaseInstantiator = other.useCaseInstantiator;
        if (this$useCaseInstantiator == null ? other$useCaseInstantiator != null : !this$useCaseInstantiator.equals(other$useCaseInstantiator)) {
            return false;
        }
        Map<Class<?>, EventType> this$useCaseToEventMappings = this.useCaseToEventMappings;
        Map<Class<?>, EventType> other$useCaseToEventMappings = other.useCaseToEventMappings;
        if (this$useCaseToEventMappings == null ? other$useCaseToEventMappings != null : !((Object)this$useCaseToEventMappings).equals(other$useCaseToEventMappings)) {
            return false;
        }
        List<UseCaseMethod> this$useCaseMethods = this.useCaseMethods;
        List<UseCaseMethod> other$useCaseMethods = other.useCaseMethods;
        return !(this$useCaseMethods == null ? other$useCaseMethods != null : !((Object)this$useCaseMethods).equals(other$useCaseMethods));
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        SerializationAndDeserializationProvider $serializationAndDeserializationProvider = this.serializationAndDeserializationProvider;
        result = result * 59 + ($serializationAndDeserializationProvider == null ? 43 : $serializationAndDeserializationProvider.hashCode());
        UseCaseInstantiator $useCaseInstantiator = this.useCaseInstantiator;
        result = result * 59 + ($useCaseInstantiator == null ? 43 : $useCaseInstantiator.hashCode());
        Map<Class<?>, EventType> $useCaseToEventMappings = this.useCaseToEventMappings;
        result = result * 59 + ($useCaseToEventMappings == null ? 43 : ((Object)$useCaseToEventMappings).hashCode());
        List<UseCaseMethod> $useCaseMethods = this.useCaseMethods;
        result = result * 59 + ($useCaseMethods == null ? 43 : ((Object)$useCaseMethods).hashCode());
        return result;
    }

    private UseCasesModule() {
    }
}

