/*
 * Decompiled with CFR 0.152.
 */
package de.quantummaid.httpmaid.usecases.eventfactories;

import de.quantummaid.httpmaid.events.EventFactory;
import de.quantummaid.httpmaid.events.enriching.EnrichableMap;
import de.quantummaid.httpmaid.util.Validators;
import java.util.Collections;
import java.util.List;

public final class SingleParameterEventFactory
implements EventFactory {
    private final String name;

    public static EventFactory singleParameterEventFactory(String name) {
        Validators.validateNotNullNorEmpty(name, "name");
        return new SingleParameterEventFactory(name);
    }

    @Override
    public EnrichableMap createEvent(Object unmarshalledBody) {
        List<String> names = Collections.singletonList(this.name);
        EnrichableMap event = EnrichableMap.enrichableMap(names);
        if (unmarshalledBody != null) {
            event.overwriteTopLevel(this.name, unmarshalledBody);
        }
        return event;
    }

    public String toString() {
        return "SingleParameterEventFactory(name=" + this.name + ")";
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof SingleParameterEventFactory)) {
            return false;
        }
        SingleParameterEventFactory other = (SingleParameterEventFactory)o;
        String this$name = this.name;
        String other$name = other.name;
        return !(this$name == null ? other$name != null : !this$name.equals(other$name));
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $name = this.name;
        result = result * 59 + ($name == null ? 43 : $name.hashCode());
        return result;
    }

    private SingleParameterEventFactory(String name) {
        this.name = name;
    }
}

