/*
 * Decompiled with CFR 0.152.
 */
package de.quantummaid.httpmaid.usecases.instantiation;

import de.quantummaid.httpmaid.usecases.instantiation.ZeroArgumentsConstructorUseCaseInstantiatorException;
import java.lang.reflect.Constructor;
import java.lang.reflect.Modifier;

public final class InstantiationInformation {
    private final Constructor<?> constructor;

    public static InstantiationInformation instantiationInformationFor(Class<?> type) {
        InstantiationInformation.validateNotInterface(type);
        InstantiationInformation.validateNotAbstractClass(type);
        Constructor<?> constructor = InstantiationInformation.extractZeroArgumentsConstructor(type);
        return new InstantiationInformation(constructor);
    }

    public Constructor<?> constructor() {
        return this.constructor;
    }

    private static Constructor<?> extractZeroArgumentsConstructor(Class<?> type) {
        try {
            return type.getDeclaredConstructor(new Class[0]);
        }
        catch (NoSuchMethodException e) {
            throw ZeroArgumentsConstructorUseCaseInstantiatorException.zeroArgumentsConstructorUseCaseInstantiatorException(type, e);
        }
    }

    private static void validateNotInterface(Class<?> type) {
        if (type.isInterface()) {
            throw ZeroArgumentsConstructorUseCaseInstantiatorException.zeroArgumentsConstructorUseCaseInstantiatorException(type, "must not be an interface");
        }
    }

    private static void validateNotAbstractClass(Class<?> type) {
        if (Modifier.isAbstract(type.getModifiers())) {
            throw ZeroArgumentsConstructorUseCaseInstantiatorException.zeroArgumentsConstructorUseCaseInstantiatorException(type, "must not be an abstract class");
        }
    }

    public String toString() {
        return "InstantiationInformation(constructor=" + this.constructor + ")";
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof InstantiationInformation)) {
            return false;
        }
        InstantiationInformation other = (InstantiationInformation)o;
        Constructor<?> this$constructor = this.constructor;
        Constructor<?> other$constructor = other.constructor;
        return !(this$constructor == null ? other$constructor != null : !((Object)this$constructor).equals(other$constructor));
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Constructor<?> $constructor = this.constructor;
        result = result * 59 + ($constructor == null ? 43 : ((Object)$constructor).hashCode());
        return result;
    }

    private InstantiationInformation(Constructor<?> constructor) {
        this.constructor = constructor;
    }
}

