/*
 * Decompiled with CFR 0.152.
 */
package de.quantummaid.httpmaid.usecases.method;

import java.lang.reflect.Method;
import java.lang.reflect.Parameter;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

public final class Parameters {
    private final List<Parameter> parameters;

    public static Parameters parametersOf(Method method) {
        List<Parameter> parameters = Arrays.asList(method.getParameters());
        return new Parameters(parameters);
    }

    public List<String> names() {
        return this.parameters.stream().map(Parameter::getName).collect(Collectors.toList());
    }

    public Map<String, Class<?>> asMap() {
        return this.parameters.stream().collect(Collectors.toMap(Parameter::getName, Parameter::getType));
    }

    public Object[] toArray(Map<String, Object> parameterInstances) {
        return this.parameters.stream().map(Parameter::getName).map(parameterInstances::get).toArray();
    }

    public String toString() {
        return "Parameters(parameters=" + this.parameters + ")";
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Parameters)) {
            return false;
        }
        Parameters other = (Parameters)o;
        List<Parameter> this$parameters = this.parameters;
        List<Parameter> other$parameters = other.parameters;
        return !(this$parameters == null ? other$parameters != null : !((Object)this$parameters).equals(other$parameters));
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        List<Parameter> $parameters = this.parameters;
        result = result * 59 + ($parameters == null ? 43 : ((Object)$parameters).hashCode());
        return result;
    }

    private Parameters(List<Parameter> parameters) {
        this.parameters = parameters;
    }
}

