/*
 * Decompiled with CFR 0.152.
 */
package de.quantummaid.httpmaid.usecases.method;

import de.quantummaid.eventmaid.internal.reflections.ForbiddenUseCaseMethods;
import de.quantummaid.eventmaid.useCases.useCaseAdapter.methodInvoking.MethodInvocationException;
import de.quantummaid.httpmaid.usecases.method.Parameters;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;

public final class UseCaseMethod {
    private final Class<?> useCaseClass;
    private final Method method;
    private final Parameters parameters;
    private final Class<?> returnType;

    public static UseCaseMethod useCaseMethodOf(Class<?> useCase) throws IllegalArgumentException {
        UseCaseMethod.validateUseCaseClass(useCase);
        Method method = UseCaseMethod.locateUseCaseMethod(useCase);
        if (method.getTypeParameters().length != 0) {
            throw new IllegalArgumentException(String.format("use case method '%s' in class '%s' must not declare any type variables", method.getName(), useCase.getName()));
        }
        Parameters parameters = Parameters.parametersOf(method);
        Class<?> returnType = method.getReturnType() == Void.TYPE ? null : method.getReturnType();
        return new UseCaseMethod(useCase, method, parameters, returnType);
    }

    public Class<?> useCaseClass() {
        return this.useCaseClass;
    }

    public boolean isSingleParameterUseCase() {
        return this.parameters.asMap().size() == 1;
    }

    public String singleParameterName() {
        return this.parameterNames().get(0);
    }

    public List<String> parameterNames() {
        return this.parameters.names();
    }

    public Map<String, Class<?>> parameters() {
        return this.parameters.asMap();
    }

    public Optional<Class<?>> returnType() {
        return Optional.ofNullable(this.returnType);
    }

    public String describe() {
        return this.method.getName();
    }

    public Optional<Object> invoke(Object useCase, Map<String, Object> parameters, Object event) throws Exception {
        Object[] parameterInstances = this.parameters.toArray(parameters);
        try {
            Object returnValue = this.method.invoke(useCase, parameterInstances);
            return Optional.ofNullable(returnValue);
        }
        catch (IllegalAccessException e) {
            Class<?> useCaseClass = useCase.getClass();
            throw MethodInvocationException.methodInvocationException(useCaseClass, useCase, this.method, event, e);
        }
        catch (InvocationTargetException e) {
            Throwable cause = e.getCause();
            if (cause instanceof RuntimeException) {
                throw (RuntimeException)cause;
            }
            if (this.isDeclaredByMethod(cause, this.method)) {
                throw (Exception)cause;
            }
            Class<?> useCaseClass = useCase.getClass();
            throw MethodInvocationException.methodInvocationException(useCaseClass, useCase, this.method, event, e);
        }
    }

    private boolean isDeclaredByMethod(Throwable cause, Method method) {
        Class<?>[] exceptionTypes = method.getExceptionTypes();
        Class<?> exceptionClass = cause.getClass();
        return Arrays.asList(exceptionTypes).contains(exceptionClass);
    }

    private static Method locateUseCaseMethod(Class<?> useCaseClass) {
        List<Method> useCaseMethods = UseCaseMethod.getAllPublicMethods(useCaseClass, ForbiddenUseCaseMethods.NOT_ALLOWED_USECASE_PUBLIC_METHODS);
        if (useCaseMethods.size() == 1) {
            return useCaseMethods.get(0);
        }
        String message = String.format("use case classes must have exactly one public instance (non-static) method. Found the methods %s for class %s", useCaseMethods, useCaseClass);
        throw new IllegalArgumentException(message);
    }

    private static List<Method> getAllPublicMethods(Class<?> useCaseClass, Collection<String> excludedMethods) {
        Method[] methods = useCaseClass.getMethods();
        return Arrays.stream(methods).filter(method -> Modifier.isPublic(method.getModifiers())).filter(method -> !Modifier.isStatic(method.getModifiers())).filter(method -> !Modifier.isAbstract(method.getModifiers())).filter(method -> method.getDeclaringClass().equals(useCaseClass)).filter(method -> !excludedMethods.contains(method.getName())).collect(Collectors.toList());
    }

    private static void validateUseCaseClass(Class<?> useCase) {
        UseCaseMethod.validateNotAnonymousClass(useCase);
        UseCaseMethod.validateNotLocalClass(useCase);
        UseCaseMethod.validatePublicClass(useCase);
        UseCaseMethod.validateNotPrimitiveClass(useCase);
        UseCaseMethod.validateNotArrayClass(useCase);
        UseCaseMethod.validateNotAnnotationClass(useCase);
        UseCaseMethod.validateNotEnumClass(useCase);
        UseCaseMethod.validateNotInnerClass(useCase);
        UseCaseMethod.validateNoClassScopedTypeVariables(useCase);
    }

    private static void validateNotAnonymousClass(Class<?> useCase) {
        if (useCase.isAnonymousClass()) {
            throw new IllegalArgumentException(String.format("use case must not be an anonymous class but got '%s'", useCase.getName()));
        }
    }

    private static void validateNotLocalClass(Class<?> useCase) {
        if (useCase.isLocalClass()) {
            throw new IllegalArgumentException(String.format("use case must not be a local class but got '%s'", useCase.getName()));
        }
    }

    private static void validatePublicClass(Class<?> useCase) {
        if (!Modifier.isPublic(useCase.getModifiers())) {
            throw new IllegalArgumentException(String.format("use case class must be public but got '%s'", useCase.getName()));
        }
    }

    private static void validateNotPrimitiveClass(Class<?> useCase) {
        if (useCase.isPrimitive()) {
            throw new IllegalArgumentException(String.format("use case must not be a primitive but got '%s'", useCase.getName()));
        }
    }

    private static void validateNotArrayClass(Class<?> useCase) {
        if (useCase.isArray()) {
            throw new IllegalArgumentException(String.format("use case must not be an array but got '%s'", useCase.getName()));
        }
    }

    private static void validateNotAnnotationClass(Class<?> useCase) {
        if (useCase.isAnnotation()) {
            throw new IllegalArgumentException(String.format("use case must not be an annotation but got '%s'", useCase.getName()));
        }
    }

    private static void validateNotEnumClass(Class<?> useCase) {
        if (useCase.isEnum()) {
            throw new IllegalArgumentException(String.format("use case must not be an enum but got '%s'", useCase.getName()));
        }
    }

    private static void validateNotInnerClass(Class<?> useCase) {
        if (useCase.getEnclosingClass() != null) {
            throw new IllegalArgumentException(String.format("use case must not be an inner class but got '%s'", useCase.getName()));
        }
    }

    private static void validateNoClassScopedTypeVariables(Class<?> useCase) {
        if (useCase.getTypeParameters().length != 0) {
            throw new IllegalArgumentException(String.format("use case class '%s' must not declare any type variables", useCase.getName()));
        }
    }

    public String toString() {
        return "UseCaseMethod(useCaseClass=" + this.useCaseClass + ", method=" + this.method + ", parameters=" + this.parameters + ", returnType=" + this.returnType + ")";
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof UseCaseMethod)) {
            return false;
        }
        UseCaseMethod other = (UseCaseMethod)o;
        Class<?> this$useCaseClass = this.useCaseClass;
        Class<?> other$useCaseClass = other.useCaseClass;
        if (this$useCaseClass == null ? other$useCaseClass != null : !this$useCaseClass.equals(other$useCaseClass)) {
            return false;
        }
        Method this$method = this.method;
        Method other$method = other.method;
        if (this$method == null ? other$method != null : !((Object)this$method).equals(other$method)) {
            return false;
        }
        Parameters this$parameters = this.parameters;
        Parameters other$parameters = other.parameters;
        if (this$parameters == null ? other$parameters != null : !((Object)this$parameters).equals(other$parameters)) {
            return false;
        }
        Class<?> this$returnType = this.returnType;
        Class<?> other$returnType = other.returnType;
        return !(this$returnType == null ? other$returnType != null : !this$returnType.equals(other$returnType));
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Class<?> $useCaseClass = this.useCaseClass;
        result = result * 59 + ($useCaseClass == null ? 43 : $useCaseClass.hashCode());
        Method $method = this.method;
        result = result * 59 + ($method == null ? 43 : ((Object)$method).hashCode());
        Parameters $parameters = this.parameters;
        result = result * 59 + ($parameters == null ? 43 : ((Object)$parameters).hashCode());
        Class<?> $returnType = this.returnType;
        result = result * 59 + ($returnType == null ? 43 : $returnType.hashCode());
        return result;
    }

    private UseCaseMethod(Class<?> useCaseClass, Method method, Parameters parameters, Class<?> returnType) {
        this.useCaseClass = useCaseClass;
        this.method = method;
        this.parameters = parameters;
        this.returnType = returnType;
    }
}

