/*
 * Decompiled with CFR 0.152.
 */
package de.quantummaid.mapmaid;

import de.quantummaid.mapmaid.builder.GenericType;
import de.quantummaid.mapmaid.builder.MapMaidBuilder;
import de.quantummaid.mapmaid.debug.DebugInformation;
import de.quantummaid.mapmaid.mapper.deserialization.Deserializer;
import de.quantummaid.mapmaid.mapper.marshalling.MarshallingType;
import de.quantummaid.mapmaid.mapper.serialization.Serializer;
import de.quantummaid.mapmaid.shared.types.ResolvedType;

public final class MapMaid {
    private final Serializer serializer;
    private final Deserializer deserializer;
    private final DebugInformation debugInformation;

    public static MapMaidBuilder aMapMaid() {
        return MapMaidBuilder.mapMaidBuilder();
    }

    public static MapMaid mapMaid(Serializer serializer, Deserializer deserializer, DebugInformation debugInformation) {
        return new MapMaid(serializer, deserializer, debugInformation);
    }

    public Serializer serializer() {
        return this.serializer;
    }

    public Deserializer deserializer() {
        return this.deserializer;
    }

    public String serializeToJson(Object object) {
        return this.serializer.serializeToJson(object);
    }

    public String serializeToYaml(Object object) {
        return this.serializer.serialize(object, MarshallingType.yaml());
    }

    public String serializeToXml(Object object) {
        return this.serializer.serialize(object, MarshallingType.xml());
    }

    public String serializeTo(Object object, MarshallingType marshallingType) {
        return this.serializer.serialize(object, marshallingType);
    }

    public String serializeTo(Object object, MarshallingType marshallingType, GenericType<?> type) {
        ResolvedType resolvedType = type.toResolvedType();
        return this.serializer.serialize(object, resolvedType, marshallingType, input -> input);
    }

    public <T> T deserializeJson(String json, Class<T> targetType) {
        return this.deserializer.deserializeJson(json, targetType);
    }

    public <T> T deserializeYaml(String yaml, Class<T> targetType) {
        return this.deserializer.deserialize(yaml, targetType, MarshallingType.yaml());
    }

    public <T> T deserializeXml(String xml, Class<T> targetType) {
        return this.deserializer.deserialize(xml, targetType, MarshallingType.xml());
    }

    public <T> T deserialize(String input, Class<T> targetType, MarshallingType marshallingType) {
        return this.deserializer.deserialize(input, targetType, marshallingType);
    }

    public <T> T deserialize(String input, ResolvedType targetType, MarshallingType marshallingType) {
        return this.deserializer.deserialize(input, targetType, marshallingType);
    }

    public DebugInformation debugInformation() {
        return this.debugInformation;
    }

    public String toString() {
        return "MapMaid(serializer=" + this.serializer + ", deserializer=" + this.deserializer + ", debugInformation=" + this.debugInformation + ")";
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof MapMaid)) {
            return false;
        }
        MapMaid other = (MapMaid)o;
        Serializer this$serializer = this.serializer;
        Serializer other$serializer = other.serializer;
        if (this$serializer == null ? other$serializer != null : !((Object)this$serializer).equals(other$serializer)) {
            return false;
        }
        Deserializer this$deserializer = this.deserializer;
        Deserializer other$deserializer = other.deserializer;
        if (this$deserializer == null ? other$deserializer != null : !((Object)this$deserializer).equals(other$deserializer)) {
            return false;
        }
        DebugInformation this$debugInformation = this.debugInformation;
        DebugInformation other$debugInformation = other.debugInformation;
        return !(this$debugInformation == null ? other$debugInformation != null : !((Object)this$debugInformation).equals(other$debugInformation));
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Serializer $serializer = this.serializer;
        result = result * 59 + ($serializer == null ? 43 : ((Object)$serializer).hashCode());
        Deserializer $deserializer = this.deserializer;
        result = result * 59 + ($deserializer == null ? 43 : ((Object)$deserializer).hashCode());
        DebugInformation $debugInformation = this.debugInformation;
        result = result * 59 + ($debugInformation == null ? 43 : ((Object)$debugInformation).hashCode());
        return result;
    }

    private MapMaid(Serializer serializer, Deserializer deserializer, DebugInformation debugInformation) {
        this.serializer = serializer;
        this.deserializer = deserializer;
        this.debugInformation = debugInformation;
    }
}

