/*
 * Decompiled with CFR 0.152.
 */
package de.quantummaid.mapmaid.builder;

import de.quantummaid.mapmaid.shared.types.ResolvedType;
import de.quantummaid.mapmaid.shared.types.unresolved.UnresolvedType;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;

public final class GenericType<T> {
    private final ResolvedType type;

    public static <T> GenericType<T> genericType(Class<T> type) {
        ResolvedType resolvedType = ResolvedType.resolvedType(type);
        return new GenericType<T>(resolvedType);
    }

    public static <T> GenericType<T> genericType(Class<T> type, Class<?> ... genericParameters) {
        GenericType[] genericParameterTypes = (GenericType[])Arrays.stream(genericParameters).map(GenericType::genericType).toArray(GenericType[]::new);
        return GenericType.genericType(type, genericParameterTypes);
    }

    public static <T> GenericType<T> genericType(Class<T> type, GenericType<?> ... genericParameters) {
        UnresolvedType unresolvedType = UnresolvedType.unresolvedType(type);
        List<ResolvedType> resolvedParameters = Arrays.stream(genericParameters).map(GenericType::toResolvedType).collect(Collectors.toList());
        ResolvedType resolvedType = unresolvedType.resolve(resolvedParameters);
        return new GenericType<T>(resolvedType);
    }

    public static <T> GenericType<T> fromResolvedType(ResolvedType type) {
        return new GenericType<T>(type);
    }

    public ResolvedType toResolvedType() {
        return this.type;
    }

    public String toString() {
        return "GenericType(type=" + this.type + ")";
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof GenericType)) {
            return false;
        }
        GenericType other = (GenericType)o;
        ResolvedType this$type = this.type;
        ResolvedType other$type = other.type;
        return !(this$type == null ? other$type != null : !this$type.equals(other$type));
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        ResolvedType $type = this.type;
        result = result * 59 + ($type == null ? 43 : $type.hashCode());
        return result;
    }

    private GenericType(ResolvedType type) {
        this.type = type;
    }
}

