/*
 * Decompiled with CFR 0.152.
 */
package de.quantummaid.mapmaid.builder.detection.customprimitive;

import de.quantummaid.mapmaid.builder.detection.DeserializerFactory;
import de.quantummaid.mapmaid.builder.detection.SerializerFactory;
import de.quantummaid.mapmaid.builder.detection.customprimitive.deserialization.CustomPrimitiveDeserializationDetector;
import de.quantummaid.mapmaid.builder.detection.customprimitive.serialization.CustomPrimitiveSerializationDetector;
import de.quantummaid.mapmaid.mapper.deserialization.deserializers.TypeDeserializer;
import de.quantummaid.mapmaid.shared.types.ResolvedType;
import de.quantummaid.mapmaid.shared.validators.NotNullValidator;
import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;

public final class CustomPrimitiveDefinitionFactory
implements SerializerFactory,
DeserializerFactory {
    private final List<CustomPrimitiveSerializationDetector> serializationDetectors;
    private final List<CustomPrimitiveDeserializationDetector> deserializationDetectors;

    public static CustomPrimitiveDefinitionFactory customPrimitiveFactory(List<CustomPrimitiveSerializationDetector> serializationDetectors, List<CustomPrimitiveDeserializationDetector> deserializationDetectors) {
        NotNullValidator.validateNotNull(serializationDetectors, "serializationDetectors");
        NotNullValidator.validateNotNull(deserializationDetectors, "deserializationDetectors");
        return new CustomPrimitiveDefinitionFactory(serializationDetectors, deserializationDetectors);
    }

    @Override
    public List<TypeDeserializer> analyseForDeserializer(ResolvedType type) {
        return this.deserializationDetectors.stream().map(detector -> detector.detect(type)).flatMap(Collection::stream).collect(Collectors.toList());
    }

    public String toString() {
        return "CustomPrimitiveDefinitionFactory(serializationDetectors=" + this.serializationDetectors + ", deserializationDetectors=" + this.deserializationDetectors + ")";
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof CustomPrimitiveDefinitionFactory)) {
            return false;
        }
        CustomPrimitiveDefinitionFactory other = (CustomPrimitiveDefinitionFactory)o;
        List<CustomPrimitiveSerializationDetector> this$serializationDetectors = this.serializationDetectors;
        List<CustomPrimitiveSerializationDetector> other$serializationDetectors = other.serializationDetectors;
        if (this$serializationDetectors == null ? other$serializationDetectors != null : !((Object)this$serializationDetectors).equals(other$serializationDetectors)) {
            return false;
        }
        List<CustomPrimitiveDeserializationDetector> this$deserializationDetectors = this.deserializationDetectors;
        List<CustomPrimitiveDeserializationDetector> other$deserializationDetectors = other.deserializationDetectors;
        return !(this$deserializationDetectors == null ? other$deserializationDetectors != null : !((Object)this$deserializationDetectors).equals(other$deserializationDetectors));
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        List<CustomPrimitiveSerializationDetector> $serializationDetectors = this.serializationDetectors;
        result = result * 59 + ($serializationDetectors == null ? 43 : ((Object)$serializationDetectors).hashCode());
        List<CustomPrimitiveDeserializationDetector> $deserializationDetectors = this.deserializationDetectors;
        result = result * 59 + ($deserializationDetectors == null ? 43 : ((Object)$deserializationDetectors).hashCode());
        return result;
    }

    private CustomPrimitiveDefinitionFactory(List<CustomPrimitiveSerializationDetector> serializationDetectors, List<CustomPrimitiveDeserializationDetector> deserializationDetectors) {
        this.serializationDetectors = serializationDetectors;
        this.deserializationDetectors = deserializationDetectors;
    }
}

