/*
 * Decompiled with CFR 0.152.
 */
package de.quantummaid.mapmaid.builder.detection.serializedobject;

import de.quantummaid.mapmaid.Collection;
import de.quantummaid.mapmaid.builder.detection.DetectionResult;
import de.quantummaid.mapmaid.builder.resolving.disambiguator.normal.preferences.Preferences;
import de.quantummaid.mapmaid.debug.ScanInformationBuilder;
import de.quantummaid.mapmaid.mapper.serialization.serializers.TypeSerializer;
import de.quantummaid.mapmaid.mapper.serialization.serializers.serializedobject.SerializationField;
import de.quantummaid.mapmaid.mapper.serialization.serializers.serializedobject.SerializationFields;
import de.quantummaid.mapmaid.mapper.serialization.serializers.serializedobject.SerializedObjectSerializer;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.StringJoiner;
import java.util.stream.Collectors;

public final class SerializationFieldInstantiation {
    private final Map<String, List<SerializationField>> fields;

    public static SerializationFieldInstantiation serializationFieldInstantiation(Map<String, List<SerializationField>> fields) {
        return new SerializationFieldInstantiation(fields);
    }

    public DetectionResult<TypeSerializer> instantiate(Preferences<SerializationField> preferences, ScanInformationBuilder scanInformationBuilder) {
        ArrayList<SerializationField> serializationFieldList = new ArrayList<SerializationField>(this.fields.size());
        List<String> problems = Collection.smallList();
        this.fields.forEach((name, fields) -> {
            List<SerializationField> preferredFields = preferences.preferred((List<SerializationField>)fields, scanInformationBuilder::ignoreSerializationField);
            if (preferredFields.size() != 1) {
                String fieldsString = preferredFields.stream().map(SerializationField::describe).collect(Collectors.joining(", ", "[", "]"));
                problems.add(String.format("cannot decide between %s", fieldsString));
                return;
            }
            SerializationField preferredField = preferredFields.get(0);
            serializationFieldList.add(preferredField);
        });
        if (!problems.isEmpty()) {
            return DetectionResult.failure(problems);
        }
        SerializationFields serializationFields = SerializationFields.serializationFields(serializationFieldList);
        return DetectionResult.success(SerializedObjectSerializer.serializedObjectSerializer(serializationFields));
    }

    public String describe() {
        StringJoiner joiner = new StringJoiner("\n");
        this.fields.forEach((name, serializationFields) -> joiner.add(String.format("\t- '%s' with query options '%s'", name, SerializationFieldInstantiation.describeFieldList(serializationFields))));
        return joiner.toString();
    }

    private static String describeFieldList(List<SerializationField> fieldsList) {
        return fieldsList.stream().map(SerializationField::describe).collect(Collectors.joining(", ", "[", "]"));
    }

    public String toString() {
        return "SerializationFieldInstantiation(fields=" + this.fields + ")";
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof SerializationFieldInstantiation)) {
            return false;
        }
        SerializationFieldInstantiation other = (SerializationFieldInstantiation)o;
        Map<String, List<SerializationField>> this$fields = this.fields;
        Map<String, List<SerializationField>> other$fields = other.fields;
        return !(this$fields == null ? other$fields != null : !((Object)this$fields).equals(other$fields));
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Map<String, List<SerializationField>> $fields = this.fields;
        result = result * 59 + ($fields == null ? 43 : ((Object)$fields).hashCode());
        return result;
    }

    private SerializationFieldInstantiation(Map<String, List<SerializationField>> fields) {
        this.fields = fields;
    }
}

