/*
 * Decompiled with CFR 0.152.
 */
package de.quantummaid.mapmaid.builder.detection.serializedobject.deserialization;

import de.quantummaid.mapmaid.builder.detection.serializedobject.deserialization.SerializedObjectDeserializationDetector;
import de.quantummaid.mapmaid.mapper.deserialization.deserializers.serializedobjects.ConstructorSerializedObjectDeserializer;
import de.quantummaid.mapmaid.mapper.deserialization.deserializers.serializedobjects.SerializedObjectDeserializer;
import de.quantummaid.mapmaid.shared.types.ClassType;
import de.quantummaid.mapmaid.shared.types.ResolvedType;
import de.quantummaid.mapmaid.shared.types.resolver.ResolvedConstructor;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;

public final class ConstructorBasedDeserializationDetector
implements SerializedObjectDeserializationDetector {
    public static SerializedObjectDeserializationDetector constructorBased() {
        return new ConstructorBasedDeserializationDetector();
    }

    @Override
    public List<SerializedObjectDeserializer> detect(ResolvedType type) {
        if (!(type instanceof ClassType)) {
            return Collections.emptyList();
        }
        ClassType classType = (ClassType)type;
        return ResolvedConstructor.resolveConstructors(classType).stream().map(constructor -> ConstructorSerializedObjectDeserializer.createDeserializer(classType, constructor)).collect(Collectors.toList());
    }

    public String toString() {
        return "ConstructorBasedDeserializationDetector()";
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        return o instanceof ConstructorBasedDeserializationDetector;
    }

    public int hashCode() {
        boolean result = true;
        return 1;
    }

    private ConstructorBasedDeserializationDetector() {
    }
}

