/*
 * Decompiled with CFR 0.152.
 */
package de.quantummaid.mapmaid.builder.recipes.advancedscanner;

import de.quantummaid.mapmaid.builder.GenericType;
import de.quantummaid.mapmaid.builder.MapMaidBuilder;
import de.quantummaid.mapmaid.builder.RequiredCapabilities;
import de.quantummaid.mapmaid.builder.customtypes.DeserializationOnlyType;
import de.quantummaid.mapmaid.builder.recipes.advancedscanner.VirtualDeserializer;
import de.quantummaid.mapmaid.builder.recipes.advancedscanner.deserialization_wrappers.MethodParameterDeserializationWrapper;
import de.quantummaid.mapmaid.builder.recipes.advancedscanner.deserialization_wrappers.MultipleParametersDeserializationWrapper;
import de.quantummaid.mapmaid.builder.recipes.advancedscanner.deserialization_wrappers.SingleParameterDeserializationWrapper;
import de.quantummaid.mapmaid.builder.recipes.advancedscanner.deserialization_wrappers.ZeroParametersDeserializationWrapper;
import de.quantummaid.mapmaid.mapper.deserialization.deserializers.TypeDeserializer;
import de.quantummaid.mapmaid.mapper.deserialization.deserializers.serializedobjects.SerializedObjectDeserializer;
import de.quantummaid.mapmaid.shared.identifier.TypeIdentifier;
import de.quantummaid.mapmaid.shared.types.ClassType;
import de.quantummaid.mapmaid.shared.types.ResolvedType;
import de.quantummaid.mapmaid.shared.types.resolver.ResolvedMethod;
import de.quantummaid.mapmaid.shared.types.resolver.ResolvedParameter;
import de.quantummaid.mapmaid.shared.validators.NotNullValidator;
import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

public final class UseCaseClassScanner {
    private static final List<String> OBJECT_METHODS = Arrays.stream(Object.class.getMethods()).map(Method::getName).collect(Collectors.toList());
    private final Collection<Class<?>> classes;

    public static Map<Class<?>, MethodParameterDeserializationWrapper> addAllReferencedClassesIn(MapMaidBuilder builder, Class<?> ... useCaseClasses) {
        NotNullValidator.validateNotNull(builder, "builder");
        NotNullValidator.validateNotNull(useCaseClasses, "useCaseClasses");
        return UseCaseClassScanner.addAllReferencedClassesIn(Arrays.asList(useCaseClasses), builder);
    }

    public static Map<Class<?>, MethodParameterDeserializationWrapper> addAllReferencedClassesIn(Collection<Class<?>> useCaseClasses, MapMaidBuilder builder) {
        NotNullValidator.validateNotNull(useCaseClasses, "useCaseClasses");
        NotNullValidator.validateNotNull(builder, "builder");
        HashMap deserializationWrappers = new HashMap(useCaseClasses.size());
        useCaseClasses.forEach(useCaseClass -> {
            MethodParameterDeserializationWrapper deserializationWrapper = UseCaseClassScanner.addReferencesIn(useCaseClass, builder);
            deserializationWrappers.put((Class<?>)useCaseClass, deserializationWrapper);
        });
        return deserializationWrappers;
    }

    private static MethodParameterDeserializationWrapper addReferencesIn(Class<?> useCaseClass, MapMaidBuilder builder) {
        ClassType fullType = ClassType.fromClassWithoutGenerics(useCaseClass);
        List relevantMethods = fullType.methods().stream().filter(ResolvedMethod::isPublic).filter(method -> !OBJECT_METHODS.contains(method.name())).collect(Collectors.toUnmodifiableList());
        if (relevantMethods.size() != 1) {
            throw new UnsupportedOperationException(String.format("Unable to to determine the single use case method of '%s'", fullType.description()));
        }
        ResolvedMethod useCaseMethod = (ResolvedMethod)relevantMethods.get(0);
        return UseCaseClassScanner.addMethod(useCaseMethod, builder);
    }

    private static MethodParameterDeserializationWrapper addMethod(ResolvedMethod method, MapMaidBuilder builder) {
        List<ResolvedParameter> parameters = method.parameters();
        parameters.stream().map(ResolvedParameter::type).map(GenericType::fromResolvedType).forEach(type -> builder.withType((GenericType<?>)type, RequiredCapabilities.deserialization(), String.format("because parameter type of method %s", method.describe())));
        method.returnType().ifPresent(type -> {
            GenericType genericType = GenericType.fromResolvedType(type);
            builder.withType(genericType, RequiredCapabilities.serialization(), String.format("because return type of method %s", method.describe()));
        });
        if (parameters.isEmpty()) {
            return ZeroParametersDeserializationWrapper.zeroParameters();
        }
        if (parameters.size() == 1) {
            ResolvedParameter parameter = parameters.get(0);
            String name = parameter.name();
            ResolvedType type2 = parameter.type();
            return SingleParameterDeserializationWrapper.singleParameter(name, type2);
        }
        DeserializationOnlyType<?> virtualType = UseCaseClassScanner.createVirtualObjectFor(method);
        builder.deserializing(virtualType);
        return MultipleParametersDeserializationWrapper.multipleParamters(virtualType.type());
    }

    private static DeserializationOnlyType<?> createVirtualObjectFor(ResolvedMethod method) {
        TypeIdentifier typeIdentifier = TypeIdentifier.virtualTypeIdentifier(method.describe());
        SerializedObjectDeserializer deserializer = VirtualDeserializer.virtualDeserializerFor(method);
        return DeserializationOnlyType.deserializationOnlyType(typeIdentifier, (TypeDeserializer)deserializer);
    }

    public String toString() {
        return "UseCaseClassScanner(classes=" + this.classes + ")";
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof UseCaseClassScanner)) {
            return false;
        }
        UseCaseClassScanner other = (UseCaseClassScanner)o;
        Collection<Class<?>> this$classes = this.classes;
        Collection<Class<?>> other$classes = other.classes;
        return !(this$classes == null ? other$classes != null : !((Object)this$classes).equals(other$classes));
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Collection<Class<?>> $classes = this.classes;
        result = result * 59 + ($classes == null ? 43 : ((Object)$classes).hashCode());
        return result;
    }

    private UseCaseClassScanner(Collection<Class<?>> classes) {
        this.classes = classes;
    }
}

