/*
 * Decompiled with CFR 0.152.
 */
package de.quantummaid.mapmaid.builder.recipes.advancedscanner;

import de.quantummaid.mapmaid.mapper.deserialization.DeserializationFields;
import de.quantummaid.mapmaid.mapper.deserialization.deserializers.serializedobjects.SerializedObjectDeserializer;
import de.quantummaid.mapmaid.shared.identifier.RealTypeIdentifier;
import de.quantummaid.mapmaid.shared.identifier.TypeIdentifier;
import de.quantummaid.mapmaid.shared.types.resolver.ResolvedMethod;
import de.quantummaid.mapmaid.shared.types.resolver.ResolvedParameter;
import java.util.Map;
import java.util.stream.Collectors;

public final class VirtualDeserializer
implements SerializedObjectDeserializer {
    private final ResolvedMethod method;
    private final DeserializationFields deserializationFields;

    public static SerializedObjectDeserializer virtualDeserializerFor(ResolvedMethod method) {
        Map<String, TypeIdentifier> fieldMap = method.parameters().stream().collect(Collectors.toMap(ResolvedParameter::name, parameter -> RealTypeIdentifier.realTypeIdentifier(parameter.type())));
        DeserializationFields deserializationFields = DeserializationFields.deserializationFields(fieldMap);
        return new VirtualDeserializer(method, deserializationFields);
    }

    @Override
    public DeserializationFields fields() {
        return this.deserializationFields;
    }

    @Override
    public Object deserialize(Map<String, Object> elements) {
        return elements;
    }

    @Override
    public String description() {
        return String.format("virtual deserializer for the invocation of '%s'", this.method.describe());
    }

    public String toString() {
        return "VirtualDeserializer(method=" + this.method + ", deserializationFields=" + this.deserializationFields + ")";
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof VirtualDeserializer)) {
            return false;
        }
        VirtualDeserializer other = (VirtualDeserializer)o;
        ResolvedMethod this$method = this.method;
        ResolvedMethod other$method = other.method;
        if (this$method == null ? other$method != null : !((Object)this$method).equals(other$method)) {
            return false;
        }
        DeserializationFields this$deserializationFields = this.deserializationFields;
        DeserializationFields other$deserializationFields = other.deserializationFields;
        return !(this$deserializationFields == null ? other$deserializationFields != null : !((Object)this$deserializationFields).equals(other$deserializationFields));
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        ResolvedMethod $method = this.method;
        result = result * 59 + ($method == null ? 43 : ((Object)$method).hashCode());
        DeserializationFields $deserializationFields = this.deserializationFields;
        result = result * 59 + ($deserializationFields == null ? 43 : ((Object)$deserializationFields).hashCode());
        return result;
    }

    private VirtualDeserializer(ResolvedMethod method, DeserializationFields deserializationFields) {
        this.method = method;
        this.deserializationFields = deserializationFields;
    }
}

