/*
 * Decompiled with CFR 0.152.
 */
package de.quantummaid.mapmaid.builder.recipes.di;

import de.quantummaid.mapmaid.builder.GenericType;
import de.quantummaid.mapmaid.builder.MapMaidBuilder;
import de.quantummaid.mapmaid.builder.customtypes.DuplexType;
import de.quantummaid.mapmaid.builder.recipes.Recipe;
import de.quantummaid.mapmaid.builder.recipes.di.DependencyInjector;
import de.quantummaid.mapmaid.builder.recipes.di.DiDeserializer;
import de.quantummaid.mapmaid.builder.recipes.di.DiSerializer;
import de.quantummaid.mapmaid.builder.recipes.di.GeneralDependencyInjector;
import de.quantummaid.mapmaid.mapper.deserialization.deserializers.TypeDeserializer;
import de.quantummaid.mapmaid.mapper.serialization.serializers.TypeSerializer;
import java.util.Arrays;
import java.util.List;

public final class DiRecipe
implements Recipe {
    private final GeneralDependencyInjector injector;
    private final List<Class<?>> types;

    public static Recipe toUseDependencyInjectionWith(GeneralDependencyInjector injector, Class<?> ... types) {
        return new DiRecipe(injector, Arrays.asList(types));
    }

    @Override
    public void cook(MapMaidBuilder mapMaidBuilder) {
        this.types.forEach(type -> {
            GenericType genericType = GenericType.genericType(type);
            DependencyInjector dependencyInjector = this.injector.specializedFor(type);
            TypeSerializer serializer = DiSerializer.diSerializer();
            TypeDeserializer deserializer = DiDeserializer.diDeserializer(dependencyInjector);
            DuplexType duplexType = DuplexType.duplexType(genericType, serializer, deserializer);
            mapMaidBuilder.serializingAndDeserializing(duplexType);
        });
    }

    public String toString() {
        return "DiRecipe(injector=" + this.injector + ", types=" + this.types + ")";
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof DiRecipe)) {
            return false;
        }
        DiRecipe other = (DiRecipe)o;
        GeneralDependencyInjector this$injector = this.injector;
        GeneralDependencyInjector other$injector = other.injector;
        if (this$injector == null ? other$injector != null : !this$injector.equals(other$injector)) {
            return false;
        }
        List<Class<?>> this$types = this.types;
        List<Class<?>> other$types = other.types;
        return !(this$types == null ? other$types != null : !((Object)this$types).equals(other$types));
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        GeneralDependencyInjector $injector = this.injector;
        result = result * 59 + ($injector == null ? 43 : $injector.hashCode());
        List<Class<?>> $types = this.types;
        result = result * 59 + ($types == null ? 43 : ((Object)$types).hashCode());
        return result;
    }

    private DiRecipe(GeneralDependencyInjector injector, List<Class<?>> types) {
        this.injector = injector;
        this.types = types;
    }
}

