/*
 * Decompiled with CFR 0.152.
 */
package de.quantummaid.mapmaid.builder.recipes.scanner;

import de.quantummaid.mapmaid.builder.GenericType;
import de.quantummaid.mapmaid.builder.MapMaidBuilder;
import de.quantummaid.mapmaid.builder.RequiredCapabilities;
import de.quantummaid.mapmaid.builder.recipes.Recipe;
import de.quantummaid.mapmaid.shared.types.ClassType;
import de.quantummaid.mapmaid.shared.types.resolver.ResolvedMethod;
import de.quantummaid.mapmaid.shared.types.resolver.ResolvedParameter;
import de.quantummaid.mapmaid.shared.validators.NotNullValidator;
import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;

public final class ClassScannerRecipe
implements Recipe {
    private static final List<String> OBJECT_METHODS = Arrays.stream(Object.class.getMethods()).map(Method::getName).collect(Collectors.toList());
    private final Collection<Class<?>> classes;
    private final Collection<Class<?>> serializationExclusions;
    private final Collection<Class<?>> deserializationExclusions;

    public static ClassScannerRecipe addAllReferencedClassesIn(Class<?> ... classes) {
        NotNullValidator.validateNotNull(classes, "classes");
        return new ClassScannerRecipe(Arrays.asList(classes), Collections.emptyList(), Collections.emptyList());
    }

    public static ClassScannerRecipe addAllReferencedClassesIn(Collection<Class<?>> classes, Collection<Class<?>> serializationExclusions, Collection<Class<?>> deserializationExclusions) {
        NotNullValidator.validateNotNull(classes, "classes");
        NotNullValidator.validateNotNull(serializationExclusions, "serializationExclusions");
        NotNullValidator.validateNotNull(deserializationExclusions, "deserializationExclusions");
        return new ClassScannerRecipe(classes, serializationExclusions, deserializationExclusions);
    }

    @Override
    public void cook(MapMaidBuilder mapMaidBuilder) {
        this.classes.forEach(clazz -> this.addReferencesIn((Class<?>)clazz, mapMaidBuilder));
    }

    private void addReferencesIn(Class<?> clazz, MapMaidBuilder builder) {
        ClassType fullType = ClassType.fromClassWithoutGenerics(clazz);
        List<ResolvedMethod> methods = fullType.methods();
        for (ResolvedMethod method : methods) {
            if (!method.isPublic() || OBJECT_METHODS.contains(method.method().getName())) continue;
            method.parameters().stream().map(ResolvedParameter::type).filter(type -> !this.deserializationExclusions.contains(type.assignableType())).map(GenericType::fromResolvedType).forEach(type -> builder.withType((GenericType<?>)type, RequiredCapabilities.deserialization(), String.format("because parameter type of method %s", method.describe())));
            method.returnType().ifPresent(type -> {
                if (this.serializationExclusions.contains(type.assignableType())) {
                    return;
                }
                GenericType genericType = GenericType.fromResolvedType(type);
                builder.withType(genericType, RequiredCapabilities.serialization(), String.format("because return type of method %s", method.describe()));
            });
        }
    }

    public String toString() {
        return "ClassScannerRecipe(classes=" + this.classes + ", serializationExclusions=" + this.serializationExclusions + ", deserializationExclusions=" + this.deserializationExclusions + ")";
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ClassScannerRecipe)) {
            return false;
        }
        ClassScannerRecipe other = (ClassScannerRecipe)o;
        Collection<Class<?>> this$classes = this.classes;
        Collection<Class<?>> other$classes = other.classes;
        if (this$classes == null ? other$classes != null : !((Object)this$classes).equals(other$classes)) {
            return false;
        }
        Collection<Class<?>> this$serializationExclusions = this.serializationExclusions;
        Collection<Class<?>> other$serializationExclusions = other.serializationExclusions;
        if (this$serializationExclusions == null ? other$serializationExclusions != null : !((Object)this$serializationExclusions).equals(other$serializationExclusions)) {
            return false;
        }
        Collection<Class<?>> this$deserializationExclusions = this.deserializationExclusions;
        Collection<Class<?>> other$deserializationExclusions = other.deserializationExclusions;
        return !(this$deserializationExclusions == null ? other$deserializationExclusions != null : !((Object)this$deserializationExclusions).equals(other$deserializationExclusions));
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Collection<Class<?>> $classes = this.classes;
        result = result * 59 + ($classes == null ? 43 : ((Object)$classes).hashCode());
        Collection<Class<?>> $serializationExclusions = this.serializationExclusions;
        result = result * 59 + ($serializationExclusions == null ? 43 : ((Object)$serializationExclusions).hashCode());
        Collection<Class<?>> $deserializationExclusions = this.deserializationExclusions;
        result = result * 59 + ($deserializationExclusions == null ? 43 : ((Object)$deserializationExclusions).hashCode());
        return result;
    }

    private ClassScannerRecipe(Collection<Class<?>> classes, Collection<Class<?>> serializationExclusions, Collection<Class<?>> deserializationExclusions) {
        this.classes = classes;
        this.serializationExclusions = serializationExclusions;
        this.deserializationExclusions = deserializationExclusions;
    }
}

