/*
 * Decompiled with CFR 0.152.
 */
package de.quantummaid.mapmaid.builder.resolving;

import de.quantummaid.mapmaid.builder.resolving.Reason;
import de.quantummaid.mapmaid.builder.resolving.processing.Signal;
import de.quantummaid.mapmaid.debug.ScanInformationBuilder;
import de.quantummaid.mapmaid.mapper.deserialization.deserializers.TypeDeserializer;
import de.quantummaid.mapmaid.mapper.serialization.serializers.TypeSerializer;
import de.quantummaid.mapmaid.shared.identifier.TypeIdentifier;
import java.util.function.Consumer;

public final class Context {
    private final Consumer<Signal> dispatcher;
    private final TypeIdentifier type;
    private TypeSerializer serializer;
    private TypeDeserializer deserializer;
    private final ScanInformationBuilder scanInformationBuilder;

    public static Context emptyContext(Consumer<Signal> dispatcher, TypeIdentifier type) {
        return new Context(dispatcher, type, ScanInformationBuilder.scanInformationBuilder(type));
    }

    public TypeIdentifier type() {
        return this.type;
    }

    public void dispatch(Signal signal) {
        this.dispatcher.accept(signal);
    }

    public boolean removeSerializationReasonAndReturnIfEmpty(Reason reason) {
        boolean empty = this.scanInformationBuilder.removeSerializationReasonAndReturnIfEmpty(reason);
        if (empty) {
            Reason transitiveReason = Reason.becauseOf(this.type);
            this.dispatch(definition -> definition.removeSerialization(transitiveReason));
            return true;
        }
        return false;
    }

    public boolean removeDeserializationReasonAndReturnIfEmpty(Reason reason) {
        boolean empty = this.scanInformationBuilder.removeDeserializationReasonAndReturnIfEmpty(reason);
        if (empty) {
            Reason transitiveReason = Reason.becauseOf(this.type);
            this.dispatch(definition -> definition.removeDeserialization(transitiveReason));
            return true;
        }
        return false;
    }

    public ScanInformationBuilder scanInformationBuilder() {
        return this.scanInformationBuilder;
    }

    public TypeSerializer serializer() {
        return this.serializer;
    }

    public void setSerializer(TypeSerializer serializer) {
        this.serializer = serializer;
    }

    public TypeDeserializer deserializer() {
        return this.deserializer;
    }

    public void setDeserializer(TypeDeserializer deserializer) {
        this.deserializer = deserializer;
    }

    public String toString() {
        return "Context(dispatcher=" + this.dispatcher + ", type=" + this.type + ", serializer=" + this.serializer + ", deserializer=" + this.deserializer + ", scanInformationBuilder=" + this.scanInformationBuilder + ")";
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Context)) {
            return false;
        }
        Context other = (Context)o;
        Consumer<Signal> this$dispatcher = this.dispatcher;
        Consumer<Signal> other$dispatcher = other.dispatcher;
        if (this$dispatcher == null ? other$dispatcher != null : !this$dispatcher.equals(other$dispatcher)) {
            return false;
        }
        TypeIdentifier this$type = this.type;
        TypeIdentifier other$type = other.type;
        if (this$type == null ? other$type != null : !this$type.equals(other$type)) {
            return false;
        }
        TypeSerializer this$serializer = this.serializer;
        TypeSerializer other$serializer = other.serializer;
        if (this$serializer == null ? other$serializer != null : !this$serializer.equals(other$serializer)) {
            return false;
        }
        TypeDeserializer this$deserializer = this.deserializer;
        TypeDeserializer other$deserializer = other.deserializer;
        if (this$deserializer == null ? other$deserializer != null : !this$deserializer.equals(other$deserializer)) {
            return false;
        }
        ScanInformationBuilder this$scanInformationBuilder = this.scanInformationBuilder;
        ScanInformationBuilder other$scanInformationBuilder = other.scanInformationBuilder;
        return !(this$scanInformationBuilder == null ? other$scanInformationBuilder != null : !((Object)this$scanInformationBuilder).equals(other$scanInformationBuilder));
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Consumer<Signal> $dispatcher = this.dispatcher;
        result = result * 59 + ($dispatcher == null ? 43 : $dispatcher.hashCode());
        TypeIdentifier $type = this.type;
        result = result * 59 + ($type == null ? 43 : $type.hashCode());
        TypeSerializer $serializer = this.serializer;
        result = result * 59 + ($serializer == null ? 43 : $serializer.hashCode());
        TypeDeserializer $deserializer = this.deserializer;
        result = result * 59 + ($deserializer == null ? 43 : $deserializer.hashCode());
        ScanInformationBuilder $scanInformationBuilder = this.scanInformationBuilder;
        result = result * 59 + ($scanInformationBuilder == null ? 43 : ((Object)$scanInformationBuilder).hashCode());
        return result;
    }

    private Context(Consumer<Signal> dispatcher, TypeIdentifier type, ScanInformationBuilder scanInformationBuilder) {
        this.dispatcher = dispatcher;
        this.type = type;
        this.scanInformationBuilder = scanInformationBuilder;
    }
}

