/*
 * Decompiled with CFR 0.152.
 */
package de.quantummaid.mapmaid.builder.resolving.disambiguator.normal;

import de.quantummaid.mapmaid.builder.resolving.disambiguator.normal.preferences.Filter;
import de.quantummaid.mapmaid.builder.resolving.disambiguator.normal.preferences.FilterResult;
import de.quantummaid.mapmaid.mapper.deserialization.deserializers.TypeDeserializer;
import de.quantummaid.mapmaid.mapper.deserialization.deserializers.customprimitives.CustomPrimitiveByConstructorDeserializer;
import de.quantummaid.mapmaid.mapper.deserialization.deserializers.customprimitives.CustomPrimitiveByMethodDeserializer;
import de.quantummaid.mapmaid.mapper.deserialization.deserializers.serializedobjects.ConstructorSerializedObjectDeserializer;
import de.quantummaid.mapmaid.mapper.deserialization.deserializers.serializedobjects.MethodSerializedObjectDeserializer;
import de.quantummaid.mapmaid.mapper.serialization.serializers.TypeSerializer;
import de.quantummaid.mapmaid.mapper.serialization.serializers.customprimitives.MethodCustomPrimitiveSerializer;
import de.quantummaid.mapmaid.mapper.serialization.serializers.serializedobject.SerializationField;
import de.quantummaid.mapmaid.mapper.serialization.serializers.serializedobject.queries.PublicFieldQuery;
import de.quantummaid.mapmaid.shared.types.resolver.ResolvedField;
import de.quantummaid.mapmaid.shared.types.resolver.ResolvedMethod;
import java.util.function.Predicate;

final class CommonFilters {
    private CommonFilters() {
    }

    static Filter<TypeDeserializer> ignoreNonPublicMethodsForCustomPrimitiveDeserialization() {
        return Filter.filterOfType(CustomPrimitiveByMethodDeserializer.class, deserializer -> {
            if (deserializer.method().isPublic()) {
                return FilterResult.allowed();
            }
            return FilterResult.denied("only public static methods are considered for deserialization");
        });
    }

    static Filter<TypeSerializer> ignoreNonPublicConstructorsForCustomPrimitiveSerialization() {
        return Filter.filterOfType(MethodCustomPrimitiveSerializer.class, serializer -> {
            if (serializer.method().isPublic()) {
                return FilterResult.allowed();
            }
            return FilterResult.denied("only public methods are considered for serialization");
        });
    }

    static Filter<TypeDeserializer> ignoreNonPublicConstructorsForCustomPrimitiveDeserialization() {
        return Filter.filterOfType(CustomPrimitiveByConstructorDeserializer.class, deserializer -> {
            if (deserializer.constructor().isPublic()) {
                return FilterResult.allowed();
            }
            return FilterResult.denied("only public constructors are considered for deserialization");
        });
    }

    static Filter<TypeDeserializer> ignoreNonPublicMethodsForSerializedObjectDeserialization() {
        return Filter.filterOfType(MethodSerializedObjectDeserializer.class, deserializer -> {
            if (deserializer.method().isPublic()) {
                return FilterResult.allowed();
            }
            return FilterResult.denied("only public static methods are considered for deserialization");
        });
    }

    static Filter<TypeDeserializer> ignoreNonPublicConstructorsForSerializedObjectDeserialization() {
        return Filter.filterOfType(ConstructorSerializedObjectDeserializer.class, deserializer -> {
            if (deserializer.constructor().isPublic()) {
                return FilterResult.allowed();
            }
            return FilterResult.denied("only public constructors are considered for deserialization");
        });
    }

    static Filter<TypeSerializer> nameOfSerializerMethodIsNot(String name) {
        return serializer -> {
            if (!(serializer instanceof MethodCustomPrimitiveSerializer)) {
                return FilterResult.allowed();
            }
            ResolvedMethod method = ((MethodCustomPrimitiveSerializer)serializer).method();
            boolean matchesName = method.name().equals(name);
            if (!matchesName) {
                return FilterResult.allowed();
            }
            return FilterResult.denied(String.format("method '%s' is not considered", name));
        };
    }

    static Filter<SerializationField> ignoreStaticFields() {
        return CommonFilters.ignoreFieldsThat(ResolvedField::isStatic, "static fields are not serialized");
    }

    static Filter<SerializationField> ignoreTransientFields() {
        return CommonFilters.ignoreFieldsThat(ResolvedField::isTransient, "transient fields are not serialized");
    }

    static Filter<SerializationField> ignoreNonPublicFields() {
        return CommonFilters.ignoreFieldsThat(resolvedField -> !resolvedField.isPublic(), "only public fields are serialized");
    }

    private static Filter<SerializationField> ignoreFieldsThat(Predicate<ResolvedField> fieldPredicate, String message) {
        return field -> {
            if (!(field.getQuery() instanceof PublicFieldQuery)) {
                return FilterResult.allowed();
            }
            PublicFieldQuery query = (PublicFieldQuery)field.getQuery();
            ResolvedField resolvedField = query.field();
            if (fieldPredicate.test(resolvedField)) {
                return FilterResult.denied(message);
            }
            return FilterResult.allowed();
        };
    }
}

