/*
 * Decompiled with CFR 0.152.
 */
package de.quantummaid.mapmaid.builder.resolving.disambiguator.normal;

import de.quantummaid.mapmaid.builder.resolving.disambiguator.normal.preferences.Preference;
import de.quantummaid.mapmaid.mapper.deserialization.deserializers.TypeDeserializer;
import de.quantummaid.mapmaid.mapper.deserialization.deserializers.customprimitives.CustomPrimitiveByMethodDeserializer;
import de.quantummaid.mapmaid.mapper.deserialization.deserializers.serializedobjects.MethodSerializedObjectDeserializer;
import de.quantummaid.mapmaid.mapper.serialization.serializers.TypeSerializer;
import de.quantummaid.mapmaid.mapper.serialization.serializers.customprimitives.MethodCustomPrimitiveSerializer;
import de.quantummaid.mapmaid.mapper.serialization.serializers.serializedobject.SerializationField;
import de.quantummaid.mapmaid.mapper.serialization.serializers.serializedobject.queries.PublicFieldQuery;
import de.quantummaid.mapmaid.mapper.serialization.serializers.serializedobject.queries.SerializationFieldQuery;
import de.quantummaid.mapmaid.shared.types.resolver.ResolvedMethod;
import java.lang.reflect.Method;
import java.util.function.Predicate;

final class CommonPreferences {
    private CommonPreferences() {
    }

    static Preference<SerializationField> publicFields() {
        return field -> {
            SerializationFieldQuery query = field.getQuery();
            return query instanceof PublicFieldQuery;
        };
    }

    static Preference<TypeDeserializer> serializedObjectFactoryNamed(String name) {
        return CommonPreferences.serializedObjectFactoryThat(method -> method.getName().equals(name));
    }

    static Preference<TypeDeserializer> serializedObjectFactoryWithSameNameAsClass() {
        return CommonPreferences.serializedObjectFactoryThat(CommonPreferences::methodHasSameNameAsDeclaringClass);
    }

    static Preference<TypeDeserializer> serializedObjectFactoryThat(Predicate<Method> filter) {
        return deserializer -> {
            if (!(deserializer instanceof MethodSerializedObjectDeserializer)) {
                return false;
            }
            Method method = ((MethodSerializedObjectDeserializer)deserializer).method().method();
            return filter.test(method);
        };
    }

    static Preference<TypeSerializer> customPrimitiveSerializerNamed(String name) {
        return serializer -> {
            if (!(serializer instanceof MethodCustomPrimitiveSerializer)) {
                return false;
            }
            ResolvedMethod method = ((MethodCustomPrimitiveSerializer)serializer).method();
            return method.name().equals(name);
        };
    }

    static Preference<TypeDeserializer> customPrimitiveFactoryNamed(String name) {
        return CommonPreferences.customPrimitiveFactoryThat(method -> method.getName().equals(name));
    }

    static Preference<TypeDeserializer> customPrimitiveFactoryWithSameNameAsClass() {
        return CommonPreferences.customPrimitiveFactoryThat(CommonPreferences::methodHasSameNameAsDeclaringClass);
    }

    private static Preference<TypeDeserializer> customPrimitiveFactoryThat(Predicate<Method> filter) {
        return deserializer -> {
            if (!(deserializer instanceof CustomPrimitiveByMethodDeserializer)) {
                return false;
            }
            Method method = ((CustomPrimitiveByMethodDeserializer)deserializer).method().method();
            return filter.test(method);
        };
    }

    private static boolean methodHasSameNameAsDeclaringClass(Method method) {
        String className = method.getDeclaringClass().getSimpleName().toLowerCase();
        return method.getName().toLowerCase().equals(className);
    }
}

