/*
 * Decompiled with CFR 0.152.
 */
package de.quantummaid.mapmaid.builder.resolving.disambiguator.normal;

import de.quantummaid.mapmaid.builder.detection.DetectionResult;
import de.quantummaid.mapmaid.builder.detection.serializedobject.SerializationFieldInstantiation;
import de.quantummaid.mapmaid.builder.detection.serializedobject.SerializationFieldOptions;
import de.quantummaid.mapmaid.builder.resolving.disambiguator.DisambiguationResult;
import de.quantummaid.mapmaid.builder.resolving.disambiguator.Disambiguator;
import de.quantummaid.mapmaid.builder.resolving.disambiguator.SerializersAndDeserializers;
import de.quantummaid.mapmaid.builder.resolving.disambiguator.normal.Picker;
import de.quantummaid.mapmaid.builder.resolving.disambiguator.normal.preferences.Filters;
import de.quantummaid.mapmaid.builder.resolving.disambiguator.normal.preferences.Preferences;
import de.quantummaid.mapmaid.builder.resolving.disambiguator.normal.symmetry.customprimitive.CustomPrimitiveSymmetryBuilder;
import de.quantummaid.mapmaid.builder.resolving.disambiguator.normal.symmetry.serializedobject.EquivalenceClass;
import de.quantummaid.mapmaid.builder.resolving.disambiguator.normal.symmetry.serializedobject.SerializedObjectOptions;
import de.quantummaid.mapmaid.builder.resolving.disambiguator.normal.symmetry.serializedobject.SymmetryBuilder;
import de.quantummaid.mapmaid.builder.resolving.disambiguator.normal.tiebreaker.TieBreaker;
import de.quantummaid.mapmaid.debug.ScanInformationBuilder;
import de.quantummaid.mapmaid.mapper.deserialization.deserializers.TypeDeserializer;
import de.quantummaid.mapmaid.mapper.deserialization.deserializers.customprimitives.CustomPrimitiveDeserializer;
import de.quantummaid.mapmaid.mapper.serialization.serializers.TypeSerializer;
import de.quantummaid.mapmaid.mapper.serialization.serializers.customprimitives.CustomPrimitiveSerializer;
import de.quantummaid.mapmaid.mapper.serialization.serializers.serializedobject.SerializationField;
import de.quantummaid.mapmaid.shared.types.ResolvedType;
import java.util.List;
import java.util.Optional;

public final class NormalDisambiguator
implements Disambiguator {
    private final Preferences<TypeDeserializer> customPrimitiveDeserializerPreferences;
    private final Preferences<TypeSerializer> customPrimitiveSerializerPreferences;
    private final Preferences<TypeDeserializer> serializedObjectDeserializerPreferences;
    private final Filters<SerializationField> serializationFieldFilters;
    private final Preferences<SerializationField> postSymmetrySerializationFieldPreferences;
    private final TieBreaker tieBreaker;

    public static NormalDisambiguator normalDisambiguator(Preferences<TypeDeserializer> customPrimitiveDeserializerPreferences, Preferences<TypeSerializer> customPrimitiveSerializerPreferences, Preferences<TypeDeserializer> serializedObjectPreferences, Filters<SerializationField> serializationFieldFilters, Preferences<SerializationField> postSymmetrySerializationFieldPreferences, TieBreaker tieBreaker) {
        return new NormalDisambiguator(customPrimitiveDeserializerPreferences, customPrimitiveSerializerPreferences, serializedObjectPreferences, serializationFieldFilters, postSymmetrySerializationFieldPreferences, tieBreaker);
    }

    @Override
    public DetectionResult<DisambiguationResult> disambiguate(ResolvedType type, SerializedObjectOptions serializedObjectOptions, SerializersAndDeserializers customPrimitiveSerializersAndDeserializers, ScanInformationBuilder scanInformationBuilder) {
        if (type.assignableType().getPackageName().startsWith("java.")) {
            return DetectionResult.failure("Native java classes cannot be detected");
        }
        SerializedObjectOptions filteredSerializedObjectOptions = this.filterSerializedObjectOptions(serializedObjectOptions, scanInformationBuilder);
        SerializersAndDeserializers preferredCustomPrimitiveSerializersAndDeserializers = this.filterCustomPrimitiveOptions(customPrimitiveSerializersAndDeserializers, scanInformationBuilder);
        if (preferredCustomPrimitiveSerializersAndDeserializers.serializationOnly()) {
            return this.serializationOnly(preferredCustomPrimitiveSerializersAndDeserializers, filteredSerializedObjectOptions, scanInformationBuilder);
        }
        if (preferredCustomPrimitiveSerializersAndDeserializers.deserializationOnly()) {
            return this.deserializationOnly(preferredCustomPrimitiveSerializersAndDeserializers, filteredSerializedObjectOptions, scanInformationBuilder);
        }
        return this.duplex(type, preferredCustomPrimitiveSerializersAndDeserializers, filteredSerializedObjectOptions, scanInformationBuilder);
    }

    private DetectionResult<DisambiguationResult> serializationOnly(SerializersAndDeserializers customPrimitiveSerializersAndDeserializers, SerializedObjectOptions serializedObjectOptions, ScanInformationBuilder scanInformationBuilder) {
        List<TypeSerializer> customPrimitiveSerializers = customPrimitiveSerializersAndDeserializers.serializers();
        DetectionResult customPrimitiveSerializer = Picker.oneOrNone(customPrimitiveSerializers, TypeSerializer::description).orElseGet(() -> DetectionResult.failure("No serializers to choose from"));
        DetectionResult<TypeSerializer> serializedObjectSerializer = serializedObjectOptions.determineSerializer(this.postSymmetrySerializationFieldPreferences, scanInformationBuilder);
        return this.tieBreaker.breakTieForSerializationOnly(customPrimitiveSerializer, serializedObjectSerializer, scanInformationBuilder).map(DisambiguationResult::serializationOnlyResult);
    }

    private DetectionResult<DisambiguationResult> deserializationOnly(SerializersAndDeserializers customPrimitiveSerializersAndDeserializers, SerializedObjectOptions serializedObjectOptions, ScanInformationBuilder scanInformationBuilder) {
        DetectionResult<TypeDeserializer> customPrimitiveDeserializer = Picker.pickDeserializer(customPrimitiveSerializersAndDeserializers.deserializers());
        DetectionResult<TypeDeserializer> serializedObjectDeserializer = Picker.pickDeserializer(serializedObjectOptions.deserializers());
        return this.tieBreaker.breakTieForDeserializationOnly(customPrimitiveDeserializer, serializedObjectDeserializer, scanInformationBuilder).map(DisambiguationResult::deserializationOnlyResult);
    }

    private DetectionResult<DisambiguationResult> duplex(ResolvedType type, SerializersAndDeserializers customPrimitiveSerializersAndDeserializers, SerializedObjectOptions serializedObjectOptions, ScanInformationBuilder scanInformationBuilder) {
        CustomPrimitiveSymmetryBuilder customPrimitiveSymmetryBuilder = CustomPrimitiveSymmetryBuilder.customPrimitiveSymmetryBuilder();
        customPrimitiveSerializersAndDeserializers.serializers().forEach(serializer -> customPrimitiveSymmetryBuilder.addSerializer((CustomPrimitiveSerializer)serializer));
        customPrimitiveSerializersAndDeserializers.deserializers().forEach(deserializer -> customPrimitiveSymmetryBuilder.addDeserializer((CustomPrimitiveDeserializer)deserializer));
        Optional<SerializersAndDeserializers> customPrimitiveResult = customPrimitiveSymmetryBuilder.determineGreatestCommonFields();
        if (customPrimitiveResult.isPresent()) {
            return this.symmetricCustomPrimitive(customPrimitiveResult.get(), scanInformationBuilder);
        }
        return this.symmetricSerializedObject(type, serializedObjectOptions, scanInformationBuilder);
    }

    private DetectionResult<DisambiguationResult> symmetricCustomPrimitive(SerializersAndDeserializers serializersAndDeserializers, ScanInformationBuilder scanInformationBuilder) {
        DetectionResult<TypeDeserializer> deserializer;
        DetectionResult<TypeSerializer> serializer = Picker.pickSerializer(serializersAndDeserializers);
        if (!serializer.isFailure()) {
            scanInformationBuilder.ignoreAllOtherSerializers(serializer.result(), String.format("less priority than %s", serializer.result().description()));
        }
        if (!(deserializer = Picker.pickDeserializer(serializersAndDeserializers.deserializers())).isFailure()) {
            scanInformationBuilder.ignoreAllOtherDeserializers(deserializer.result(), String.format("less priority than %s", deserializer.result().description()));
        }
        return DetectionResult.combine(serializer, deserializer, DisambiguationResult::duplexResult);
    }

    private DetectionResult<DisambiguationResult> symmetricSerializedObject(ResolvedType type, SerializedObjectOptions serializedObjectOptions, ScanInformationBuilder scanInformationBuilder) {
        DetectionResult<TypeDeserializer> deserializer;
        SymmetryBuilder symmetryBuilder = SymmetryBuilder.symmetryBuilder();
        List<TypeDeserializer> deserializers = serializedObjectOptions.deserializers();
        deserializers.forEach(symmetryBuilder::addDeserializer);
        symmetryBuilder.addSerializer(serializedObjectOptions.serializationFieldOptions());
        DetectionResult<EquivalenceClass> symmetric = symmetryBuilder.determineGreatestCommonFields();
        if (symmetric.isFailure()) {
            return DetectionResult.failure(String.format("Failed to detect %s:%n%s", type.description(), symmetric.reasonForFailure()));
        }
        EquivalenceClass symmetricResult = symmetric.result();
        SerializationFieldInstantiation serializationFields = symmetricResult.serializationFields();
        DetectionResult<TypeSerializer> serializer = serializationFields.instantiate(this.postSymmetrySerializationFieldPreferences, scanInformationBuilder);
        if (!serializer.isFailure()) {
            scanInformationBuilder.ignoreAllOtherSerializers(serializer.result(), "insufficient symmetry");
        }
        if (!(deserializer = Picker.pickDeserializer(symmetricResult.deserializers())).isFailure()) {
            scanInformationBuilder.ignoreAllOtherDeserializers(deserializer.result(), "insufficient symmetry");
        }
        return DetectionResult.combine(serializer, deserializer, DisambiguationResult::duplexResult);
    }

    private SerializersAndDeserializers filterCustomPrimitiveOptions(SerializersAndDeserializers serializersAndDeserializers, ScanInformationBuilder scanInformationBuilder) {
        List<TypeDeserializer> preferredCustomPrimitiveDeserializers;
        List<TypeSerializer> preferredCustomPrimitiveSerializers;
        if (serializersAndDeserializers.serializers() != null) {
            List<TypeSerializer> customPrimitveSerializers = serializersAndDeserializers.serializers();
            preferredCustomPrimitiveSerializers = this.customPrimitiveSerializerPreferences.preferred(customPrimitveSerializers, scanInformationBuilder::ignoreSerializer);
        } else {
            preferredCustomPrimitiveSerializers = null;
        }
        if (serializersAndDeserializers.deserializers() != null) {
            List<TypeDeserializer> customPrimitiveDeserializers = serializersAndDeserializers.deserializers();
            preferredCustomPrimitiveDeserializers = this.customPrimitiveDeserializerPreferences.preferred(customPrimitiveDeserializers, scanInformationBuilder::ignoreDeserializer);
        } else {
            preferredCustomPrimitiveDeserializers = null;
        }
        return SerializersAndDeserializers.serializersAndDeserializers(preferredCustomPrimitiveSerializers, preferredCustomPrimitiveDeserializers);
    }

    private SerializedObjectOptions filterSerializedObjectOptions(SerializedObjectOptions serializedObjectOptions, ScanInformationBuilder scanInformationBuilder) {
        List<TypeDeserializer> filteredSerializedObjectDeserializers;
        SerializationFieldOptions serializationFieldOptions = serializedObjectOptions.serializationFieldOptions();
        SerializationFieldOptions filteredSerialzationFields = serializationFieldOptions != null ? serializationFieldOptions.filter(field -> this.serializationFieldFilters.isAllowed((SerializationField)field, scanInformationBuilder::ignoreSerializationField)) : null;
        if (serializedObjectOptions.deserializers() != null) {
            List<TypeDeserializer> serializedObjectDeserializers = serializedObjectOptions.deserializers();
            filteredSerializedObjectDeserializers = this.serializedObjectDeserializerPreferences.preferred(serializedObjectDeserializers, scanInformationBuilder::ignoreDeserializer);
        } else {
            filteredSerializedObjectDeserializers = null;
        }
        return SerializedObjectOptions.serializedObjectOptions(filteredSerialzationFields, filteredSerializedObjectDeserializers);
    }

    public String toString() {
        return "NormalDisambiguator(customPrimitiveDeserializerPreferences=" + this.customPrimitiveDeserializerPreferences + ", customPrimitiveSerializerPreferences=" + this.customPrimitiveSerializerPreferences + ", serializedObjectDeserializerPreferences=" + this.serializedObjectDeserializerPreferences + ", serializationFieldFilters=" + this.serializationFieldFilters + ", postSymmetrySerializationFieldPreferences=" + this.postSymmetrySerializationFieldPreferences + ", tieBreaker=" + this.tieBreaker + ")";
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof NormalDisambiguator)) {
            return false;
        }
        NormalDisambiguator other = (NormalDisambiguator)o;
        Preferences<TypeDeserializer> this$customPrimitiveDeserializerPreferences = this.customPrimitiveDeserializerPreferences;
        Preferences<TypeDeserializer> other$customPrimitiveDeserializerPreferences = other.customPrimitiveDeserializerPreferences;
        if (this$customPrimitiveDeserializerPreferences == null ? other$customPrimitiveDeserializerPreferences != null : !((Object)this$customPrimitiveDeserializerPreferences).equals(other$customPrimitiveDeserializerPreferences)) {
            return false;
        }
        Preferences<TypeSerializer> this$customPrimitiveSerializerPreferences = this.customPrimitiveSerializerPreferences;
        Preferences<TypeSerializer> other$customPrimitiveSerializerPreferences = other.customPrimitiveSerializerPreferences;
        if (this$customPrimitiveSerializerPreferences == null ? other$customPrimitiveSerializerPreferences != null : !((Object)this$customPrimitiveSerializerPreferences).equals(other$customPrimitiveSerializerPreferences)) {
            return false;
        }
        Preferences<TypeDeserializer> this$serializedObjectDeserializerPreferences = this.serializedObjectDeserializerPreferences;
        Preferences<TypeDeserializer> other$serializedObjectDeserializerPreferences = other.serializedObjectDeserializerPreferences;
        if (this$serializedObjectDeserializerPreferences == null ? other$serializedObjectDeserializerPreferences != null : !((Object)this$serializedObjectDeserializerPreferences).equals(other$serializedObjectDeserializerPreferences)) {
            return false;
        }
        Filters<SerializationField> this$serializationFieldFilters = this.serializationFieldFilters;
        Filters<SerializationField> other$serializationFieldFilters = other.serializationFieldFilters;
        if (this$serializationFieldFilters == null ? other$serializationFieldFilters != null : !((Object)this$serializationFieldFilters).equals(other$serializationFieldFilters)) {
            return false;
        }
        Preferences<SerializationField> this$postSymmetrySerializationFieldPreferences = this.postSymmetrySerializationFieldPreferences;
        Preferences<SerializationField> other$postSymmetrySerializationFieldPreferences = other.postSymmetrySerializationFieldPreferences;
        if (this$postSymmetrySerializationFieldPreferences == null ? other$postSymmetrySerializationFieldPreferences != null : !((Object)this$postSymmetrySerializationFieldPreferences).equals(other$postSymmetrySerializationFieldPreferences)) {
            return false;
        }
        TieBreaker this$tieBreaker = this.tieBreaker;
        TieBreaker other$tieBreaker = other.tieBreaker;
        return !(this$tieBreaker == null ? other$tieBreaker != null : !((Object)this$tieBreaker).equals(other$tieBreaker));
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Preferences<TypeDeserializer> $customPrimitiveDeserializerPreferences = this.customPrimitiveDeserializerPreferences;
        result = result * 59 + ($customPrimitiveDeserializerPreferences == null ? 43 : ((Object)$customPrimitiveDeserializerPreferences).hashCode());
        Preferences<TypeSerializer> $customPrimitiveSerializerPreferences = this.customPrimitiveSerializerPreferences;
        result = result * 59 + ($customPrimitiveSerializerPreferences == null ? 43 : ((Object)$customPrimitiveSerializerPreferences).hashCode());
        Preferences<TypeDeserializer> $serializedObjectDeserializerPreferences = this.serializedObjectDeserializerPreferences;
        result = result * 59 + ($serializedObjectDeserializerPreferences == null ? 43 : ((Object)$serializedObjectDeserializerPreferences).hashCode());
        Filters<SerializationField> $serializationFieldFilters = this.serializationFieldFilters;
        result = result * 59 + ($serializationFieldFilters == null ? 43 : ((Object)$serializationFieldFilters).hashCode());
        Preferences<SerializationField> $postSymmetrySerializationFieldPreferences = this.postSymmetrySerializationFieldPreferences;
        result = result * 59 + ($postSymmetrySerializationFieldPreferences == null ? 43 : ((Object)$postSymmetrySerializationFieldPreferences).hashCode());
        TieBreaker $tieBreaker = this.tieBreaker;
        result = result * 59 + ($tieBreaker == null ? 43 : ((Object)$tieBreaker).hashCode());
        return result;
    }

    private NormalDisambiguator(Preferences<TypeDeserializer> customPrimitiveDeserializerPreferences, Preferences<TypeSerializer> customPrimitiveSerializerPreferences, Preferences<TypeDeserializer> serializedObjectDeserializerPreferences, Filters<SerializationField> serializationFieldFilters, Preferences<SerializationField> postSymmetrySerializationFieldPreferences, TieBreaker tieBreaker) {
        this.customPrimitiveDeserializerPreferences = customPrimitiveDeserializerPreferences;
        this.customPrimitiveSerializerPreferences = customPrimitiveSerializerPreferences;
        this.serializedObjectDeserializerPreferences = serializedObjectDeserializerPreferences;
        this.serializationFieldFilters = serializationFieldFilters;
        this.postSymmetrySerializationFieldPreferences = postSymmetrySerializationFieldPreferences;
        this.tieBreaker = tieBreaker;
    }
}

