/*
 * Decompiled with CFR 0.152.
 */
package de.quantummaid.mapmaid.builder.resolving.disambiguator.normal.preferences;

import de.quantummaid.mapmaid.builder.resolving.disambiguator.normal.preferences.Filter;
import de.quantummaid.mapmaid.builder.resolving.disambiguator.normal.preferences.Filters;
import de.quantummaid.mapmaid.builder.resolving.disambiguator.normal.preferences.Preference;
import de.quantummaid.mapmaid.builder.resolving.disambiguator.normal.preferences.Striker;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;

public final class Preferences<T> {
    private final Filters<T> filters;
    private final List<Preference<T>> preferences;

    public static <T> Preferences<T> preferences(List<Filter<T>> filters, List<Preference<T>> preferences) {
        return new Preferences<T>(Filters.filters(filters), preferences);
    }

    public static <T> Preferences<T> preferences(List<Preference<T>> preferences) {
        return Preferences.preferences(Collections.emptyList(), preferences);
    }

    public List<T> preferred(List<T> options, Striker<T> striker) {
        List filtered = options.stream().filter(t -> this.filters.isAllowed(t, striker)).collect(Collectors.toList());
        for (Preference<T> preference : this.preferences) {
            List preferred = filtered.stream().filter(preference::prefer).collect(Collectors.toList());
            if (preferred.isEmpty()) continue;
            return preferred;
        }
        return filtered;
    }

    public String toString() {
        return "Preferences(filters=" + this.filters + ", preferences=" + this.preferences + ")";
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Preferences)) {
            return false;
        }
        Preferences other = (Preferences)o;
        Filters<T> this$filters = this.filters;
        Filters<T> other$filters = other.filters;
        if (this$filters == null ? other$filters != null : !((Object)this$filters).equals(other$filters)) {
            return false;
        }
        List<Preference<T>> this$preferences = this.preferences;
        List<Preference<T>> other$preferences = other.preferences;
        return !(this$preferences == null ? other$preferences != null : !((Object)this$preferences).equals(other$preferences));
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Filters<T> $filters = this.filters;
        result = result * 59 + ($filters == null ? 43 : ((Object)$filters).hashCode());
        List<Preference<T>> $preferences = this.preferences;
        result = result * 59 + ($preferences == null ? 43 : ((Object)$preferences).hashCode());
        return result;
    }

    private Preferences(Filters<T> filters, List<Preference<T>> preferences) {
        this.filters = filters;
        this.preferences = preferences;
    }
}

