/*
 * Decompiled with CFR 0.152.
 */
package de.quantummaid.mapmaid.builder.resolving.processing;

import de.quantummaid.mapmaid.Collection;
import de.quantummaid.mapmaid.builder.detection.SimpleDetector;
import de.quantummaid.mapmaid.builder.resolving.Report;
import de.quantummaid.mapmaid.builder.resolving.disambiguator.Disambiguators;
import de.quantummaid.mapmaid.builder.resolving.processing.CollectionResult;
import de.quantummaid.mapmaid.builder.resolving.processing.Signal;
import de.quantummaid.mapmaid.builder.resolving.processing.States;
import de.quantummaid.mapmaid.builder.resolving.states.StatefulDefinition;
import de.quantummaid.mapmaid.debug.MapMaidException;
import de.quantummaid.mapmaid.debug.scaninformation.ScanInformation;
import de.quantummaid.mapmaid.shared.identifier.TypeIdentifier;
import de.quantummaid.mapmaid.shared.validators.NotNullValidator;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.Map;
import java.util.Queue;

public final class Processor {
    private States states;
    private final Queue<Signal> pendingSignals;

    public static Processor processor() {
        LinkedList<Signal> pendingSignals = new LinkedList<Signal>();
        States states = States.states(Collection.smallList());
        Processor processor = new Processor(states, pendingSignals);
        return processor;
    }

    public void dispatch(Signal signal) {
        this.pendingSignals.add(signal);
    }

    public void addState(StatefulDefinition statefulDefinition) {
        NotNullValidator.validateNotNull(statefulDefinition, "statefulDefinition");
        this.states = this.states.addState(statefulDefinition);
    }

    public Map<TypeIdentifier, CollectionResult> collect(SimpleDetector detector, Disambiguators disambiguators) {
        this.resolveRecursively(detector, disambiguators);
        Map<TypeIdentifier, Report> reports = this.states.collect();
        HashMap<TypeIdentifier, CollectionResult> definitions = new HashMap<TypeIdentifier, CollectionResult>(reports.size());
        reports.forEach((type, report) -> {
            if (!report.isSuccess()) {
                ScanInformation scanInformation = report.result().scanInformation();
                throw MapMaidException.mapMaidException(type.description() + ": " + report.errorMessage(), scanInformation);
            }
            definitions.put((TypeIdentifier)type, report.result());
        });
        return definitions;
    }

    private void resolveRecursively(SimpleDetector detector, Disambiguators disambiguators) {
        States resolved;
        while (!this.pendingSignals.isEmpty()) {
            Signal signal = this.pendingSignals.remove();
            this.states = this.states.apply(signal, this);
        }
        States detected = this.states.apply(Signal.detect(detector, disambiguators), this);
        this.states = resolved = detected.apply(Signal.resolve(), this);
        if (!this.pendingSignals.isEmpty()) {
            this.resolveRecursively(detector, disambiguators);
        }
    }

    public String toString() {
        return "Processor(states=" + this.states + ", pendingSignals=" + this.pendingSignals + ")";
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Processor)) {
            return false;
        }
        Processor other = (Processor)o;
        States this$states = this.states;
        States other$states = other.states;
        if (this$states == null ? other$states != null : !((Object)this$states).equals(other$states)) {
            return false;
        }
        Queue<Signal> this$pendingSignals = this.pendingSignals;
        Queue<Signal> other$pendingSignals = other.pendingSignals;
        return !(this$pendingSignals == null ? other$pendingSignals != null : !this$pendingSignals.equals(other$pendingSignals));
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        States $states = this.states;
        result = result * 59 + ($states == null ? 43 : ((Object)$states).hashCode());
        Queue<Signal> $pendingSignals = this.pendingSignals;
        result = result * 59 + ($pendingSignals == null ? 43 : $pendingSignals.hashCode());
        return result;
    }

    private Processor(States states, Queue<Signal> pendingSignals) {
        this.states = states;
        this.pendingSignals = pendingSignals;
    }
}

