/*
 * Decompiled with CFR 0.152.
 */
package de.quantummaid.mapmaid.builder.resolving.processing;

import de.quantummaid.mapmaid.builder.detection.SimpleDetector;
import de.quantummaid.mapmaid.builder.resolving.Reason;
import de.quantummaid.mapmaid.builder.resolving.disambiguator.Disambiguators;
import de.quantummaid.mapmaid.builder.resolving.states.StatefulDefinition;
import de.quantummaid.mapmaid.shared.identifier.TypeIdentifier;
import java.util.Optional;

public interface Signal {
    public static Signal detect(SimpleDetector detector, Disambiguators disambiguators) {
        return definition -> definition.detect(detector, disambiguators);
    }

    public static Signal addSerialization(TypeIdentifier type, Reason reason) {
        return Signal.to(type, definition -> definition.addSerialization(reason));
    }

    public static Signal addDeserialization(TypeIdentifier type, Reason reason) {
        return Signal.to(type, definition -> definition.addDeserialization(reason));
    }

    public static Signal resolve() {
        return StatefulDefinition::resolve;
    }

    public static Signal to(final TypeIdentifier target, final Signal signal) {
        return new Signal(){

            @Override
            public Optional<TypeIdentifier> target() {
                return Optional.of(target);
            }

            @Override
            public StatefulDefinition handleState(StatefulDefinition definition) {
                return signal.handleState(definition);
            }
        };
    }

    default public Optional<TypeIdentifier> target() {
        return Optional.empty();
    }

    public StatefulDefinition handleState(StatefulDefinition var1);
}

