/*
 * Decompiled with CFR 0.152.
 */
package de.quantummaid.mapmaid.builder.resolving.processing.factories.collections;

import de.quantummaid.mapmaid.builder.resolving.Context;
import de.quantummaid.mapmaid.builder.resolving.processing.factories.StateFactory;
import de.quantummaid.mapmaid.builder.resolving.states.StatefulDefinition;
import de.quantummaid.mapmaid.builder.resolving.states.fixed.resolving.FixedResolvingDuplex;
import de.quantummaid.mapmaid.mapper.deserialization.deserializers.collections.ArrayCollectionDeserializer;
import de.quantummaid.mapmaid.mapper.serialization.serializers.collections.ArrayCollectionSerializer;
import de.quantummaid.mapmaid.shared.identifier.TypeIdentifier;
import de.quantummaid.mapmaid.shared.types.ArrayType;
import de.quantummaid.mapmaid.shared.types.ResolvedType;
import java.util.Optional;

public final class ArrayCollectionDefinitionFactory
implements StateFactory {
    public static ArrayCollectionDefinitionFactory arrayFactory() {
        return new ArrayCollectionDefinitionFactory();
    }

    @Override
    public Optional<StatefulDefinition> create(TypeIdentifier typeIdentifier, Context context) {
        if (typeIdentifier.isVirtual()) {
            return Optional.empty();
        }
        ResolvedType type = typeIdentifier.getRealType();
        if (!(type instanceof ArrayType)) {
            return Optional.empty();
        }
        ResolvedType genericType = ((ArrayType)type).componentType();
        context.setDeserializer(ArrayCollectionDeserializer.arrayDeserializer(genericType));
        context.setSerializer(ArrayCollectionSerializer.arraySerializer(genericType));
        return Optional.of(FixedResolvingDuplex.fixedResolvingDuplex(context));
    }

    public String toString() {
        return "ArrayCollectionDefinitionFactory()";
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        return o instanceof ArrayCollectionDefinitionFactory;
    }

    public int hashCode() {
        boolean result = true;
        return 1;
    }

    private ArrayCollectionDefinitionFactory() {
    }
}

