/*
 * Decompiled with CFR 0.152.
 */
package de.quantummaid.mapmaid.builder.resolving.processing.factories.primitives;

import de.quantummaid.mapmaid.builder.resolving.Context;
import de.quantummaid.mapmaid.builder.resolving.processing.factories.StateFactory;
import de.quantummaid.mapmaid.builder.resolving.processing.factories.primitives.BuiltInPrimitiveDeserializer;
import de.quantummaid.mapmaid.builder.resolving.processing.factories.primitives.BuiltInPrimitiveSerializer;
import de.quantummaid.mapmaid.builder.resolving.processing.factories.primitives.PrimitiveInformation;
import de.quantummaid.mapmaid.builder.resolving.states.StatefulDefinition;
import de.quantummaid.mapmaid.builder.resolving.states.fixed.resolved.FixedResolvedDuplex;
import de.quantummaid.mapmaid.mapper.deserialization.deserializers.customprimitives.CustomPrimitiveDeserializer;
import de.quantummaid.mapmaid.mapper.serialization.serializers.customprimitives.CustomPrimitiveSerializer;
import de.quantummaid.mapmaid.shared.identifier.TypeIdentifier;
import de.quantummaid.mapmaid.shared.types.ResolvedType;
import java.util.Map;
import java.util.Optional;

public final class BuiltInPrimitivesFactory
implements StateFactory {
    private final Map<ResolvedType, PrimitiveInformation> definitions = PrimitiveInformation.primitiveInformations();

    public static BuiltInPrimitivesFactory builtInPrimitivesFactory() {
        return new BuiltInPrimitivesFactory();
    }

    @Override
    public Optional<StatefulDefinition> create(TypeIdentifier typeIdentifier, Context context) {
        if (typeIdentifier.isVirtual()) {
            return Optional.empty();
        }
        ResolvedType type = typeIdentifier.getRealType();
        if (!this.definitions.containsKey(type)) {
            return Optional.empty();
        }
        PrimitiveInformation primitiveInformation = this.definitions.get(type);
        CustomPrimitiveSerializer customPrimitiveSerializer = BuiltInPrimitiveSerializer.builtInPrimitiveSerializer();
        context.setSerializer(customPrimitiveSerializer);
        CustomPrimitiveDeserializer customPrimitiveDeserializer = BuiltInPrimitiveDeserializer.builtInPrimitiveDeserializer(primitiveInformation);
        context.setDeserializer(customPrimitiveDeserializer);
        return Optional.of(FixedResolvedDuplex.fixedResolvedDuplex(context));
    }

    public String toString() {
        return "BuiltInPrimitivesFactory(definitions=" + this.definitions + ")";
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof BuiltInPrimitivesFactory)) {
            return false;
        }
        BuiltInPrimitivesFactory other = (BuiltInPrimitivesFactory)o;
        Map<ResolvedType, PrimitiveInformation> this$definitions = this.definitions;
        Map<ResolvedType, PrimitiveInformation> other$definitions = other.definitions;
        return !(this$definitions == null ? other$definitions != null : !((Object)this$definitions).equals(other$definitions));
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Map<ResolvedType, PrimitiveInformation> $definitions = this.definitions;
        result = result * 59 + ($definitions == null ? 43 : ((Object)$definitions).hashCode());
        return result;
    }

    private BuiltInPrimitivesFactory() {
    }
}

