/*
 * Decompiled with CFR 0.152.
 */
package de.quantummaid.mapmaid.debug;

import de.quantummaid.mapmaid.Collection;
import de.quantummaid.mapmaid.builder.resolving.Reason;
import de.quantummaid.mapmaid.debug.scaninformation.ActualScanInformation;
import de.quantummaid.mapmaid.debug.scaninformation.ScanInformation;
import de.quantummaid.mapmaid.mapper.deserialization.deserializers.TypeDeserializer;
import de.quantummaid.mapmaid.mapper.serialization.serializers.TypeSerializer;
import de.quantummaid.mapmaid.mapper.serialization.serializers.serializedobject.SerializationField;
import de.quantummaid.mapmaid.mapper.serialization.serializers.serializedobject.SerializedObjectSerializer;
import de.quantummaid.mapmaid.shared.identifier.TypeIdentifier;
import java.util.List;
import java.util.Map;

public final class ScanInformationBuilder {
    private final TypeIdentifier type;
    private final List<Reason> deserializationReasons;
    private final List<Reason> serializationReasons;
    private final Map<TypeSerializer, List<String>> serializers;
    private final Map<SerializationField, List<String>> serializationFields;
    private final Map<TypeDeserializer, List<String>> deserializers;

    public static ScanInformationBuilder scanInformationBuilder(TypeIdentifier type) {
        return new ScanInformationBuilder(type, Collection.smallList(), Collection.smallList(), Collection.smallMap(), Collection.smallMap(), Collection.smallMap());
    }

    public void addSerializer(TypeSerializer serializer) {
        this.serializers.put(serializer, Collection.smallList());
    }

    public void addSerializationField(SerializationField field) {
        this.serializationFields.put(field, Collection.smallList());
    }

    public void addDeserializer(TypeDeserializer deserializer) {
        this.deserializers.put(deserializer, Collection.smallList());
    }

    public void resetScan() {
        this.serializers.clear();
        this.deserializers.clear();
    }

    public void addSerializationReason(Reason reason) {
        if (this.serializationReasons.contains(reason)) {
            return;
        }
        this.serializationReasons.add(reason);
    }

    public boolean removeSerializationReasonAndReturnIfEmpty(Reason reason) {
        this.serializationReasons.remove(reason);
        return this.serializationReasons.isEmpty();
    }

    public void addDeserializationReason(Reason reason) {
        if (this.deserializationReasons.contains(reason)) {
            return;
        }
        this.deserializationReasons.add(reason);
    }

    public boolean removeDeserializationReasonAndReturnIfEmpty(Reason reason) {
        this.deserializationReasons.remove(reason);
        return this.deserializationReasons.isEmpty();
    }

    public void ignoreAllOtherSerializers(TypeSerializer serializer, String reason) {
        this.serializers.forEach((current, reasons) -> {
            if (!current.equals(serializer)) {
                reasons.add(reason);
            }
        });
    }

    public void ignoreDeserializer(TypeDeserializer deserializer, String reason) {
        this.deserializers.get(deserializer).add(reason);
    }

    public void ignoreDeserializer(TypeDeserializer deserializer, List<String> reasons) {
        reasons.forEach(reason -> this.ignoreDeserializer(deserializer, (String)reason));
    }

    public void ignoreSerializer(TypeSerializer serializer, String reason) {
        this.serializers.get(serializer).add(reason);
    }

    public void ignoreSerializer(TypeSerializer serializer, List<String> reasons) {
        reasons.forEach(reason -> this.ignoreSerializer(serializer, (String)reason));
    }

    public void ignoreSerializationField(SerializationField field, List<String> reasons) {
        this.serializationFields.get(field).addAll(reasons);
    }

    public void ignoreSerializationField(SerializationField field, String reason) {
        this.serializationFields.get(field).add(reason);
    }

    public void ignoreAllOtherDeserializers(TypeDeserializer deserializer, String reason) {
        this.deserializers.forEach((current, reasons) -> {
            if (!current.equals(deserializer)) {
                reasons.add(reason);
            }
        });
    }

    public void ignore(Object object, String reason) {
        if (object instanceof SerializedObjectSerializer) {
            List<SerializationField> fields = ((SerializedObjectSerializer)object).fields().fields();
            fields.forEach(field -> this.ignoreSerializationField((SerializationField)field, reason));
        } else if (object instanceof TypeSerializer) {
            this.ignoreSerializer((TypeSerializer)object, reason);
        } else if (object instanceof TypeDeserializer) {
            this.ignoreDeserializer((TypeDeserializer)object, reason);
        } else if (object instanceof SerializationField) {
            this.ignoreSerializationField((SerializationField)object, reason);
        } else {
            throw new UnsupportedOperationException("This should never happen. Unknown object: " + object);
        }
    }

    public ScanInformation build(TypeSerializer serializer, TypeDeserializer deserializer) {
        if (serializer instanceof SerializedObjectSerializer) {
            SerializedObjectSerializer serializedObjectSerializer = (SerializedObjectSerializer)serializer;
            serializedObjectSerializer.fields().fields().forEach(this.serializationFields::remove);
        } else {
            this.serializers.remove(serializer);
        }
        this.deserializers.remove(deserializer);
        return ActualScanInformation.actualScanInformation(this.type, this.deserializationReasons, this.serializationReasons, serializer, deserializer, this.serializers, this.serializationFields, this.deserializers);
    }

    public String toString() {
        return "ScanInformationBuilder(type=" + this.type + ", deserializationReasons=" + this.deserializationReasons + ", serializationReasons=" + this.serializationReasons + ", serializers=" + this.serializers + ", serializationFields=" + this.serializationFields + ", deserializers=" + this.deserializers + ")";
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ScanInformationBuilder)) {
            return false;
        }
        ScanInformationBuilder other = (ScanInformationBuilder)o;
        TypeIdentifier this$type = this.type;
        TypeIdentifier other$type = other.type;
        if (this$type == null ? other$type != null : !this$type.equals(other$type)) {
            return false;
        }
        List<Reason> this$deserializationReasons = this.deserializationReasons;
        List<Reason> other$deserializationReasons = other.deserializationReasons;
        if (this$deserializationReasons == null ? other$deserializationReasons != null : !((Object)this$deserializationReasons).equals(other$deserializationReasons)) {
            return false;
        }
        List<Reason> this$serializationReasons = this.serializationReasons;
        List<Reason> other$serializationReasons = other.serializationReasons;
        if (this$serializationReasons == null ? other$serializationReasons != null : !((Object)this$serializationReasons).equals(other$serializationReasons)) {
            return false;
        }
        Map<TypeSerializer, List<String>> this$serializers = this.serializers;
        Map<TypeSerializer, List<String>> other$serializers = other.serializers;
        if (this$serializers == null ? other$serializers != null : !((Object)this$serializers).equals(other$serializers)) {
            return false;
        }
        Map<SerializationField, List<String>> this$serializationFields = this.serializationFields;
        Map<SerializationField, List<String>> other$serializationFields = other.serializationFields;
        if (this$serializationFields == null ? other$serializationFields != null : !((Object)this$serializationFields).equals(other$serializationFields)) {
            return false;
        }
        Map<TypeDeserializer, List<String>> this$deserializers = this.deserializers;
        Map<TypeDeserializer, List<String>> other$deserializers = other.deserializers;
        return !(this$deserializers == null ? other$deserializers != null : !((Object)this$deserializers).equals(other$deserializers));
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        TypeIdentifier $type = this.type;
        result = result * 59 + ($type == null ? 43 : $type.hashCode());
        List<Reason> $deserializationReasons = this.deserializationReasons;
        result = result * 59 + ($deserializationReasons == null ? 43 : ((Object)$deserializationReasons).hashCode());
        List<Reason> $serializationReasons = this.serializationReasons;
        result = result * 59 + ($serializationReasons == null ? 43 : ((Object)$serializationReasons).hashCode());
        Map<TypeSerializer, List<String>> $serializers = this.serializers;
        result = result * 59 + ($serializers == null ? 43 : ((Object)$serializers).hashCode());
        Map<SerializationField, List<String>> $serializationFields = this.serializationFields;
        result = result * 59 + ($serializationFields == null ? 43 : ((Object)$serializationFields).hashCode());
        Map<TypeDeserializer, List<String>> $deserializers = this.deserializers;
        result = result * 59 + ($deserializers == null ? 43 : ((Object)$deserializers).hashCode());
        return result;
    }

    private ScanInformationBuilder(TypeIdentifier type, List<Reason> deserializationReasons, List<Reason> serializationReasons, Map<TypeSerializer, List<String>> serializers, Map<SerializationField, List<String>> serializationFields, Map<TypeDeserializer, List<String>> deserializers) {
        this.type = type;
        this.deserializationReasons = deserializationReasons;
        this.serializationReasons = serializationReasons;
        this.serializers = serializers;
        this.serializationFields = serializationFields;
        this.deserializers = deserializers;
    }
}

