/*
 * Decompiled with CFR 0.152.
 */
package de.quantummaid.mapmaid.debug.scaninformation;

import de.quantummaid.mapmaid.builder.resolving.Reason;
import de.quantummaid.mapmaid.debug.Lingo;
import de.quantummaid.mapmaid.debug.scaninformation.Classification;
import de.quantummaid.mapmaid.debug.scaninformation.ScanInformation;
import de.quantummaid.mapmaid.mapper.deserialization.deserializers.TypeDeserializer;
import de.quantummaid.mapmaid.mapper.deserialization.deserializers.customprimitives.CustomPrimitiveDeserializer;
import de.quantummaid.mapmaid.mapper.deserialization.deserializers.serializedobjects.SerializedObjectDeserializer;
import de.quantummaid.mapmaid.mapper.serialization.serializers.TypeSerializer;
import de.quantummaid.mapmaid.mapper.serialization.serializers.customprimitives.CustomPrimitiveSerializer;
import de.quantummaid.mapmaid.mapper.serialization.serializers.serializedobject.SerializationField;
import de.quantummaid.mapmaid.mapper.serialization.serializers.serializedobject.SerializedObjectSerializer;
import de.quantummaid.mapmaid.shared.identifier.TypeIdentifier;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

public final class ActualScanInformation
implements ScanInformation {
    private final TypeIdentifier type;
    private final List<Reason> deserializationReasons;
    private final List<Reason> serializationReasons;
    private final TypeSerializer serializer;
    private final TypeDeserializer deserializer;
    private final Map<TypeSerializer, List<String>> ignoredSerializers;
    private final Map<SerializationField, List<String>> serializationFields;
    private final Map<TypeDeserializer, List<String>> ignoredDeserializers;

    public static ScanInformation actualScanInformation(TypeIdentifier type, List<Reason> deserializationReasons, List<Reason> serializationReasons, TypeSerializer serializer, TypeDeserializer deserializer, Map<TypeSerializer, List<String>> ignoredSerializers, Map<SerializationField, List<String>> serializationFields, Map<TypeDeserializer, List<String>> ignoredDeserializers) {
        return new ActualScanInformation(type, deserializationReasons, serializationReasons, serializer, deserializer, ignoredSerializers, serializationFields, ignoredDeserializers);
    }

    @Override
    public String render() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(this.type.description());
        stringBuilder.append(":\n");
        String mode = Lingo.mode(this.isSerializable(), this.isDeserializable());
        stringBuilder.append(String.format("Mode: %s%n", mode));
        if (this.isSerializable()) {
            stringBuilder.append("How it is serialized:\n");
            stringBuilder.append(String.format("\t%s", this.renderSerializer()));
            stringBuilder.append("\nWhy it needs to be serializable:\n");
            this.serializationReasons.forEach(reason -> stringBuilder.append(String.format("\t- %s%n", reason.render())));
            if (!this.ignoredSerializers.isEmpty()) {
                stringBuilder.append(this.renderIgnoredSerializers());
            }
        }
        if (this.isDeserializable()) {
            stringBuilder.append("How it is deserialized:\n");
            stringBuilder.append(String.format("\t%s", this.renderDeserializer()));
            stringBuilder.append("\nWhy it needs to be deserializable:\n");
            this.deserializationReasons.forEach(reason -> stringBuilder.append(String.format("\t- %s%n", reason.render())));
            if (!this.ignoredDeserializers.isEmpty()) {
                stringBuilder.append(this.renderIgnoredDeserializers());
            }
        }
        return stringBuilder.toString();
    }

    private boolean isSerializable() {
        return !this.serializationReasons.isEmpty();
    }

    private boolean isDeserializable() {
        return !this.deserializationReasons.isEmpty();
    }

    private String renderSerializer() {
        if (this.serializer == null) {
            return "No serializer available";
        }
        return this.serializer.description();
    }

    private String renderIgnoredSerializers() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("Ignored features for serialization:\n");
        this.ignoredSerializers.forEach((serializer, reasons) -> {
            String description = serializer.description();
            stringBuilder.append("\t- ");
            stringBuilder.append(description);
            stringBuilder.append("\n\t  Ignored because:\n");
            stringBuilder.append(this.renderIgnoreReasons((List<String>)reasons));
            stringBuilder.append("\n");
        });
        this.serializationFields.forEach((field, reasons) -> {
            String description = field.describe();
            stringBuilder.append("\t- ");
            stringBuilder.append(description);
            stringBuilder.append("\n\t  Ignored because:\n");
            stringBuilder.append(this.renderIgnoreReasons((List<String>)reasons));
            stringBuilder.append("\n");
        });
        return stringBuilder.toString();
    }

    private String renderIgnoredDeserializers() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("Ignored features for deserialization:\n");
        this.ignoredDeserializers.forEach((deserializer, reasons) -> {
            String description = deserializer.description();
            stringBuilder.append("\t- ");
            stringBuilder.append(description);
            stringBuilder.append("\n\t  Ignored because:\n");
            stringBuilder.append(this.renderIgnoreReasons((List<String>)reasons));
            stringBuilder.append("\n");
        });
        return stringBuilder.toString();
    }

    private String renderIgnoreReasons(List<String> reasons) {
        if (reasons.isEmpty()) {
            return "\t\t- not known";
        }
        return reasons.stream().map(s2 -> "\t\t- " + s2).collect(Collectors.joining("\n"));
    }

    private String renderDeserializer() {
        if (this.deserializer == null) {
            return "No deserializer available";
        }
        return this.deserializer.description();
    }

    @Override
    public Classification classification() {
        if (this.deserializer != null) {
            if (this.deserializer instanceof SerializedObjectDeserializer) {
                return Classification.SERIALIZED_OBJECT;
            }
            if (this.deserializer instanceof CustomPrimitiveDeserializer) {
                return Classification.CUSTOM_PRIMITIVE;
            }
            return Classification.OTHER;
        }
        if (this.serializer != null) {
            if (this.serializer instanceof SerializedObjectSerializer) {
                return Classification.SERIALIZED_OBJECT;
            }
            if (this.serializer instanceof CustomPrimitiveSerializer) {
                return Classification.SERIALIZED_OBJECT;
            }
            return Classification.OTHER;
        }
        throw new UnsupportedOperationException("Unable to do classification");
    }

    public String toString() {
        return "ActualScanInformation(type=" + this.type + ", deserializationReasons=" + this.deserializationReasons + ", serializationReasons=" + this.serializationReasons + ", serializer=" + this.serializer + ", deserializer=" + this.deserializer + ", ignoredSerializers=" + this.ignoredSerializers + ", serializationFields=" + this.serializationFields + ", ignoredDeserializers=" + this.ignoredDeserializers + ")";
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ActualScanInformation)) {
            return false;
        }
        ActualScanInformation other = (ActualScanInformation)o;
        TypeIdentifier this$type = this.type;
        TypeIdentifier other$type = other.type;
        if (this$type == null ? other$type != null : !this$type.equals(other$type)) {
            return false;
        }
        List<Reason> this$deserializationReasons = this.deserializationReasons;
        List<Reason> other$deserializationReasons = other.deserializationReasons;
        if (this$deserializationReasons == null ? other$deserializationReasons != null : !((Object)this$deserializationReasons).equals(other$deserializationReasons)) {
            return false;
        }
        List<Reason> this$serializationReasons = this.serializationReasons;
        List<Reason> other$serializationReasons = other.serializationReasons;
        if (this$serializationReasons == null ? other$serializationReasons != null : !((Object)this$serializationReasons).equals(other$serializationReasons)) {
            return false;
        }
        TypeSerializer this$serializer = this.serializer;
        TypeSerializer other$serializer = other.serializer;
        if (this$serializer == null ? other$serializer != null : !this$serializer.equals(other$serializer)) {
            return false;
        }
        TypeDeserializer this$deserializer = this.deserializer;
        TypeDeserializer other$deserializer = other.deserializer;
        if (this$deserializer == null ? other$deserializer != null : !this$deserializer.equals(other$deserializer)) {
            return false;
        }
        Map<TypeSerializer, List<String>> this$ignoredSerializers = this.ignoredSerializers;
        Map<TypeSerializer, List<String>> other$ignoredSerializers = other.ignoredSerializers;
        if (this$ignoredSerializers == null ? other$ignoredSerializers != null : !((Object)this$ignoredSerializers).equals(other$ignoredSerializers)) {
            return false;
        }
        Map<SerializationField, List<String>> this$serializationFields = this.serializationFields;
        Map<SerializationField, List<String>> other$serializationFields = other.serializationFields;
        if (this$serializationFields == null ? other$serializationFields != null : !((Object)this$serializationFields).equals(other$serializationFields)) {
            return false;
        }
        Map<TypeDeserializer, List<String>> this$ignoredDeserializers = this.ignoredDeserializers;
        Map<TypeDeserializer, List<String>> other$ignoredDeserializers = other.ignoredDeserializers;
        return !(this$ignoredDeserializers == null ? other$ignoredDeserializers != null : !((Object)this$ignoredDeserializers).equals(other$ignoredDeserializers));
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        TypeIdentifier $type = this.type;
        result = result * 59 + ($type == null ? 43 : $type.hashCode());
        List<Reason> $deserializationReasons = this.deserializationReasons;
        result = result * 59 + ($deserializationReasons == null ? 43 : ((Object)$deserializationReasons).hashCode());
        List<Reason> $serializationReasons = this.serializationReasons;
        result = result * 59 + ($serializationReasons == null ? 43 : ((Object)$serializationReasons).hashCode());
        TypeSerializer $serializer = this.serializer;
        result = result * 59 + ($serializer == null ? 43 : $serializer.hashCode());
        TypeDeserializer $deserializer = this.deserializer;
        result = result * 59 + ($deserializer == null ? 43 : $deserializer.hashCode());
        Map<TypeSerializer, List<String>> $ignoredSerializers = this.ignoredSerializers;
        result = result * 59 + ($ignoredSerializers == null ? 43 : ((Object)$ignoredSerializers).hashCode());
        Map<SerializationField, List<String>> $serializationFields = this.serializationFields;
        result = result * 59 + ($serializationFields == null ? 43 : ((Object)$serializationFields).hashCode());
        Map<TypeDeserializer, List<String>> $ignoredDeserializers = this.ignoredDeserializers;
        result = result * 59 + ($ignoredDeserializers == null ? 43 : ((Object)$ignoredDeserializers).hashCode());
        return result;
    }

    private ActualScanInformation(TypeIdentifier type, List<Reason> deserializationReasons, List<Reason> serializationReasons, TypeSerializer serializer, TypeDeserializer deserializer, Map<TypeSerializer, List<String>> ignoredSerializers, Map<SerializationField, List<String>> serializationFields, Map<TypeDeserializer, List<String>> ignoredDeserializers) {
        this.type = type;
        this.deserializationReasons = deserializationReasons;
        this.serializationReasons = serializationReasons;
        this.serializer = serializer;
        this.deserializer = deserializer;
        this.ignoredSerializers = ignoredSerializers;
        this.serializationFields = serializationFields;
        this.ignoredDeserializers = ignoredDeserializers;
    }
}

