/*
 * Decompiled with CFR 0.152.
 */
package de.quantummaid.mapmaid.mapper.definitions;

import de.quantummaid.mapmaid.debug.DebugInformation;
import de.quantummaid.mapmaid.debug.MapMaidException;
import de.quantummaid.mapmaid.debug.scaninformation.ScanInformation;
import de.quantummaid.mapmaid.mapper.definitions.Definition;
import de.quantummaid.mapmaid.mapper.definitions.DefinitionNotFoundException;
import de.quantummaid.mapmaid.shared.identifier.TypeIdentifier;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Optional;

public final class Definitions {
    private final Map<TypeIdentifier, Definition> definitions;
    private final DebugInformation debugInformation;

    public static Definitions definitions(Map<TypeIdentifier, Definition> definitions, DebugInformation debugInformation) {
        Definitions definitionsObject = new Definitions(definitions, debugInformation);
        definitionsObject.validateNoUnsupportedOutgoingReferences(debugInformation);
        return definitionsObject;
    }

    public Definition getDefinitionForType(TypeIdentifier targetType) {
        return this.getOptionalDefinitionForType(targetType).orElseThrow(() -> DefinitionNotFoundException.definitionNotFound(targetType, this.debugInformation.dumpAll()));
    }

    public Optional<Definition> getOptionalDefinitionForType(TypeIdentifier targetType) {
        if (!this.definitions.containsKey(targetType)) {
            return Optional.empty();
        }
        return Optional.of(this.definitions.get(targetType));
    }

    private void validateNoUnsupportedOutgoingReferences(DebugInformation debugInformation) {
        this.definitions.values().forEach(definition -> {
            if (definition.deserializer().isPresent()) {
                this.validateDeserialization(definition.type(), definition.type(), new ArrayList<TypeIdentifier>(this.definitions.size()), debugInformation);
            }
            if (definition.serializer().isPresent()) {
                this.validateSerialization(definition.type(), definition.type(), new ArrayList<TypeIdentifier>(this.definitions.size()));
            }
        });
    }

    private void validateDeserialization(TypeIdentifier candidate, TypeIdentifier reason, List<TypeIdentifier> alreadyVisited, DebugInformation debugInformation) {
        if (alreadyVisited.contains(candidate)) {
            return;
        }
        alreadyVisited.add(candidate);
        Definition definition = this.getOptionalDefinitionForType(candidate).orElseThrow(() -> {
            ScanInformation candidateInformation = debugInformation.scanInformationFor(candidate);
            ScanInformation reasonInformation = debugInformation.scanInformationFor(reason);
            return MapMaidException.mapMaidException(String.format("Type '%s' is not registered but needs to be in order to support deserialization of '%s'", candidate.description(), reason.description()), candidateInformation, reasonInformation);
        });
        if (definition.deserializer().isEmpty()) {
            throw new UnsupportedOperationException(String.format("'%s' is not deserializable but needs to be in order to support deserialization of '%s'", candidate.description(), reason.description()));
        }
        definition.deserializer().get().requiredTypes().forEach(type -> this.validateDeserialization((TypeIdentifier)type, reason, alreadyVisited, debugInformation));
    }

    private void validateSerialization(TypeIdentifier candidate, TypeIdentifier reason, List<TypeIdentifier> alreadyVisited) {
        if (alreadyVisited.contains(candidate)) {
            return;
        }
        alreadyVisited.add(candidate);
        Definition definition = this.getOptionalDefinitionForType(candidate).orElseThrow(() -> new UnsupportedOperationException(String.format("Type '%s' is not registered but needs to be in order to support serialization of '%s'", candidate.description(), reason.description())));
        if (definition.serializer().isEmpty()) {
            throw new UnsupportedOperationException(String.format("'%s' is not serializable but needs to be in order to support serialization of '%s'", candidate.description(), reason.description()));
        }
        definition.serializer().get().requiredTypes().forEach(type -> this.validateSerialization((TypeIdentifier)type, reason, alreadyVisited));
    }

    public String toString() {
        return "Definitions(definitions=" + this.definitions + ", debugInformation=" + this.debugInformation + ")";
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Definitions)) {
            return false;
        }
        Definitions other = (Definitions)o;
        Map<TypeIdentifier, Definition> this$definitions = this.definitions;
        Map<TypeIdentifier, Definition> other$definitions = other.definitions;
        if (this$definitions == null ? other$definitions != null : !((Object)this$definitions).equals(other$definitions)) {
            return false;
        }
        DebugInformation this$debugInformation = this.debugInformation;
        DebugInformation other$debugInformation = other.debugInformation;
        return !(this$debugInformation == null ? other$debugInformation != null : !((Object)this$debugInformation).equals(other$debugInformation));
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Map<TypeIdentifier, Definition> $definitions = this.definitions;
        result = result * 59 + ($definitions == null ? 43 : ((Object)$definitions).hashCode());
        DebugInformation $debugInformation = this.debugInformation;
        result = result * 59 + ($debugInformation == null ? 43 : ((Object)$debugInformation).hashCode());
        return result;
    }

    private Definitions(Map<TypeIdentifier, Definition> definitions, DebugInformation debugInformation) {
        this.definitions = definitions;
        this.debugInformation = debugInformation;
    }
}

