/*
 * Decompiled with CFR 0.152.
 */
package de.quantummaid.mapmaid.mapper.deserialization;

import de.quantummaid.mapmaid.debug.DebugInformation;
import de.quantummaid.mapmaid.debug.MapMaidException;
import de.quantummaid.mapmaid.debug.scaninformation.ScanInformation;
import de.quantummaid.mapmaid.mapper.definitions.Definition;
import de.quantummaid.mapmaid.mapper.definitions.Definitions;
import de.quantummaid.mapmaid.mapper.deserialization.DeserializerCallback;
import de.quantummaid.mapmaid.mapper.deserialization.deserializers.TypeDeserializer;
import de.quantummaid.mapmaid.mapper.deserialization.validation.ExceptionTracker;
import de.quantummaid.mapmaid.mapper.deserialization.validation.ValidationErrorsMapping;
import de.quantummaid.mapmaid.mapper.deserialization.validation.ValidationResult;
import de.quantummaid.mapmaid.mapper.injector.Injector;
import de.quantummaid.mapmaid.mapper.universal.Universal;
import de.quantummaid.mapmaid.mapper.universal.UniversalInjection;
import de.quantummaid.mapmaid.shared.identifier.TypeIdentifier;
import de.quantummaid.mapmaid.shared.mapping.CustomPrimitiveMappings;
import de.quantummaid.mapmaid.shared.validators.NotNullValidator;
import java.util.Optional;

final class InternalDeserializer
implements DeserializerCallback {
    private final Definitions definitions;
    private final CustomPrimitiveMappings customPrimitiveMappings;
    private final ValidationErrorsMapping onValidationErrors;

    static InternalDeserializer internalDeserializer(Definitions definitions, CustomPrimitiveMappings customPrimitiveMappings, ValidationErrorsMapping validationErrorsMapping) {
        NotNullValidator.validateNotNull(definitions, "definitions");
        NotNullValidator.validateNotNull(customPrimitiveMappings, "customPrimitiveMappings");
        NotNullValidator.validateNotNull(validationErrorsMapping, "validationErrorsMapping");
        return new InternalDeserializer(definitions, customPrimitiveMappings, validationErrorsMapping);
    }

    <T> T deserialize(Universal input, TypeIdentifier targetType, ExceptionTracker exceptionTracker, Injector injector, DebugInformation debugInformation) {
        Object result = this.deserializeRecursive(input, targetType, exceptionTracker, injector, debugInformation);
        ValidationResult validationResult = exceptionTracker.validationResult();
        if (validationResult.hasValidationErrors()) {
            this.onValidationErrors.map(validationResult.validationErrors());
        }
        return (T)result;
    }

    @Override
    public Object deserializeRecursive(Universal input, TypeIdentifier targetType, ExceptionTracker exceptionTracker, Injector injector, DebugInformation debugInformation) {
        Optional<Object> namedDirectInjection = injector.getDirectInjectionForPropertyPath(exceptionTracker.getPosition());
        if (namedDirectInjection.isPresent()) {
            return namedDirectInjection.get();
        }
        Optional<Object> typedDirectInjection = injector.getDirectInjectionForType(targetType);
        if (typedDirectInjection.isPresent()) {
            return typedDirectInjection.get();
        }
        if (input instanceof UniversalInjection) {
            return input.toNativeJava();
        }
        Universal resolved = injector.getUniversalInjectionFor(exceptionTracker.getPosition()).orElse(input);
        Definition definition = this.definitions.getDefinitionForType(targetType);
        TypeDeserializer deserializer = definition.deserializer().orElseThrow(() -> {
            ScanInformation scanInformation = debugInformation.scanInformationFor(targetType);
            return MapMaidException.mapMaidException(String.format("No deserializer configured for '%s'", definition.type().description()), scanInformation);
        });
        return deserializer.deserialize(resolved, exceptionTracker, injector, this, this.customPrimitiveMappings, targetType, debugInformation);
    }

    private InternalDeserializer(Definitions definitions, CustomPrimitiveMappings customPrimitiveMappings, ValidationErrorsMapping onValidationErrors) {
        this.definitions = definitions;
        this.customPrimitiveMappings = customPrimitiveMappings;
        this.onValidationErrors = onValidationErrors;
    }
}

