/*
 * Decompiled with CFR 0.152.
 */
package de.quantummaid.mapmaid.mapper.deserialization;

import de.quantummaid.mapmaid.debug.MapMaidException;
import de.quantummaid.mapmaid.debug.scaninformation.ScanInformation;
import de.quantummaid.mapmaid.mapper.universal.Universal;
import de.quantummaid.mapmaid.shared.validators.NotNullValidator;

public final class WrongInputStructureException
extends RuntimeException {
    private WrongInputStructureException(String message) {
        super(message);
    }

    public static MapMaidException wrongInputStructureException(Class<? extends Universal> expected, Universal actual, String location, ScanInformation ... scanInformations) {
        NotNullValidator.validateNotNull(expected, "expected");
        NotNullValidator.validateNotNull(actual, "actual");
        NotNullValidator.validateNotNull(location, "location");
        String message = String.format("Requiring the input to be an '%s' but found '%s' at '%s'", Universal.describe(expected), actual.toNativeJava(), location);
        return MapMaidException.mapMaidException(message, scanInformations);
    }
}

